/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.internal.osgi.weaving;

import java.io.IOException;
import java.io.InputStream;
import java.lang.instrument.IllegalClassFormatException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.objectteams.internal.osgi.weaving.ASMByteCodeAnalyzer;
import org.eclipse.objectteams.internal.osgi.weaving.AspectBinding;
import org.eclipse.objectteams.internal.osgi.weaving.AspectBindingRegistry;
import org.eclipse.objectteams.internal.osgi.weaving.AspectPermissionManager;
import org.eclipse.objectteams.internal.osgi.weaving.BCELPatcher;
import org.eclipse.objectteams.internal.osgi.weaving.BaseBundleLoadTrigger;
import org.eclipse.objectteams.internal.osgi.weaving.DelegatingTransformer;
import org.eclipse.objectteams.internal.osgi.weaving.TeamLoader;
import org.eclipse.objectteams.internal.osgi.weaving.Util;
import org.eclipse.objectteams.internal.osgi.weaving.WaitingTeamRecord;
import org.eclipse.objectteams.otequinox.TransformerPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.hooks.weaving.WeavingHook;
import org.osgi.framework.hooks.weaving.WovenClass;
import org.osgi.framework.hooks.weaving.WovenClassListener;
import org.osgi.framework.wiring.BundleWiring;
import org.osgi.resource.Wire;
import org.osgi.service.packageadmin.PackageAdmin;

public class OTWeavingHook
implements WeavingHook,
WovenClassListener {
    boolean useDynamicWeaver = "dynamic".equals(System.getProperty("ot.weaving"));
    boolean skipBaseClassCheck = "skip".equals(System.getProperty("otequinox.baseClassChecks"));
    private static final String LIFTING_PARTICIPANT_FIELD = "_OT$liftingParticipant";
    @NonNull
    private AspectBindingRegistry aspectBindingRegistry = new AspectBindingRegistry();
    @NonNull
    private HashMap<String, BaseBundleLoadTrigger> baseTripWires = new HashMap();
    @NonNull
    private Set<String> beingDefined = new HashSet<String>();
    @NonNull
    private List<WaitingTeamRecord> deferredTeams = new ArrayList<WaitingTeamRecord>();
    @NonNull
    private ASMByteCodeAnalyzer byteCodeAnalyzer = new ASMByteCodeAnalyzer();
    private AspectPermissionManager permissionManager;
    @Nullable
    private IConfigurationElement liftingParticipantConfig;
    @Nullable
    private Class<?> ooTeam;

    public void activate(@NonNull BundleContext bundleContext, ServiceReference<IExtensionRegistry> serviceReference) {
        this.loadAspectBindingRegistry(bundleContext, serviceReference);
        TransformerPlugin.initialize(bundleContext, this.aspectBindingRegistry, this.permissionManager);
    }

    private void loadAspectBindingRegistry(BundleContext context, ServiceReference<IExtensionRegistry> serviceReference) {
        PackageAdmin packageAdmin = null;
        ServiceReference ref = context.getServiceReference(PackageAdmin.class.getName());
        if (ref != null) {
            packageAdmin = (PackageAdmin)context.getService(ref);
        } else {
            TransformerPlugin.log(4, "Failed to load PackageAdmin service. Will not be able to handle fragments.");
        }
        IExtensionRegistry extensionRegistry = (IExtensionRegistry)context.getService(serviceReference);
        if (extensionRegistry == null) {
            TransformerPlugin.log(4, "Failed to acquire ExtensionRegistry service, cannot load aspect bindings.");
        } else {
            this.permissionManager = new AspectPermissionManager(context.getBundle(), packageAdmin);
            this.permissionManager.loadAspectBindingNegotiators(extensionRegistry);
            this.aspectBindingRegistry.loadAspectBindings(extensionRegistry, packageAdmin, this);
            this.loadLiftingParticipant(extensionRegistry);
        }
    }

    @NonNull
    public AspectPermissionManager getAspectPermissionManager() {
        AspectPermissionManager manager = this.permissionManager;
        if (manager == null) {
            throw new NullPointerException("Missing AspectPermissionManager");
        }
        return manager;
    }

    private void loadLiftingParticipant(IExtensionRegistry extensionRegistry) {
        IConfigurationElement[] liftingParticipantConfigs = extensionRegistry.getConfigurationElementsFor("org.eclipse.objectteams.otequinox", "liftingParticipant");
        if (liftingParticipantConfigs.length != 1) {
            if (liftingParticipantConfigs.length > 1) {
                TransformerPlugin.log(4, "Cannot install more than one lifting participant.");
            }
            return;
        }
        this.liftingParticipantConfig = liftingParticipantConfigs[0];
        this.installLiftingParticipant();
    }

    private void installLiftingParticipant() {
        Class<?> teamClass = this.ooTeam;
        IConfigurationElement config = this.liftingParticipantConfig;
        if (teamClass != null && config != null) {
            try {
                Field field = teamClass.getDeclaredField(LIFTING_PARTICIPANT_FIELD);
                field.set(null, config.createExecutableExtension("class"));
                TransformerPlugin.log(1, "Registered Lifting Participant from " + config.getContributor().getName());
            }
            catch (Exception e) {
                TransformerPlugin.log(e, "Failed to install lifting participant from " + config.getContributor().getName());
            }
            this.liftingParticipantConfig = null;
        }
    }

    void setBaseTripWire(@Nullable PackageAdmin packageAdmin, @NonNull String baseBundleId, AspectBinding.BaseBundle baseBundle) {
        if (!this.baseTripWires.containsKey(baseBundleId)) {
            this.baseTripWires.put(baseBundleId, new BaseBundleLoadTrigger(baseBundleId, baseBundle, this.aspectBindingRegistry, packageAdmin));
        }
    }

    boolean triggerBaseTripWires(@Nullable String bundleName, @NonNull WovenClass baseClass) {
        BaseBundleLoadTrigger activation = this.baseTripWires.get(bundleName);
        if (activation != null) {
            activation.fire(baseClass, this.beingDefined, this);
            if (activation.isDone()) {
                this.baseTripWires.remove(bundleName);
            }
            return activation.areAllAspectsDenied();
        }
        return false;
    }

    public void weave(WovenClass wovenClass) {
        block14: {
            this.beingDefined.add(wovenClass.getClassName());
            try {
                BundleWiring bundleWiring = wovenClass.getBundleWiring();
                String bundleName = bundleWiring.getBundle().getSymbolicName();
                String className = wovenClass.getClassName();
                if (bundleName.equals("org.eclipse.objectteams.otequinox") || bundleName.startsWith("org.eclipse.objectteams.otre") || bundleName.equals("org.objectweb.asm")) {
                    return;
                }
                if ("org.apache.bcel".equals(bundleName)) {
                    BCELPatcher.fixBCEL(wovenClass);
                    return;
                }
                byte[] bytes = wovenClass.getBytes();
                WeavingReason reason = this.requiresWeaving(bundleWiring, className, bytes);
                if (reason == WeavingReason.None) break block14;
                boolean allAspectsAreDenied = this.triggerBaseTripWires(bundleName, wovenClass);
                if (reason == WeavingReason.Base && allAspectsAreDenied) {
                    return;
                }
                if (reason == WeavingReason.Thread) {
                    AspectBinding.BaseBundle baseBundle = this.aspectBindingRegistry.getBaseBundle(bundleName);
                    BaseBundleLoadTrigger.addOTREImport(baseBundle, bundleName, wovenClass, this.useDynamicWeaver);
                }
                long time = 0L;
                DelegatingTransformer transformer = DelegatingTransformer.newTransformer(this.useDynamicWeaver, this, bundleWiring);
                Class<?> classBeingRedefined = null;
                try {
                    byte[] newBytes;
                    TransformerPlugin.log(0, "About to transform class " + className);
                    time = 0L;
                    if (Util.PROFILE) {
                        time = System.nanoTime();
                    }
                    if ((newBytes = transformer.transform(bundleWiring.getBundle(), className, classBeingRedefined, null, bytes)) != null && newBytes != bytes && !Arrays.equals(newBytes, bytes)) {
                        if (Util.PROFILE) {
                            Util.profile(time, Util.ProfileKind.Transformation, className);
                        }
                        TransformerPlugin.log(1, "Transformation performed on " + className);
                        wovenClass.setBytes(newBytes);
                        if (reason == WeavingReason.Aspect) {
                            this.recordBaseClasses(transformer, bundleName, className);
                        }
                    } else if (Util.PROFILE) {
                        Util.profile(time, Util.ProfileKind.NoTransformation, className);
                    }
                }
                catch (IllegalClassFormatException e) {
                    TransformerPlugin.log(e, "Failed to transform class " + className);
                }
            }
            catch (ClassCircularityError cce) {
                TransformerPlugin.log(cce, "Weaver encountered a circular class dependency");
            }
        }
    }

    WeavingReason requiresWeaving(BundleWiring bundleWiring, String className, byte[] bytes) {
        Bundle bundle = bundleWiring.getBundle();
        if (this.aspectBindingRegistry.getAdaptedBasePlugins(bundle) != null) {
            return WeavingReason.Aspect;
        }
        List<AspectBinding> aspectBindings = this.aspectBindingRegistry.getAdaptingAspectBindings(bundle.getSymbolicName());
        if (aspectBindings != null && !aspectBindings.isEmpty()) {
            for (AspectBinding aspectBinding : aspectBindings) {
                if (aspectBinding.hasScannedTeams || aspectBinding.hasBeenDenied) continue;
                return WeavingReason.Base;
            }
            if (this.isAdaptedBaseClass(aspectBindings, className, bytes, bundleWiring.getClassLoader())) {
                return WeavingReason.Base;
            }
        }
        long time = 0L;
        if (Util.PROFILE) {
            time = System.nanoTime();
        }
        if (this.needsThreadNotificationCode(className, bytes, bundleWiring.getClassLoader())) {
            return WeavingReason.Thread;
        }
        if (Util.PROFILE) {
            Util.profile(time, Util.ProfileKind.SuperClassFetching, "");
        }
        return WeavingReason.None;
    }

    boolean isAdaptedBaseClass(List<AspectBinding> aspectBindings, String className, byte[] bytes, ClassLoader resourceLoader) {
        if (this.skipBaseClassCheck) {
            return true;
        }
        if ("java.lang.Object".equals(className)) {
            return false;
        }
        long start = 0L;
        if (Util.PROFILE) {
            start = System.nanoTime();
        }
        try {
            for (AspectBinding aspectBinding : aspectBindings) {
                if (!aspectBinding.allBaseClassNames.contains(className) || aspectBinding.hasBeenDenied) continue;
                return true;
            }
            ASMByteCodeAnalyzer.ClassInformation classInfo = null;
            if (bytes != null) {
                classInfo = this.byteCodeAnalyzer.getClassInformation(bytes, className);
            } else {
                try {
                    Object object = null;
                    Object var9_10 = null;
                    try (InputStream is = resourceLoader.getResourceAsStream(String.valueOf(className.replace('.', '/')) + ".class");){
                        if (is != null) {
                            classInfo = this.byteCodeAnalyzer.getClassInformation(is, className);
                        }
                    }
                    catch (Throwable throwable) {
                        if (object == null) {
                            object = throwable;
                        } else if (object != throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                        throw object;
                    }
                }
                catch (IOException e) {
                    if (bytes != null && Util.PROFILE) {
                        Util.profile(start, Util.ProfileKind.SuperClassFetching, className);
                    }
                    return false;
                }
            }
            if (classInfo != null && !classInfo.isInterface()) {
                boolean bl = this.isAdaptedBaseClass(aspectBindings, classInfo.getSuperClassName(), null, resourceLoader);
                return bl;
            }
            return false;
        }
        finally {
            if (bytes != null && Util.PROFILE) {
                Util.profile(start, Util.ProfileKind.SuperClassFetching, className);
            }
        }
    }

    private void recordBaseClasses(DelegatingTransformer transformer, @NonNull String aspectBundle, String className) {
        Collection<String> adaptedBases = transformer.fetchAdaptedBases();
        if (adaptedBases == null || adaptedBases.isEmpty()) {
            return;
        }
        List<AspectBinding> aspectBindings = this.aspectBindingRegistry.getAspectBindings(aspectBundle);
        if (aspectBindings != null) {
            for (AspectBinding aspectBinding : aspectBindings) {
                if (aspectBinding.hasScannedTeams) continue;
                AspectBinding.TeamBinding[] teamBindingArray = aspectBinding.teams;
                int n = aspectBinding.teams.length;
                int n2 = 0;
                while (n2 < n) {
                    AspectBinding.TeamBinding team = teamBindingArray[n2];
                    if (team.teamName.equals(className) && !team.hasScannedBases) {
                        for (AspectBinding.TeamBinding equivalent : team.equivalenceSet) {
                            equivalent.addBaseClassNames(adaptedBases);
                            equivalent.hasScannedBases = true;
                        }
                        return;
                    }
                    ++n2;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDeferredTeamClasses(List<WaitingTeamRecord> teamClasses) {
        List<WaitingTeamRecord> list = this.deferredTeams;
        synchronized (list) {
            this.deferredTeams.addAll(teamClasses);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void instantiateScheduledTeams(String triggerClassName) {
        ArrayList<WaitingTeamRecord> scheduledTeams = null;
        List<WaitingTeamRecord> list = this.deferredTeams;
        synchronized (list) {
            for (WaitingTeamRecord record : new ArrayList<WaitingTeamRecord>(this.deferredTeams)) {
                if (!record.notFoundClass.equals(triggerClassName)) continue;
                if (scheduledTeams == null) {
                    scheduledTeams = new ArrayList<WaitingTeamRecord>();
                }
                if (!this.deferredTeams.remove(record)) continue;
                scheduledTeams.add(record);
            }
        }
        if (scheduledTeams == null) {
            return;
        }
        for (WaitingTeamRecord record : scheduledTeams) {
            if (record.team.isActivated) continue;
            String teamName = record.team.teamName;
            TransformerPlugin.log(1, "Consider for instantiation/activation: team " + teamName);
            try {
                TeamLoader loader = new TeamLoader(this.deferredTeams, this.beingDefined, this.useDynamicWeaver);
                loader.instantiateAndActivate(record.aspectBinding, record.team, record.activationKind);
            }
            catch (Exception e) {
                TransformerPlugin.log(e, "Failed to instantiate team " + teamName);
            }
        }
    }

    public void modified(WovenClass wovenClass) {
        if (wovenClass.getState() == 4) {
            String className = wovenClass.getClassName();
            if (className.equals("org.objectteams.Team")) {
                this.ooTeam = wovenClass.getDefinedClass();
                this.installLiftingParticipant();
            }
            this.beingDefined.remove(className);
            this.instantiateScheduledTeams(className);
            TransformerPlugin.flushLog();
        }
    }

    static boolean hasImport(WovenClass clazz, String packageName, String packageWithAttribute) {
        List imports = clazz.getDynamicImports();
        for (String imp : imports) {
            if (!imp.equals(packageName) && !imp.equals(packageWithAttribute)) continue;
            return true;
        }
        for (Wire wire : clazz.getBundleWiring().getRequiredResourceWires("osgi.wiring.package")) {
            Object packageValue = wire.getRequirement().getAttributes().get("osgi.wiring.package");
            if (!packageName.equals(packageValue) && !packageWithAttribute.equals(packageValue)) continue;
            return true;
        }
        return false;
    }

    private boolean needsThreadNotificationCode(String className, byte[] bytes, ClassLoader resourceLoader) {
        if ("java.lang.Object".equals(className)) {
            return false;
        }
        ASMByteCodeAnalyzer.ClassInformation classInfo = null;
        if (bytes != null) {
            classInfo = this.byteCodeAnalyzer.getClassInformation(bytes, className);
        } else {
            try {
                Throwable throwable = null;
                Object var6_8 = null;
                try (InputStream is = resourceLoader.getResourceAsStream(String.valueOf(className.replace('.', '/')) + ".class");){
                    if (is != null) {
                        classInfo = this.byteCodeAnalyzer.getClassInformation(is, className);
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                return false;
            }
        }
        if (classInfo != null && !classInfo.isInterface()) {
            String superClassName = classInfo.getSuperClassName();
            if ("java.lang.Thread".equals(superClassName)) {
                return true;
            }
            String[] superInterfaceNames = classInfo.getSuperInterfaceNames();
            if (superInterfaceNames != null) {
                int i = 0;
                while (i < superInterfaceNames.length) {
                    if ("java.lang.Runnable".equals(superInterfaceNames[i])) {
                        return true;
                    }
                    ++i;
                }
            }
        }
        return false;
    }

    static enum WeavingReason {
        None,
        Aspect,
        Base,
        Thread;

    }
}

