/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.selection;

import java.util.Arrays;
import org.eclipse.nebula.widgets.nattable.command.ILayerCommandHandler;
import org.eclipse.nebula.widgets.nattable.coordinate.PositionCoordinate;
import org.eclipse.nebula.widgets.nattable.coordinate.PositionCoordinateComparator;
import org.eclipse.nebula.widgets.nattable.coordinate.Range;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;
import org.eclipse.nebula.widgets.nattable.selection.SelectionUtils;
import org.eclipse.nebula.widgets.nattable.selection.command.SelectRegionCommand;
import org.eclipse.nebula.widgets.nattable.selection.event.RowSelectionEvent;
import org.eclipse.swt.graphics.Rectangle;

public class SelectRegionCommandHandler
implements ILayerCommandHandler<SelectRegionCommand> {
    protected final SelectionLayer selectionLayer;

    public SelectRegionCommandHandler(SelectionLayer selectionLayer) {
        this.selectionLayer = selectionLayer;
    }

    @Override
    public boolean doCommand(ILayer targetLayer, SelectRegionCommand command) {
        if (command.convertToTargetLayer(this.selectionLayer)) {
            this.selectRegion(command.getRegion(), command.isShiftMask(), command.isControlMask(), command.getAnchorColumnPosition(), command.getAnchorRowPosition());
            return true;
        }
        return false;
    }

    protected void selectRegion(Rectangle region, boolean withShiftMask, boolean withControlMask, int anchorColumn, int anchorRow) {
        Range changedRows = null;
        if (SelectionUtils.noShiftOrControl(withShiftMask, withControlMask)) {
            this.selectionLayer.clear(false);
            this.selectionLayer.selectCell(region.x, region.y, false, false);
            this.selectionLayer.selectRegion(region.x, region.y, region.width, region.height);
            this.selectionLayer.moveSelectionAnchor(anchorColumn < 0 ? region.x : anchorColumn, anchorRow < 0 ? region.y : anchorRow);
            changedRows = new Range(region.y, region.height < Integer.MAX_VALUE ? region.y + region.height : this.selectionLayer.getRowCount() - region.y);
        } else if (SelectionUtils.bothShiftAndControl(withShiftMask, withControlMask) || SelectionUtils.isShiftOnly(withShiftMask, withControlMask)) {
            changedRows = this.selectRegionWithShiftKey(region, anchorColumn, anchorRow);
        } else if (SelectionUtils.isControlOnly(withShiftMask, withControlMask)) {
            changedRows = this.selectRegionWithCtrlKey(region, anchorColumn, anchorRow);
        }
        this.selectionLayer.setLastSelectedCell(region.x, region.y);
        this.selectionLayer.fireLayerEvent(new RowSelectionEvent(this.selectionLayer, changedRows, -1, withShiftMask, withControlMask));
    }

    protected Range selectRegionWithShiftKey(Rectangle region, int anchorColumn, int anchorRow) {
        int startCol = region.x;
        int startRow = region.y;
        int noCol = region.width;
        int noRow = region.height;
        Rectangle lastSelectedRegion = this.selectionLayer.getLastSelectedRegion();
        if (lastSelectedRegion != null) {
            this.selectionLayer.getSelectionModel().clearSelection(lastSelectedRegion);
        } else {
            this.selectionLayer.getSelectionModel().clearSelection();
        }
        PositionCoordinate anchor = this.selectionLayer.getSelectionAnchor();
        if (anchor.columnPosition != -1 && anchor.rowPosition != -1) {
            if (region.width < Integer.MAX_VALUE) {
                if (startCol < anchor.columnPosition) {
                    noCol = Math.abs(anchor.columnPosition - startCol) + 1;
                } else {
                    startCol = anchor.columnPosition;
                    noCol = region.x + region.width - anchor.columnPosition;
                }
            }
            if (region.height < Integer.MAX_VALUE) {
                if (startRow < anchor.rowPosition) {
                    noRow = Math.abs(anchor.rowPosition - startRow) + 1;
                } else {
                    startRow = anchor.rowPosition;
                    noRow = region.y + region.height - anchor.rowPosition;
                }
            }
        } else {
            this.selectionLayer.moveSelectionAnchor(anchorColumn < 0 ? startCol : anchorColumn, anchorRow < 0 ? startRow : anchorRow);
        }
        this.selectionLayer.selectRegion(startCol, startRow, noCol, noRow);
        return new Range(startRow, noRow < Integer.MAX_VALUE ? startRow + noRow : this.selectionLayer.getRowCount() - startRow);
    }

    protected Range selectRegionWithCtrlKey(Rectangle region, int anchorColumn, int anchorRow) {
        if (this.selectionLayer.allCellsSelectedInRegion(region)) {
            this.selectionLayer.clearSelection(region);
            this.selectionLayer.setLastSelectedRegion(null);
            PositionCoordinate[] selectedCells = this.selectionLayer.getSelectedCellPositions();
            if (selectedCells.length > 0 && this.selectionLayer.getSelectionAnchor().columnPosition == -1 && this.selectionLayer.getSelectionAnchor().rowPosition == -1) {
                int i;
                Arrays.sort(selectedCells, new PositionCoordinateComparator());
                PositionCoordinate toPos = null;
                if (this.selectionLayer.isColumnPositionSelected(region.x)) {
                    i = 0;
                    while (i < selectedCells.length) {
                        if (selectedCells[i].rowPosition >= region.y || selectedCells[i].columnPosition != region.x) break;
                        toPos = selectedCells[i];
                        ++i;
                    }
                }
                if (toPos == null && this.selectionLayer.isRowPositionSelected(region.y)) {
                    i = 0;
                    while (i < selectedCells.length) {
                        if (selectedCells[i].rowPosition != region.y || selectedCells[i].columnPosition >= region.x) break;
                        toPos = selectedCells[i];
                        ++i;
                    }
                }
                if (toPos == null) {
                    toPos = selectedCells[0];
                    i = 0;
                    while (i < selectedCells.length) {
                        if (selectedCells[i].rowPosition >= region.y && selectedCells[i].columnPosition >= region.x) break;
                        toPos = selectedCells[i];
                        ++i;
                    }
                }
                this.selectionLayer.moveSelectionAnchor(anchorColumn < 0 ? toPos.columnPosition : anchorColumn, anchorRow < 0 ? toPos.rowPosition : anchorRow);
            }
        } else {
            this.selectionLayer.selectRegion(region.x, region.y, region.width, region.height);
            this.selectionLayer.moveSelectionAnchor(anchorColumn < 0 ? region.x : anchorColumn, anchorRow < 0 ? region.y : anchorRow);
        }
        return new Range(region.y, region.height < Integer.MAX_VALUE ? region.y + region.height : this.selectionLayer.getRowCount() - region.y);
    }

    @Override
    public Class<SelectRegionCommand> getCommandClass() {
        return SelectRegionCommand.class;
    }
}

