/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.layer.event;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.collections.api.IntIterable;
import org.eclipse.collections.api.block.predicate.primitive.IntPredicate;
import org.eclipse.collections.api.block.procedure.primitive.IntProcedure;
import org.eclipse.collections.api.collection.primitive.MutableIntCollection;
import org.eclipse.collections.api.list.primitive.MutableIntList;
import org.eclipse.collections.impl.factory.primitive.IntLists;
import org.eclipse.nebula.widgets.nattable.coordinate.Range;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.event.StructuralDiff;

public final class StructuralChangeEventHelper {
    private StructuralChangeEventHelper() {
    }

    public static void handleRowDelete(Collection<StructuralDiff> rowDiffs, ILayer underlyingLayer, Collection<Integer> cachedRowIndexes, boolean handleNotFound) {
        int numberOfNoIndex = 0;
        ArrayList<Integer> toRemove = new ArrayList<Integer>();
        for (StructuralDiff rowDiff : rowDiffs) {
            if (rowDiff.getDiffType() == null || !rowDiff.getDiffType().equals((Object)StructuralDiff.DiffTypeEnum.DELETE)) continue;
            Range beforePositionRange = rowDiff.getBeforePositionRange();
            int i = beforePositionRange.start;
            while (i < beforePositionRange.end) {
                int index = i;
                if (index >= 0) {
                    toRemove.add(index);
                } else {
                    ++numberOfNoIndex;
                }
                ++i;
            }
        }
        cachedRowIndexes.removeAll(toRemove);
        ArrayList<Integer> modifiedRows = new ArrayList<Integer>();
        for (Integer row : cachedRowIndexes) {
            int deletedBefore = handleNotFound ? numberOfNoIndex : 0;
            for (Integer removed : toRemove) {
                if (removed >= row) continue;
                ++deletedBefore;
            }
            int modRow = row - deletedBefore;
            if (modRow < 0) continue;
            modifiedRows.add(modRow);
        }
        cachedRowIndexes.clear();
        cachedRowIndexes.addAll(modifiedRows);
    }

    public static void handleRowDelete(Collection<StructuralDiff> rowDiffs, ILayer underlyingLayer, MutableIntCollection cachedRowIndexes, boolean handleNotFound) {
        int numberOfNoIndex = 0;
        MutableIntList toRemove = IntLists.mutable.empty();
        for (StructuralDiff rowDiff : rowDiffs) {
            if (rowDiff.getDiffType() == null || !rowDiff.getDiffType().equals((Object)StructuralDiff.DiffTypeEnum.DELETE)) continue;
            Range beforePositionRange = rowDiff.getBeforePositionRange();
            int i = beforePositionRange.start;
            while (i < beforePositionRange.end) {
                int index = i;
                if (index >= 0) {
                    toRemove.add(index);
                } else {
                    ++numberOfNoIndex;
                }
                ++i;
            }
        }
        int noIndexCount = numberOfNoIndex;
        cachedRowIndexes.removeAll((IntIterable)toRemove);
        MutableIntList modifiedRows = IntLists.mutable.empty();
        cachedRowIndexes.forEach((IntProcedure & Serializable)row -> {
            int deletedBefore = handleNotFound ? noIndexCount : 0;
            int modRow = row - (deletedBefore += toRemove.count((IntPredicate & Serializable)removed -> removed < row));
            if (modRow >= 0) {
                modifiedRows.add(modRow);
            }
        });
        cachedRowIndexes.clear();
        cachedRowIndexes.addAll((IntIterable)modifiedRows);
    }

    public static void handleRowInsert(Collection<StructuralDiff> rowDiffs, ILayer underlyingLayer, Collection<Integer> cachedRowIndexes, boolean addToCache) {
        for (StructuralDiff rowDiff : rowDiffs) {
            if (rowDiff.getDiffType() == null || !rowDiff.getDiffType().equals((Object)StructuralDiff.DiffTypeEnum.ADD)) continue;
            Range beforePositionRange = rowDiff.getBeforePositionRange();
            ArrayList<Integer> modifiedRows = new ArrayList<Integer>();
            int beforeIndex = underlyingLayer.getRowIndexByPosition(beforePositionRange.start);
            for (Integer row : cachedRowIndexes) {
                if (row >= beforeIndex) {
                    modifiedRows.add(row + 1);
                    continue;
                }
                modifiedRows.add(row);
            }
            if (addToCache) {
                modifiedRows.add(beforeIndex, beforePositionRange.start);
            }
            cachedRowIndexes.clear();
            cachedRowIndexes.addAll(modifiedRows);
        }
    }

    public static void handleRowInsert(Collection<StructuralDiff> rowDiffs, ILayer underlyingLayer, MutableIntCollection cachedRowIndexes, boolean addToCache) {
        for (StructuralDiff rowDiff : rowDiffs) {
            if (rowDiff.getDiffType() == null || !rowDiff.getDiffType().equals((Object)StructuralDiff.DiffTypeEnum.ADD)) continue;
            Range beforePositionRange = rowDiff.getBeforePositionRange();
            MutableIntList modifiedRows = IntLists.mutable.empty();
            int beforeIndex = underlyingLayer.getRowIndexByPosition(beforePositionRange.start);
            cachedRowIndexes.forEach((IntProcedure & Serializable)row -> {
                if (row >= beforeIndex) {
                    modifiedRows.add(row + 1);
                } else {
                    modifiedRows.add(row);
                }
            });
            if (addToCache) {
                modifiedRows.addAtIndex(beforeIndex, beforePositionRange.start);
            }
            cachedRowIndexes.clear();
            cachedRowIndexes.addAll((IntIterable)modifiedRows);
        }
    }

    public static void handleColumnDelete(Collection<StructuralDiff> columnDiffs, ILayer underlyingLayer, Collection<Integer> cachedColumnIndexes, boolean handleNotFound) {
        int numberOfNoIndex = 0;
        ArrayList<Integer> toRemove = new ArrayList<Integer>();
        for (StructuralDiff columnDiff : columnDiffs) {
            if (columnDiff.getDiffType() == null || !columnDiff.getDiffType().equals((Object)StructuralDiff.DiffTypeEnum.DELETE)) continue;
            Range beforePositionRange = columnDiff.getBeforePositionRange();
            int i = beforePositionRange.start;
            while (i < beforePositionRange.end) {
                int index = i;
                if (index >= 0) {
                    toRemove.add(index);
                } else {
                    ++numberOfNoIndex;
                }
                ++i;
            }
        }
        cachedColumnIndexes.removeAll(toRemove);
        ArrayList<Integer> modifiedColumns = new ArrayList<Integer>();
        for (Integer column : cachedColumnIndexes) {
            int deletedBefore = handleNotFound ? numberOfNoIndex : 0;
            for (Integer removed : toRemove) {
                if (removed >= column) continue;
                ++deletedBefore;
            }
            int modColumn = column - deletedBefore;
            if (modColumn < 0) continue;
            modifiedColumns.add(modColumn);
        }
        cachedColumnIndexes.clear();
        cachedColumnIndexes.addAll(modifiedColumns);
    }

    public static void handleColumnDelete(Collection<StructuralDiff> columnDiffs, ILayer underlyingLayer, MutableIntCollection cachedColumnIndexes, boolean handleNotFound) {
        int numberOfNoIndex = 0;
        MutableIntList toRemove = IntLists.mutable.empty();
        for (StructuralDiff columnDiff : columnDiffs) {
            if (columnDiff.getDiffType() == null || !columnDiff.getDiffType().equals((Object)StructuralDiff.DiffTypeEnum.DELETE)) continue;
            Range beforePositionRange = columnDiff.getBeforePositionRange();
            int i = beforePositionRange.start;
            while (i < beforePositionRange.end) {
                int index = i;
                if (index >= 0) {
                    toRemove.add(index);
                } else {
                    ++numberOfNoIndex;
                }
                ++i;
            }
        }
        int noIndexCount = numberOfNoIndex;
        cachedColumnIndexes.removeAll((IntIterable)toRemove);
        MutableIntList modifiedColumns = IntLists.mutable.empty();
        cachedColumnIndexes.forEach((IntProcedure & Serializable)column -> {
            int deletedBefore = handleNotFound ? noIndexCount : 0;
            int modColumn = column - (deletedBefore += toRemove.count((IntPredicate & Serializable)removed -> removed < column));
            if (modColumn >= 0) {
                modifiedColumns.add(modColumn);
            }
        });
        cachedColumnIndexes.clear();
        cachedColumnIndexes.addAll((IntIterable)modifiedColumns);
    }

    public static void handleColumnInsert(Collection<StructuralDiff> columnDiffs, ILayer underlyingLayer, Collection<Integer> cachedColumnIndexes, boolean addToCache) {
        for (StructuralDiff columnDiff : columnDiffs) {
            if (columnDiff.getDiffType() == null || !columnDiff.getDiffType().equals((Object)StructuralDiff.DiffTypeEnum.ADD)) continue;
            Range beforePositionRange = columnDiff.getBeforePositionRange();
            ArrayList<Integer> modifiedColumns = new ArrayList<Integer>();
            int beforeIndex = underlyingLayer.getColumnIndexByPosition(beforePositionRange.start);
            for (Integer column : cachedColumnIndexes) {
                if (column >= beforeIndex) {
                    modifiedColumns.add(column + 1);
                    continue;
                }
                modifiedColumns.add(column);
            }
            if (addToCache) {
                modifiedColumns.add(beforeIndex, beforePositionRange.start);
            }
            cachedColumnIndexes.clear();
            cachedColumnIndexes.addAll(modifiedColumns);
        }
    }

    public static void handleColumnInsert(Collection<StructuralDiff> columnDiffs, ILayer underlyingLayer, MutableIntCollection cachedColumnIndexes, boolean addToCache) {
        for (StructuralDiff columnDiff : columnDiffs) {
            if (columnDiff.getDiffType() == null || !columnDiff.getDiffType().equals((Object)StructuralDiff.DiffTypeEnum.ADD)) continue;
            Range beforePositionRange = columnDiff.getBeforePositionRange();
            MutableIntList modifiedColumns = IntLists.mutable.empty();
            int beforeIndex = underlyingLayer.getColumnIndexByPosition(beforePositionRange.start);
            cachedColumnIndexes.forEach((IntProcedure & Serializable)column -> {
                if (column >= beforeIndex) {
                    modifiedColumns.add(column + 1);
                } else {
                    modifiedColumns.add(column);
                }
            });
            if (addToCache) {
                modifiedColumns.addAtIndex(beforeIndex, beforePositionRange.start);
            }
            cachedColumnIndexes.clear();
            cachedColumnIndexes.addAll((IntIterable)modifiedColumns);
        }
    }

    public static boolean isReorder(Collection<StructuralDiff> structuralDiffs) {
        if (structuralDiffs != null && structuralDiffs.size() % 2 == 0) {
            int numberOfDeleteCols = 0;
            int numberOfInsertCols = 0;
            for (StructuralDiff columnDiff : structuralDiffs) {
                if (columnDiff.getDiffType() != null && columnDiff.getDiffType().equals((Object)StructuralDiff.DiffTypeEnum.DELETE)) {
                    numberOfDeleteCols = columnDiff.getBeforePositionRange().end - columnDiff.getBeforePositionRange().start;
                }
                if (columnDiff.getDiffType() == null || !columnDiff.getDiffType().equals((Object)StructuralDiff.DiffTypeEnum.ADD)) continue;
                numberOfInsertCols = columnDiff.getAfterPositionRange().end - columnDiff.getAfterPositionRange().start;
            }
            if (numberOfDeleteCols == numberOfInsertCols) {
                return true;
            }
        }
        return false;
    }
}

