/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.extension.glazedlists.filterrow;

import ca.odell.glazedlists.FilterList;
import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.matchers.CompositeMatcherEditor;
import ca.odell.glazedlists.matchers.Matcher;
import ca.odell.glazedlists.matchers.MatcherEditor;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.data.IColumnAccessor;
import org.eclipse.nebula.widgets.nattable.extension.glazedlists.filterrow.DefaultGlazedListsFilterStrategy;
import org.eclipse.nebula.widgets.nattable.filterrow.IActivatableFilterStrategy;

public class DefaultGlazedListsStaticFilterStrategy<T>
extends DefaultGlazedListsFilterStrategy<T>
implements IActivatableFilterStrategy<T> {
    protected Map<Matcher<T>, MatcherEditor<T>> staticMatcherEditor = new HashMap<Matcher<T>, MatcherEditor<T>>();
    private boolean active = true;

    public DefaultGlazedListsStaticFilterStrategy(FilterList<T> filterList, IColumnAccessor<T> columnAccessor, IConfigRegistry configRegistry) {
        super(filterList, columnAccessor, configRegistry);
    }

    public DefaultGlazedListsStaticFilterStrategy(FilterList<T> filterList, CompositeMatcherEditor<T> matcherEditor, IColumnAccessor<T> columnAccessor, IConfigRegistry configRegistry) {
        super(filterList, matcherEditor, columnAccessor, configRegistry);
    }

    @Override
    public void applyFilter(Map<Integer, Object> filterIndexToObjectMap) {
        super.applyFilter(filterIndexToObjectMap);
        if (this.active) {
            this.filterLock.writeLock().lock();
            try {
                this.getMatcherEditor().getMatcherEditors().addAll(this.staticMatcherEditor.values());
            }
            finally {
                this.filterLock.writeLock().unlock();
            }
        }
    }

    public void addStaticFilter(Matcher<T> matcher) {
        MatcherEditor matcherEditor = GlazedLists.fixedMatcherEditor(matcher);
        this.addStaticFilter(matcherEditor);
    }

    public void addStaticFilter(MatcherEditor<T> matcherEditor) {
        if (this.isActive()) {
            this.filterLock.writeLock().lock();
            try {
                this.getMatcherEditor().getMatcherEditors().add(matcherEditor);
            }
            finally {
                this.filterLock.writeLock().unlock();
            }
        }
        this.staticMatcherEditor.put(matcherEditor.getMatcher(), matcherEditor);
    }

    public void removeStaticFilter(Matcher<T> matcher) {
        MatcherEditor<T> removed = this.staticMatcherEditor.remove(matcher);
        if (removed != null && this.isActive()) {
            this.filterLock.writeLock().lock();
            try {
                this.getMatcherEditor().getMatcherEditors().remove(removed);
            }
            finally {
                this.filterLock.writeLock().unlock();
            }
        }
    }

    public void removeStaticFilter(MatcherEditor<T> matcherEditor) {
        this.removeStaticFilter(matcherEditor.getMatcher());
    }

    public void clearStaticFilter() {
        Collection<MatcherEditor<T>> staticMatcher = this.staticMatcherEditor.values();
        if (!staticMatcher.isEmpty() && this.isActive()) {
            this.filterLock.writeLock().lock();
            try {
                this.getMatcherEditor().getMatcherEditors().removeAll(staticMatcher);
            }
            finally {
                this.filterLock.writeLock().unlock();
            }
        }
        this.staticMatcherEditor.clear();
    }

    public void activateFilterStrategy() {
        if (!this.active) {
            this.active = true;
            Collection<MatcherEditor<T>> staticMatcher = this.staticMatcherEditor.values();
            if (!staticMatcher.isEmpty()) {
                this.filterLock.writeLock().lock();
                try {
                    this.getMatcherEditor().getMatcherEditors().addAll(staticMatcher);
                }
                finally {
                    this.filterLock.writeLock().unlock();
                }
            }
        }
    }

    public void deactivateFilterStrategy() {
        if (this.active) {
            this.active = false;
            Collection<MatcherEditor<T>> staticMatcher = this.staticMatcherEditor.values();
            if (!staticMatcher.isEmpty()) {
                this.filterLock.writeLock().lock();
                try {
                    this.getMatcherEditor().getMatcherEditors().removeAll(staticMatcher);
                }
                finally {
                    this.filterLock.writeLock().unlock();
                }
            }
        }
    }

    public boolean isActive() {
        return this.active;
    }
}

