/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.widgets;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.widgets.Property;
import org.eclipse.jface.widgets.WidgetSupplier;
import org.eclipse.swt.widgets.Widget;

public abstract class AbstractWidgetFactory<F extends AbstractWidgetFactory<?, ?, ?>, W extends Widget, P extends Widget> {
    private Class<F> factoryClass;
    private WidgetSupplier<W, P> widgetCreator;
    private List<Property<W>> properties = new ArrayList<Property<W>>();

    protected AbstractWidgetFactory(Class<F> factoryClass, WidgetSupplier<W, P> widgetCreator) {
        this.factoryClass = factoryClass;
        this.widgetCreator = widgetCreator;
    }

    protected final F cast(AbstractWidgetFactory<F, W, P> factory) {
        return (F)((AbstractWidgetFactory)this.factoryClass.cast(factory));
    }

    public final W create(P parent) {
        Object widget = this.widgetCreator.create(parent);
        this.properties.forEach(p -> p.apply(widget));
        return widget;
    }

    protected final void addProperty(Property<W> property) {
        this.properties.add(property);
    }
}

