/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.databinding.swt;

import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.ValueDiff;
import org.eclipse.core.databinding.property.INativePropertyListener;
import org.eclipse.core.databinding.property.IProperty;
import org.eclipse.core.databinding.property.ISimplePropertyListener;
import org.eclipse.core.databinding.property.value.SimpleValueProperty;
import org.eclipse.jface.databinding.swt.DisplayRealm;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.IWidgetValueProperty;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.internal.databinding.swt.SWTObservableValueDecorator;
import org.eclipse.jface.internal.databinding.swt.WidgetListener;
import org.eclipse.swt.widgets.Widget;

public abstract class WidgetValueProperty<S extends Widget, T>
extends SimpleValueProperty<S, T>
implements IWidgetValueProperty<S, T> {
    private int[] changeEvents;
    private int[] staleEvents;

    protected WidgetValueProperty() {
        this(null, null);
    }

    protected WidgetValueProperty(int changeEvent) {
        this(new int[]{changeEvent}, null);
    }

    protected WidgetValueProperty(int[] changeEvents) {
        this(changeEvents, null);
    }

    public WidgetValueProperty(int[] changeEvents, int[] staleEvents) {
        this.changeEvents = changeEvents;
        this.staleEvents = staleEvents;
    }

    public INativePropertyListener<S> adaptListener(ISimplePropertyListener<S, ValueDiff<? extends T>> listener) {
        if (this.changeEvents == null && this.staleEvents == null) {
            return null;
        }
        return new WidgetListener<S, ValueDiff<? extends T>>((IProperty)this, listener, this.changeEvents, this.staleEvents);
    }

    public ISWTObservableValue<T> observe(Realm realm, S source) {
        return this.wrapObservable((IObservableValue<T>)super.observe(realm, source), (Widget)source);
    }

    protected ISWTObservableValue<T> wrapObservable(IObservableValue<T> observable, Widget widget) {
        return new SWTObservableValueDecorator<T>(observable, widget);
    }

    @Override
    public ISWTObservableValue<T> observe(S widget) {
        return this.observe(DisplayRealm.getRealm(widget.getDisplay()), widget);
    }

    @Override
    public ISWTObservableValue<T> observeDelayed(int delay, S widget) {
        return SWTObservables.observeDelayedValue(delay, this.observe(widget));
    }
}

