/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.extension.glazedlists;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.event.ListEvent;
import ca.odell.glazedlists.event.ListEventListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.concurrent.ScheduledFuture;
import org.eclipse.nebula.widgets.nattable.command.DisposeResourcesCommand;
import org.eclipse.nebula.widgets.nattable.command.ILayerCommand;
import org.eclipse.nebula.widgets.nattable.layer.AbstractLayerTransform;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.IUniqueIndexLayer;
import org.eclipse.nebula.widgets.nattable.layer.event.ILayerEvent;
import org.eclipse.nebula.widgets.nattable.layer.event.PropertyUpdateEvent;
import org.eclipse.nebula.widgets.nattable.layer.event.RowStructuralRefreshEvent;
import org.eclipse.nebula.widgets.nattable.layer.event.VisualRefreshEvent;
import org.eclipse.nebula.widgets.nattable.util.Scheduler;
import org.eclipse.swt.widgets.Display;

public class GlazedListsEventLayer<T>
extends AbstractLayerTransform
implements IUniqueIndexLayer,
ListEventListener<T>,
PropertyChangeListener {
    private static final Scheduler scheduler = new Scheduler("GlazedListsEventLayer");
    private final IUniqueIndexLayer underlying;
    private final ScheduledFuture<?> future;
    private EventList<T> eventList;
    private boolean testMode = false;
    private boolean structuralChangeEventsToProcess = false;
    private boolean eventsToProcess = false;
    private boolean terminated;
    private boolean active = true;

    public GlazedListsEventLayer(IUniqueIndexLayer underlyingLayer, EventList<T> eventList) {
        super((ILayer)underlyingLayer);
        this.underlying = underlyingLayer;
        this.eventList = eventList;
        this.eventList.addListEventListener((ListEventListener)this);
        this.future = scheduler.scheduleAtFixedRate(this.getEventNotifier(), 0L, 100L);
    }

    protected Runnable getEventNotifier() {
        return () -> {
            if (this.eventsToProcess && this.active) {
                Object layerEvent = this.structuralChangeEventsToProcess ? new RowStructuralRefreshEvent(this.getUnderlyingLayer()) : new VisualRefreshEvent(this.getUnderlyingLayer());
                this.fireEventFromSWTDisplayThread((ILayerEvent)layerEvent);
                this.eventsToProcess = false;
                this.structuralChangeEventsToProcess = false;
            }
        };
    }

    public void listChanged(ListEvent<T> event) {
        while (event.next()) {
            int eventType = event.getType();
            if (eventType != 0 && eventType != 2) continue;
            this.structuralChangeEventsToProcess = true;
        }
        this.eventsToProcess = true;
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        PropertyUpdateEvent updateEvent = new PropertyUpdateEvent((ILayer)this, event.getSource(), event.getPropertyName(), event.getOldValue(), event.getNewValue());
        this.fireEventFromSWTDisplayThread((ILayerEvent)updateEvent);
    }

    protected void fireEventFromSWTDisplayThread(ILayerEvent event) {
        if (!this.testMode && Display.getCurrent() == null) {
            Display.getDefault().asyncExec(() -> this.fireLayerEvent(event));
        } else {
            this.fireLayerEvent(event);
        }
    }

    public boolean doCommand(ILayerCommand command) {
        if (!this.terminated && command instanceof DisposeResourcesCommand) {
            this.terminated = true;
            scheduler.unschedule(this.future);
        }
        return super.doCommand(command);
    }

    public boolean isDisposed() {
        return this.terminated;
    }

    public void setEventList(EventList<T> newEventList) {
        this.eventList.removeListEventListener((ListEventListener)this);
        this.eventList = newEventList;
        this.eventList.addListEventListener((ListEventListener)this);
    }

    public void setTestMode(boolean testMode) {
        this.testMode = testMode;
    }

    public void activate() {
        this.active = true;
    }

    public void deactivate() {
        this.active = false;
    }

    public boolean isActive() {
        return this.active;
    }

    public void discardEventsToProcess() {
        this.eventsToProcess = false;
        this.structuralChangeEventsToProcess = false;
    }

    public int getColumnPositionByIndex(int columnIndex) {
        return this.underlying.getColumnPositionByIndex(columnIndex);
    }

    public int getRowPositionByIndex(int rowIndex) {
        return this.underlying.getRowPositionByIndex(rowIndex);
    }
}

