/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.group.performance.command;

import org.eclipse.nebula.widgets.nattable.command.AbstractLayerCommandHandler;
import org.eclipse.nebula.widgets.nattable.coordinate.PositionUtil;
import org.eclipse.nebula.widgets.nattable.group.ColumnGroupUtils;
import org.eclipse.nebula.widgets.nattable.group.performance.ColumnGroupHeaderLayer;
import org.eclipse.nebula.widgets.nattable.group.performance.GroupModel;
import org.eclipse.nebula.widgets.nattable.reorder.command.ColumnReorderCommand;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;

public class GroupColumnReorderCommandHandler
extends AbstractLayerCommandHandler<ColumnReorderCommand> {
    private final ColumnGroupHeaderLayer columnGroupHeaderLayer;

    public GroupColumnReorderCommandHandler(ColumnGroupHeaderLayer columnGroupHeaderLayer) {
        this.columnGroupHeaderLayer = columnGroupHeaderLayer;
    }

    @Override
    protected boolean doCommand(ColumnReorderCommand command) {
        boolean reorderToLeftEdge;
        int toColumnPosition;
        int fromColumnPosition = command.getFromColumnPosition();
        boolean isValid = ColumnGroupUtils.isReorderValid(this.columnGroupHeaderLayer, fromColumnPosition, toColumnPosition = command.getToColumnPosition(), reorderToLeftEdge = command.isReorderToLeftEdge());
        if (isValid) {
            int fromIndex = this.columnGroupHeaderLayer.getPositionLayer().getColumnIndexByPosition(fromColumnPosition);
            int toIndex = this.columnGroupHeaderLayer.getPositionLayer().getColumnIndexByPosition(toColumnPosition);
            SelectionLayer.MoveDirectionEnum moveDirection = PositionUtil.getHorizontalMoveDirection(fromColumnPosition, toColumnPosition);
            boolean updateToPosition = false;
            int level = 0;
            while (level < this.columnGroupHeaderLayer.getLevelCount()) {
                int toPositionToCheck = toColumnPosition;
                if (SelectionLayer.MoveDirectionEnum.RIGHT == moveDirection && reorderToLeftEdge) {
                    --toPositionToCheck;
                }
                GroupModel.Group fromGroup = this.columnGroupHeaderLayer.getGroupByPosition(level, fromColumnPosition);
                GroupModel.Group toGroup = this.columnGroupHeaderLayer.getGroupByPosition(level, toPositionToCheck);
                if (fromGroup != null) {
                    if (fromGroup.isCollapsed() && (!ColumnGroupUtils.isInTheSameGroup(this.columnGroupHeaderLayer, level, fromColumnPosition, toPositionToCheck) || fromColumnPosition == toPositionToCheck)) {
                        this.columnGroupHeaderLayer.expandGroup(this.columnGroupHeaderLayer.getGroupModel(level), fromGroup);
                        updateToPosition = true;
                    } else if (SelectionLayer.MoveDirectionEnum.RIGHT == moveDirection && fromGroup.isGroupEnd(toPositionToCheck)) {
                        command.toggleCoordinateByEdge();
                    }
                } else if (toGroup != null && SelectionLayer.MoveDirectionEnum.RIGHT == moveDirection && toGroup.isGroupEnd(toPositionToCheck)) {
                    command.toggleCoordinateByEdge();
                }
                ++level;
            }
            if (updateToPosition) {
                if (moveDirection != SelectionLayer.MoveDirectionEnum.RIGHT) {
                    command.updateFromColumnPosition(this.columnGroupHeaderLayer.getPositionLayer().getColumnPositionByIndex(fromIndex));
                } else {
                    command.updateFromColumnPosition(this.columnGroupHeaderLayer.getPositionLayer().getColumnPositionByIndex(fromIndex));
                    command.updateToColumnPosition(this.columnGroupHeaderLayer.getPositionLayer().getColumnPositionByIndex(toIndex));
                }
            }
        }
        return !isValid;
    }

    @Override
    public Class<ColumnReorderCommand> getCommandClass() {
        return ColumnReorderCommand.class;
    }
}

