/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.examples.examples._101_Data;

import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.data.IDataProvider;
import org.eclipse.nebula.widgets.nattable.examples.AbstractNatExample;
import org.eclipse.nebula.widgets.nattable.examples.runner.StandaloneNatExampleRunner;
import org.eclipse.nebula.widgets.nattable.layer.DataLayer;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class Using_a_custom_DataProvider
extends AbstractNatExample {
    public static void main(String[] args) throws Exception {
        StandaloneNatExampleRunner.run(new Using_a_custom_DataProvider());
    }

    @Override
    public String getDescription() {
        return "One of the first things you will want to do is provide your own data for your NatTable instance. This is done by implementing an IDataProvider and configuring your NatTable layer with it.\n\nThis example shows a basic data layer that is backed by a custom data provider that names cells by column letter and row number.";
    }

    @Override
    public Control createExampleControl(Composite parent) {
        IDataProvider myDataProvider = new IDataProvider(){

            public int getColumnCount() {
                return 26;
            }

            public int getRowCount() {
                return 10;
            }

            public Object getDataValue(int columnIndex, int rowIndex) {
                String columnLetter = String.valueOf((char)(65 + columnIndex));
                String rowNumber = String.valueOf(rowIndex + 1);
                return String.valueOf(columnLetter) + rowNumber;
            }

            public void setDataValue(int columnIndex, int rowIndex, Object newValue) {
            }
        };
        DataLayer layer = new DataLayer(myDataProvider);
        return new NatTable(parent, (ILayer)layer);
    }
}

