/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.extension.glazedlists;

import ca.odell.glazedlists.SortedList;
import ca.odell.glazedlists.gui.AbstractTableComparatorChooser;
import ca.odell.glazedlists.gui.TableFormat;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.nebula.widgets.nattable.sort.SortDirectionEnum;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NatTableComparatorChooser<T>
extends AbstractTableComparatorChooser<T> {
    public NatTableComparatorChooser(SortedList<T> sortedList, TableFormat<T> tableFormat) {
        super(sortedList, tableFormat);
    }

    void sort(int columnIndex, SortDirectionEnum sortDirection, boolean accumulate) {
        if (this.getComparatorsForColumn(columnIndex).isEmpty()) {
            return;
        }
        if (!accumulate) {
            this.clearComparator();
        }
        switch (sortDirection) {
            case NONE: {
                this.removeSortingColumnIndex(columnIndex);
                break;
            }
            case ASC: {
                this.removeSortingColumnIndex(columnIndex);
                this.appendComparator(columnIndex, 0, false);
                break;
            }
            case DESC: {
                this.removeSortingColumnIndex(columnIndex);
                this.appendComparator(columnIndex, 0, true);
                break;
            }
        }
    }

    private void removeSortingColumnIndex(int columnIndex) {
        ArrayList<ComparatorInfo> comparatorInfos = new ArrayList<ComparatorInfo>();
        Iterator iterator = this.getSortingColumns().iterator();
        while (iterator.hasNext()) {
            int sortingColumnIndex = (Integer)iterator.next();
            if (sortingColumnIndex == columnIndex) continue;
            boolean reverse = this.isColumnReverse(sortingColumnIndex);
            comparatorInfos.add(new ComparatorInfo(sortingColumnIndex, reverse));
        }
        this.clearComparator();
        for (ComparatorInfo comparatorInfo : comparatorInfos) {
            this.appendComparator(comparatorInfo.columnIndex, 0, comparatorInfo.isReverse);
        }
    }

    public boolean isColumnIndexSorted(int columnIndex) {
        return this.getSortingColumns().contains(columnIndex);
    }

    public SortDirectionEnum getSortDirectionForColumnIndex(int columnIndex) {
        boolean sorted = this.getSortingColumns().contains(columnIndex);
        if (!sorted) {
            return SortDirectionEnum.NONE;
        }
        return this.isColumnReverse(columnIndex) ? SortDirectionEnum.DESC : SortDirectionEnum.ASC;
    }

    int getClickSequence(int columnIndex) {
        return this.getSortingColumns().indexOf(columnIndex);
    }

    private class ComparatorInfo {
        final int columnIndex;
        final boolean isReverse;

        ComparatorInfo(int columnIndex, boolean reverse) {
            this.columnIndex = columnIndex;
            this.isReverse = reverse;
        }
    }
}

