/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.painter.cell;

import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;
import org.eclipse.nebula.widgets.nattable.painter.cell.AbstractTextPainter;
import org.eclipse.nebula.widgets.nattable.resize.command.ColumnResizeCommand;
import org.eclipse.nebula.widgets.nattable.resize.command.RowResizeCommand;
import org.eclipse.nebula.widgets.nattable.style.CellStyleUtil;
import org.eclipse.nebula.widgets.nattable.style.IStyle;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;

public class TextPainter
extends AbstractTextPainter {
    public TextPainter() {
        this(false, true);
    }

    public TextPainter(boolean wrapText, boolean paintBg) {
        this(wrapText, paintBg, 0);
    }

    public TextPainter(boolean wrapText, boolean paintBg, int spacing) {
        this(wrapText, paintBg, spacing, false);
    }

    public TextPainter(boolean wrapText, boolean paintBg, boolean calculate) {
        this(wrapText, paintBg, 0, calculate);
    }

    public TextPainter(boolean wrapText, boolean paintBg, int spacing, boolean calculate) {
        super(wrapText, paintBg, spacing, calculate);
    }

    public int getPreferredWidth(ILayerCell cell, GC gc, IConfigRegistry configRegistry) {
        this.setupGCFromConfig(gc, CellStyleUtil.getCellStyle(cell, configRegistry));
        return this.getLengthFromCache(gc, this.convertDataType(cell, configRegistry)) + this.spacing * 2 + 1;
    }

    public int getPreferredHeight(ILayerCell cell, GC gc, IConfigRegistry configRegistry) {
        this.setupGCFromConfig(gc, CellStyleUtil.getCellStyle(cell, configRegistry));
        return gc.textExtent((String)this.convertDataType((ILayerCell)cell, (IConfigRegistry)configRegistry)).y;
    }

    public void paintCell(ILayerCell cell, GC gc, Rectangle rectangle, IConfigRegistry configRegistry) {
        block7: {
            Rectangle originalClipping;
            block9: {
                String[] lines;
                int contentHeight;
                String text;
                int fontHeight;
                IStyle cellStyle;
                block8: {
                    if (this.paintBg) {
                        super.paintCell(cell, gc, rectangle, configRegistry);
                    }
                    if (!this.paintFg) break block7;
                    originalClipping = gc.getClipping();
                    gc.setClipping(rectangle.intersection(originalClipping));
                    cellStyle = CellStyleUtil.getCellStyle(cell, configRegistry);
                    this.setupGCFromConfig(gc, cellStyle);
                    fontHeight = gc.getFontMetrics().getHeight();
                    text = this.convertDataType(cell, configRegistry);
                    text = this.getTextToDisplay(cell, gc, rectangle.width, text);
                    int numberOfNewLines = this.getNumberOfNewLines(text);
                    contentHeight = fontHeight * numberOfNewLines;
                    int contentToCellDiff = cell.getBounds().height - rectangle.height;
                    if (contentHeight > rectangle.height && this.calculate) {
                        ILayer layer = cell.getLayer();
                        layer.doCommand(new RowResizeCommand(layer, cell.getRowPosition(), contentHeight + this.spacing * 2 + contentToCellDiff));
                    }
                    if (numberOfNewLines != 1) break block8;
                    int contentWidth = Math.min(this.getLengthFromCache(gc, text), rectangle.width);
                    gc.drawText(text, rectangle.x + CellStyleUtil.getHorizontalAlignmentPadding(cellStyle, rectangle, contentWidth + this.spacing), rectangle.y + CellStyleUtil.getVerticalAlignmentPadding(cellStyle, rectangle, contentHeight + this.spacing), 3);
                    if (!this.underline && !this.strikethrough) break block9;
                    int x = rectangle.x + CellStyleUtil.getHorizontalAlignmentPadding(cellStyle, rectangle, contentWidth + this.spacing);
                    int y = rectangle.y + CellStyleUtil.getVerticalAlignmentPadding(cellStyle, rectangle, contentHeight + this.spacing);
                    if (this.underline) {
                        int underlineY = y + fontHeight - gc.getFontMetrics().getDescent() / 2;
                        gc.drawLine(x, underlineY, x + gc.textExtent((String)text).x, underlineY);
                    }
                    if (!this.strikethrough) break block9;
                    int strikeY = y + fontHeight / 2 + gc.getFontMetrics().getLeading() / 2;
                    gc.drawLine(x, strikeY, x + gc.textExtent((String)text).x, strikeY);
                    break block9;
                }
                int yStartPos = rectangle.y + CellStyleUtil.getVerticalAlignmentPadding(cellStyle, rectangle, contentHeight);
                String[] stringArray = lines = text.split("\n");
                int n = lines.length;
                int n2 = 0;
                while (n2 < n) {
                    String line = stringArray[n2];
                    int lineContentWidth = Math.min(this.getLengthFromCache(gc, line), rectangle.width);
                    gc.drawText(line, rectangle.x + CellStyleUtil.getHorizontalAlignmentPadding(cellStyle, rectangle, lineContentWidth + this.spacing), yStartPos + this.spacing, 3);
                    if (this.underline || this.strikethrough) {
                        int x = rectangle.x + CellStyleUtil.getHorizontalAlignmentPadding(cellStyle, rectangle, lineContentWidth + this.spacing);
                        int y = yStartPos + this.spacing;
                        if (this.underline) {
                            int underlineY = y + fontHeight - gc.getFontMetrics().getDescent() / 2;
                            gc.drawLine(x, underlineY, x + gc.textExtent((String)line).x, underlineY);
                        }
                        if (this.strikethrough) {
                            int strikeY = y + fontHeight / 2 + gc.getFontMetrics().getLeading() / 2;
                            gc.drawLine(x, strikeY, x + gc.textExtent((String)line).x, strikeY);
                        }
                    }
                    yStartPos += fontHeight;
                    ++n2;
                }
            }
            gc.setClipping(originalClipping);
        }
    }

    protected void setNewMinLength(ILayerCell cell, int contentWidth) {
        int cellLength = cell.getBounds().width;
        if (cellLength < contentWidth) {
            ILayer layer = cell.getLayer();
            layer.doCommand(new ColumnResizeCommand(layer, cell.getColumnPosition(), contentWidth));
        }
    }

    protected int calculatePadding(ILayerCell cell, int availableLength) {
        return cell.getBounds().width - availableLength;
    }
}

