/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.group;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.nebula.widgets.nattable.group.ColumnGroupModel;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.IUniqueIndexLayer;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ColumnGroupUtils {
    public static SelectionLayer.MoveDirectionEnum getMoveDirection(int fromColumnPosition, int toColumnPosition) {
        if (fromColumnPosition > toColumnPosition) {
            return SelectionLayer.MoveDirectionEnum.LEFT;
        }
        if (fromColumnPosition < toColumnPosition) {
            return SelectionLayer.MoveDirectionEnum.RIGHT;
        }
        return SelectionLayer.MoveDirectionEnum.NONE;
    }

    public static boolean isInTheSameGroup(int fromColumnIndex, int toColumnIndex, ColumnGroupModel model) {
        ColumnGroupModel.ColumnGroup fromColumnGroup = model.getColumnGroupByIndex(fromColumnIndex);
        ColumnGroupModel.ColumnGroup toColumnGroup = model.getColumnGroupByIndex(toColumnIndex);
        return fromColumnGroup != null && toColumnGroup != null && fromColumnGroup == toColumnGroup;
    }

    public static boolean isStaticOrFirstVisibleColumn(int columnIndex, ILayer layer, IUniqueIndexLayer underlyingLayer, ColumnGroupModel model) {
        ColumnGroupModel.ColumnGroup columnGroup = model.getColumnGroupByIndex(columnIndex);
        if (columnGroup.getStaticColumnIndexes().size() == 0) {
            return ColumnGroupUtils.isFirstVisibleColumnIndexInGroup(columnIndex, layer, underlyingLayer, model);
        }
        return model.isStaticColumn(columnIndex);
    }

    public static boolean isFirstVisibleColumnIndexInGroup(int columnIndex, ILayer layer, IUniqueIndexLayer underlyingLayer, ColumnGroupModel model) {
        if (ColumnGroupUtils.isColumnIndexHiddenInUnderLyingLayer(columnIndex, layer, underlyingLayer)) {
            return false;
        }
        int columnPosition = underlyingLayer.getColumnPositionByIndex(columnIndex);
        List<Integer> columnIndexesInGroup = model.getColumnGroupByIndex(columnIndex).getMembers();
        ArrayList<Integer> previousVisibleColumnIndexes = new ArrayList<Integer>();
        for (Integer currentIndex : columnIndexesInGroup) {
            int currentPosition = underlyingLayer.getColumnPositionByIndex(currentIndex);
            if (ColumnGroupUtils.isColumnIndexHiddenInUnderLyingLayer(currentIndex, layer, underlyingLayer) || currentPosition >= columnPosition) continue;
            previousVisibleColumnIndexes.add(currentIndex);
        }
        return previousVisibleColumnIndexes.isEmpty();
    }

    public static boolean isLastVisibleColumnIndexInGroup(int columnIndex, ILayer layer, IUniqueIndexLayer underlyingLayer, ColumnGroupModel model) {
        if (ColumnGroupUtils.isColumnIndexHiddenInUnderLyingLayer(columnIndex, layer, underlyingLayer)) {
            return false;
        }
        List<Integer> visibleIndexesToTheRight = ColumnGroupUtils.getVisibleIndexesToTheRight(columnIndex, layer, underlyingLayer, model);
        return visibleIndexesToTheRight.size() == 1 && visibleIndexesToTheRight.get(0) == columnIndex;
    }

    public static List<Integer> getVisibleIndexesToTheRight(int columnIndex, ILayer layer, IUniqueIndexLayer underlyingLayer, ColumnGroupModel model) {
        ColumnGroupModel.ColumnGroup columnGroup = model.getColumnGroupByIndex(columnIndex);
        if (columnGroup.isCollapsed()) {
            return Collections.emptyList();
        }
        List<Integer> columnIndexesInGroup = columnGroup.getMembers();
        int columnPosition = underlyingLayer.getColumnPositionByIndex(columnIndex);
        ArrayList<Integer> visibleColumnIndexesOnRight = new ArrayList<Integer>();
        for (Integer currentIndex : columnIndexesInGroup) {
            int currentPosition = underlyingLayer.getColumnPositionByIndex(currentIndex);
            if (ColumnGroupUtils.isColumnIndexHiddenInUnderLyingLayer(currentIndex, layer, underlyingLayer) || currentPosition < columnPosition) continue;
            visibleColumnIndexesOnRight.add(currentIndex);
        }
        return visibleColumnIndexesOnRight;
    }

    public static boolean isColumnIndexHiddenInUnderLyingLayer(int columnIndex, ILayer layer, IUniqueIndexLayer underlyingLayer) {
        return underlyingLayer.getColumnPositionByIndex(columnIndex) == -1;
    }

    public static boolean isColumnPositionHiddenInUnderLyingLayer(int columnPosition, ILayer layer, IUniqueIndexLayer underlyingLayer) {
        if (columnPosition < underlyingLayer.getColumnCount() && columnPosition >= 0) {
            int columnIndex = underlyingLayer.getColumnIndexByPosition(columnPosition);
            return ColumnGroupUtils.isColumnIndexHiddenInUnderLyingLayer(columnIndex, layer, underlyingLayer);
        }
        return true;
    }

    public static boolean isRightEdgeOfAColumnGroup(ILayer natLayer, int columnPosition, int columnIndex, ColumnGroupModel model) {
        int nextColumnPosition = columnPosition + 1;
        if (nextColumnPosition < natLayer.getColumnCount()) {
            int nextColumnIndex = natLayer.getColumnIndexByPosition(nextColumnPosition);
            if (model.isPartOfAGroup(columnIndex) && !model.isPartOfAGroup(nextColumnIndex)) {
                return true;
            }
            if (model.isPartOfAGroup(columnIndex) && model.isPartOfAGroup(nextColumnIndex) && !ColumnGroupUtils.isInTheSameGroup(columnIndex, nextColumnIndex, model)) {
                return true;
            }
        }
        return false;
    }

    public static boolean isLeftEdgeOfAColumnGroup(ILayer natLayer, int columnPosition, int columnIndex, ColumnGroupModel model) {
        int previousColumnPosition = columnPosition - 1;
        if (columnPosition == 0 && model.isPartOfAGroup(columnIndex)) {
            return true;
        }
        if (previousColumnPosition >= 0) {
            int previousColumnIndex = natLayer.getColumnIndexByPosition(previousColumnPosition);
            if (model.isPartOfAGroup(columnIndex) && !model.isPartOfAGroup(previousColumnIndex)) {
                return true;
            }
            if (model.isPartOfAGroup(columnIndex) && model.isPartOfAGroup(previousColumnIndex) && !ColumnGroupUtils.isInTheSameGroup(columnIndex, previousColumnIndex, model)) {
                return true;
            }
        }
        return false;
    }

    public static boolean isBetweenTwoGroups(ILayer natLayer, int startX, int endX, ColumnGroupModel model) {
        return !ColumnGroupUtils.isInTheSameGroup(natLayer.getColumnIndexByPosition(natLayer.getColumnPositionByX(startX)), natLayer.getColumnIndexByPosition(natLayer.getColumnPositionByX(endX)), model);
    }
}

