/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.filterrow;

import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.edit.EditConfigAttributes;
import org.eclipse.nebula.widgets.nattable.edit.editor.ComboBoxCellEditor;
import org.eclipse.nebula.widgets.nattable.edit.editor.ICellEditor;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;
import org.eclipse.nebula.widgets.nattable.painter.cell.CellPainterWrapper;
import org.eclipse.nebula.widgets.nattable.painter.cell.ImagePainter;
import org.eclipse.nebula.widgets.nattable.painter.cell.TextPainter;
import org.eclipse.nebula.widgets.nattable.painter.cell.decorator.CellPainterDecorator;
import org.eclipse.nebula.widgets.nattable.painter.cell.decorator.PaddingDecorator;
import org.eclipse.nebula.widgets.nattable.ui.util.CellEdgeEnum;
import org.eclipse.nebula.widgets.nattable.util.GUIHelper;
import org.eclipse.nebula.widgets.nattable.util.ObjectUtils;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;

public class FilterRowPainter
extends CellPainterWrapper {
    private final FilterIconPainter filterIconPainter = new FilterIconPainter();
    private final int TOP_IMAGE_PADDING = 2;
    private final int RIGHT_IMAGE_PADDING = 0;

    public FilterRowPainter() {
        this.setWrappedPainter(new CellPainterDecorator(new TextPainter(), CellEdgeEnum.RIGHT, new PaddingDecorator(this.filterIconPainter, 2, 0, 0, 0)));
    }

    public boolean containsRemoveFilterImage(int x, int y, ILayerCell cell, IConfigRegistry configRegistry) {
        Image image = this.filterIconPainter.getImage(cell, configRegistry);
        if (image == null) {
            return false;
        }
        int iconImageWidth = image.getImageData().width;
        int iconImageHeight = image.getImageData().height;
        Rectangle cellBounds = cell.getBounds();
        Rectangle imageBounds = new Rectangle(cellBounds.x + cellBounds.width - 0 - iconImageWidth, cellBounds.y + 2, iconImageWidth, iconImageHeight).intersection(cellBounds);
        return imageBounds.contains(x, y);
    }

    static class FilterIconPainter
    extends ImagePainter {
        FilterIconPainter() {
        }

        protected Image getImage(ILayerCell cell, IConfigRegistry configRegistry) {
            if (ObjectUtils.isNotNull(cell.getDataValue())) {
                return GUIHelper.getImage("remove_filter");
            }
            ICellEditor cellEditor = configRegistry.getConfigAttribute(EditConfigAttributes.CELL_EDITOR, cell.getDisplayMode(), cell.getConfigLabels().getLabels());
            if (ObjectUtils.isNotNull(cellEditor) && cellEditor instanceof ComboBoxCellEditor) {
                return GUIHelper.getImage("down_2");
            }
            return null;
        }
    }
}

