/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.export;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.OutputStream;
import java.io.PrintStream;
import org.eclipse.nebula.widgets.nattable.export.IOutputStreamProvider;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;

public class FileOutputStreamProvider
implements IOutputStreamProvider {
    protected String fileName;
    protected String[] filterNames;
    protected String[] filterExtensions;

    public FileOutputStreamProvider(String fileName, String[] filterNames, String[] filterExtensions) {
        this.fileName = fileName;
        this.filterNames = filterNames;
        this.filterExtensions = filterExtensions;
    }

    public OutputStream getOutputStream(Shell shell) {
        String relativeFileName;
        String filterPath;
        FileDialog dialog = new FileDialog(shell, 8192);
        int lastIndexOfFileSeparator = this.fileName.lastIndexOf(File.separator);
        if (lastIndexOfFileSeparator >= 0) {
            filterPath = this.fileName.substring(0, lastIndexOfFileSeparator);
            relativeFileName = this.fileName.substring(lastIndexOfFileSeparator + 1);
        } else {
            filterPath = "/";
            relativeFileName = this.fileName;
        }
        dialog.setFilterPath(filterPath);
        dialog.setOverwrite(true);
        dialog.setFileName(relativeFileName);
        dialog.setFilterNames(this.filterNames);
        dialog.setFilterExtensions(this.filterExtensions);
        this.fileName = dialog.open();
        if (this.fileName == null) {
            return null;
        }
        try {
            return new PrintStream(this.fileName);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    public String getFileName() {
        return this.fileName;
    }
}

