/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.data;

import java.util.List;
import org.eclipse.nebula.widgets.nattable.data.IColumnAccessor;
import org.eclipse.nebula.widgets.nattable.data.ListDataProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractFilterListDataProvider<T>
extends ListDataProvider<T> {
    public AbstractFilterListDataProvider(List<T> list, IColumnAccessor<T> columnAccessor) {
        super(list, columnAccessor);
    }

    @Override
    public int getRowCount() {
        int numberOfInvisible = 0;
        for (Object object : this.list) {
            if (this.show(object)) continue;
            ++numberOfInvisible;
        }
        return this.list.size() - numberOfInvisible;
    }

    @Override
    public Object getDataValue(int columnIndex, int rowIndex) {
        T rowObj = this.getRowObject(rowIndex);
        return this.columnAccessor.getDataValue(rowObj, columnIndex);
    }

    @Override
    public void setDataValue(int columnIndex, int rowIndex, Object newValue) {
        T rowObj = this.getRowObject(rowIndex);
        this.columnAccessor.setDataValue(rowObj, columnIndex, newValue);
    }

    @Override
    public T getRowObject(int rowIndex) {
        T object = null;
        int count = 0;
        int realRowIndex = 0;
        while (count <= rowIndex) {
            object = (T)this.list.get(realRowIndex);
            if (this.show(object)) {
                ++count;
            }
            ++realRowIndex;
        }
        return object;
    }

    @Override
    public int indexOfRowObject(T rowObject) {
        int realRowIndex;
        int filteredIndex = realRowIndex = this.list.indexOf(rowObject);
        T vf = null;
        int i = 0;
        while (i <= realRowIndex) {
            vf = (T)this.list.get(i);
            if (!this.show(vf)) {
                --filteredIndex;
            }
            ++i;
        }
        return filteredIndex;
    }

    protected abstract boolean show(T var1);
}

