/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.copy.command;

import java.util.Set;
import org.eclipse.nebula.widgets.nattable.command.AbstractLayerCommandHandler;
import org.eclipse.nebula.widgets.nattable.coordinate.Range;
import org.eclipse.nebula.widgets.nattable.copy.command.CopyDataToClipboardCommand;
import org.eclipse.nebula.widgets.nattable.copy.serializing.CopyDataToClipboardSerializer;
import org.eclipse.nebula.widgets.nattable.copy.serializing.CopyFormattedTextToClipboardSerializer;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CopyDataCommandHandler
extends AbstractLayerCommandHandler<CopyDataToClipboardCommand> {
    private final SelectionLayer selectionLayer;
    private final ILayer columnHeaderLayer;
    private final ILayer rowHeaderLayer;
    private boolean copyFormattedText;

    public CopyDataCommandHandler(SelectionLayer selectionLayer) {
        this(selectionLayer, null, null);
    }

    public CopyDataCommandHandler(SelectionLayer selectionLayer, ILayer columnHeaderLayer, ILayer rowHeaderLayer) {
        this.selectionLayer = selectionLayer;
        this.columnHeaderLayer = columnHeaderLayer;
        this.rowHeaderLayer = rowHeaderLayer;
    }

    public void setCopyFormattedText(boolean copyFormattedText) {
        this.copyFormattedText = copyFormattedText;
    }

    @Override
    public boolean doCommand(CopyDataToClipboardCommand command) {
        CopyDataToClipboardSerializer serializer = this.copyFormattedText ? new CopyFormattedTextToClipboardSerializer(this.assembleCopiedDataStructure(), command) : new CopyDataToClipboardSerializer(this.assembleCopiedDataStructure(), command);
        serializer.serialize();
        return true;
    }

    @Override
    public Class<CopyDataToClipboardCommand> getCommandClass() {
        return CopyDataToClipboardCommand.class;
    }

    protected ILayerCell[][] assembleCopiedDataStructure() {
        Set<Range> selectedRows = this.selectionLayer.getSelectedRowPositions();
        int rowOffset = this.columnHeaderLayer != null ? this.columnHeaderLayer.getRowCount() : 0;
        ILayerCell[][] copiedCells = new ILayerCell[this.selectionLayer.getSelectedRowCount() + rowOffset][1];
        if (this.columnHeaderLayer != null) {
            copiedCells[0] = this.assembleColumnHeaders(this.selectionLayer.getSelectedColumnPositions());
        }
        for (Range range : selectedRows) {
            int rowPosition = range.start;
            while (rowPosition < range.end) {
                copiedCells[rowPosition - range.start + rowOffset] = this.assembleBody(rowPosition);
                ++rowPosition;
            }
        }
        return copiedCells;
    }

    protected ILayerCell[] assembleColumnHeaders(int ... selectedColumnPositions) {
        int columnOffset = this.rowHeaderLayer.getColumnCount();
        ILayerCell[] cells = new ILayerCell[selectedColumnPositions.length + columnOffset];
        int columnPosition = 0;
        while (columnPosition < selectedColumnPositions.length) {
            cells[columnPosition + columnOffset] = this.columnHeaderLayer.getCellByPosition(selectedColumnPositions[columnPosition], 0);
            ++columnPosition;
        }
        return cells;
    }

    protected ILayerCell[] assembleBody(int currentRowPosition) {
        int[] selectedColumns = this.selectionLayer.getSelectedColumnPositions();
        int columnOffset = this.rowHeaderLayer != null ? this.rowHeaderLayer.getColumnCount() : 0;
        ILayerCell[] bodyCells = new ILayerCell[selectedColumns.length + columnOffset];
        if (this.rowHeaderLayer != null) {
            bodyCells[0] = this.rowHeaderLayer.getCellByPosition(0, currentRowPosition);
        }
        int columnPosition = 0;
        while (columnPosition < selectedColumns.length) {
            int selectedColumnPosition = selectedColumns[columnPosition];
            if (this.selectionLayer.isCellPositionSelected(selectedColumnPosition, currentRowPosition)) {
                bodyCells[columnPosition + columnOffset] = this.selectionLayer.getCellByPosition(selectedColumnPosition, currentRowPosition);
            }
            ++columnPosition;
        }
        return bodyCells;
    }
}

