/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.conflation;

import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ScheduledFuture;
import org.eclipse.nebula.widgets.nattable.conflation.IEventConflater;
import org.eclipse.nebula.widgets.nattable.layer.event.ILayerEvent;
import org.eclipse.nebula.widgets.nattable.util.Scheduler;

public class EventConflaterChain
implements IEventConflater {
    public static final int DEFAULT_INITIAL_DELAY = 100;
    public static final int DEFAULT_REFRESH_INTERVAL = 100;
    private static final Scheduler scheduler = new Scheduler("EventConflaterChain");
    private final List<IEventConflater> chain = new LinkedList<IEventConflater>();
    private ScheduledFuture<?> future;
    private boolean started;
    private final long refreshInterval;
    private final long initialDelay;

    public EventConflaterChain() {
        this(100, 100);
    }

    public EventConflaterChain(int refreshInterval, int initialDelay) {
        this.refreshInterval = refreshInterval;
        this.initialDelay = initialDelay;
    }

    public void add(IEventConflater conflater) {
        this.chain.add(conflater);
    }

    public void start() {
        if (!this.started) {
            this.future = scheduler.scheduleWithFixedDelay(this.getConflaterTask(), this.initialDelay, this.refreshInterval);
            this.started = true;
        }
    }

    public void stop() {
        if (this.started) {
            scheduler.unschedule(this.future);
            this.started = false;
        }
    }

    public void addEvent(ILayerEvent event) {
        for (IEventConflater eventConflater : this.chain) {
            eventConflater.addEvent(event);
        }
    }

    public void clearQueue() {
        for (IEventConflater eventConflater : this.chain) {
            eventConflater.clearQueue();
        }
    }

    public int getCount() {
        int count = 0;
        for (IEventConflater eventConflater : this.chain) {
            count += eventConflater.getCount();
        }
        return count;
    }

    public Runnable getConflaterTask() {
        return new Runnable(){

            public void run() {
                for (IEventConflater conflater : EventConflaterChain.this.chain) {
                    conflater.getConflaterTask().run();
                }
            }
        };
    }
}

