/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.sandbox.search.ui;

import java.util.Arrays;

public final class SearchCriteria {
    private int maximumResults = 500;
    private String text;
    private String[] filenamePatterns;

    public SearchCriteria() {
    }

    public SearchCriteria(String text, String[] filenamePatterns) {
        this.text = text;
        this.filenamePatterns = filenamePatterns;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public String[] getFilenamePatterns() {
        return this.filenamePatterns;
    }

    public void setFilenamePatterns(String[] filenamePatterns) {
        this.filenamePatterns = filenamePatterns;
    }

    public String getFilenamePatternsAsText() {
        String[] patterns = this.getFilenamePatterns();
        String text = "";
        String[] stringArray = patterns;
        int n = patterns.length;
        int n2 = 0;
        while (n2 < n) {
            String pattern = stringArray[n2];
            if ((pattern = pattern.trim()).length() != 0) {
                if (text.length() > 0) {
                    text = String.valueOf(text) + ", ";
                }
                text = String.valueOf(text) + pattern;
            }
            ++n2;
        }
        return text;
    }

    public void setFilenamePatternsAsText(String text) {
        this.filenamePatterns = text == null || text.trim().length() == 0 ? new String[]{} : text.trim().split("(\\s*,\\s*)|(\\s+)");
    }

    public int getMaximumResults() {
        return this.maximumResults;
    }

    public void setMaximumResults(int maximumResults) {
        if (maximumResults < 1) {
            throw new IllegalArgumentException();
        }
        this.maximumResults = maximumResults;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.text == null ? 0 : this.text.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SearchCriteria other = (SearchCriteria)obj;
        return !(this.text == null ? other.text != null : !this.text.equals(other.text));
    }

    public String toString() {
        return "SearchCriteria [text=" + this.text + ", filenamePatterns=" + Arrays.toString(this.filenamePatterns) + "]";
    }
}

