/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.commonmark.internal.blocks;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.mylyn.wikitext.commonmark.internal.Line;
import org.eclipse.mylyn.wikitext.commonmark.internal.LineSequence;
import org.eclipse.mylyn.wikitext.commonmark.internal.blocks.AbstractHtmlBlock;

public class HtmlCommentBlock
extends AbstractHtmlBlock {
    private final Pattern startPattern = Pattern.compile("\\s{0,3}(<!--)(?!>|->).*");
    private final Pattern doubleHyphen = Pattern.compile("--(?!>)");
    private final Pattern closePattern = Pattern.compile("(?<!-)-->");

    @Override
    public boolean canStart(LineSequence lineSequence) {
        Line line = lineSequence.getCurrentLine();
        if (line != null) {
            String text = line.getText();
            Matcher matcher = this.startPattern().matcher(text);
            if (matcher.matches()) {
                int end = matcher.end(1);
                if (end < text.length() - 1) {
                    Matcher doubleHyphenMatcher = this.doubleHyphen.matcher(text);
                    doubleHyphenMatcher.region(end, text.length());
                    if (doubleHyphenMatcher.find()) {
                        return false;
                    }
                }
                return true;
            }
        }
        return false;
    }

    @Override
    protected Pattern closePattern() {
        return this.closePattern;
    }

    @Override
    protected Pattern startPattern() {
        return this.startPattern;
    }
}

