/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.commonmark.internal;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.eclipse.mylyn.wikitext.commonmark.internal.inlines.AllCharactersSpan;
import org.eclipse.mylyn.wikitext.commonmark.internal.inlines.AutoLinkSpan;
import org.eclipse.mylyn.wikitext.commonmark.internal.inlines.AutoLinkWithoutDemarcationSpan;
import org.eclipse.mylyn.wikitext.commonmark.internal.inlines.BackslashEscapeSpan;
import org.eclipse.mylyn.wikitext.commonmark.internal.inlines.CodeSpan;
import org.eclipse.mylyn.wikitext.commonmark.internal.inlines.HtmlEntitySpan;
import org.eclipse.mylyn.wikitext.commonmark.internal.inlines.HtmlTagSpan;
import org.eclipse.mylyn.wikitext.commonmark.internal.inlines.InlineParser;
import org.eclipse.mylyn.wikitext.commonmark.internal.inlines.LineBreakSpan;
import org.eclipse.mylyn.wikitext.commonmark.internal.inlines.PotentialBracketSpan;
import org.eclipse.mylyn.wikitext.commonmark.internal.inlines.PotentialEmphasisSpan;
import org.eclipse.mylyn.wikitext.commonmark.internal.inlines.SourceSpan;
import org.eclipse.mylyn.wikitext.commonmark.internal.inlines.StringCharactersSpan;

public class InlineContent {
    public static InlineParser commonMarkStrict() {
        ImmutableList.Builder spansBuilder = ImmutableList.builder();
        InlineContent.addStandardSpans((ImmutableList.Builder<SourceSpan>)spansBuilder);
        InlineContent.addTerminatorSpans((ImmutableList.Builder<SourceSpan>)spansBuilder);
        return new InlineParser((List<SourceSpan>)spansBuilder.build());
    }

    public static InlineParser markdown() {
        ImmutableList.Builder spansBuilder = ImmutableList.builder();
        InlineContent.addStandardSpans((ImmutableList.Builder<SourceSpan>)spansBuilder);
        spansBuilder.add((Object)new AutoLinkWithoutDemarcationSpan());
        InlineContent.addTerminatorSpans((ImmutableList.Builder<SourceSpan>)spansBuilder);
        return new InlineParser((List<SourceSpan>)spansBuilder.build());
    }

    private static void addStandardSpans(ImmutableList.Builder<SourceSpan> spansBuilder) {
        spansBuilder.add((Object)new LineBreakSpan());
        spansBuilder.add((Object)new BackslashEscapeSpan());
        spansBuilder.add((Object)new CodeSpan());
        spansBuilder.add((Object)new AutoLinkSpan());
        spansBuilder.add((Object)new HtmlTagSpan());
        spansBuilder.add((Object)new HtmlEntitySpan());
        spansBuilder.add((Object)new PotentialEmphasisSpan());
        spansBuilder.add((Object)new PotentialBracketSpan());
    }

    private static void addTerminatorSpans(ImmutableList.Builder<SourceSpan> spansBuilder) {
        spansBuilder.add((Object)new StringCharactersSpan());
        spansBuilder.add((Object)new AllCharactersSpan());
    }

    private InlineContent() {
    }
}

