/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.ui.refactoring;

import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.ui.refactoring.RefactoringWizard;
import org.eclipse.ltk.ui.refactoring.UserInputWizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.xtext.xbase.ui.refactoring.ExtractVariableRefactoring;

public class ExtractVariableWizard
extends RefactoringWizard {
    public ExtractVariableWizard(Refactoring refactoring) {
        super(refactoring, 4);
    }

    protected void addUserInputPages() {
        this.addPage((IWizardPage)new UserInputPage((ExtractVariableRefactoring)this.getRefactoring()));
    }

    public String getWindowTitle() {
        return "Extract Local Variable";
    }

    protected static class UserInputPage
    extends UserInputWizardPage {
        private final ExtractVariableRefactoring refactoring;
        private Text nameField;
        private Button finalButton;

        public UserInputPage(ExtractVariableRefactoring refactoring) {
            super("ExtractLocalVariableInutPage");
            this.refactoring = refactoring;
        }

        public void createControl(Composite parent) {
            Composite composite = new Composite(parent, 0);
            GridLayout layout = new GridLayout(2, false);
            layout.verticalSpacing = 16;
            composite.setLayout((Layout)layout);
            composite.setLayoutData((Object)new GridData(4, 4, true, true));
            composite.setFont(parent.getFont());
            Label label = new Label(composite, 0);
            label.setText("Variable name:");
            label.setFont(composite.getFont());
            label.setLayoutData((Object)new GridData());
            this.nameField = new Text(composite, 2048);
            this.nameField.setText(this.refactoring.getVariableName());
            this.nameField.setFont(composite.getFont());
            this.nameField.setLayoutData((Object)new GridData(4, 1, true, false));
            this.nameField.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    UserInputPage.this.validatePage();
                }
            });
            this.nameField.selectAll();
            this.finalButton = new Button(composite, 32);
            this.finalButton.setText("Declare as final 'val'");
            this.finalButton.setFont(composite.getFont());
            this.finalButton.setLayoutData((Object)new GridData(4, 1, false, false, 2, 1));
            this.finalButton.setSelection(this.refactoring.isFinal());
            this.setControl((Control)composite);
            this.validatePage();
        }

        public void setVisible(boolean visible) {
            if (visible) {
                this.nameField.setFocus();
            }
            super.setVisible(visible);
        }

        protected final void validatePage() {
            String variableName = this.nameField.getText();
            RefactoringStatus status = this.refactoring.validateNewVariableName(variableName);
            this.setPageComplete(status);
        }

        protected boolean performFinish() {
            this.updateRefactoring();
            return super.performFinish();
        }

        public IWizardPage getNextPage() {
            this.updateRefactoring();
            return super.getNextPage();
        }

        protected void updateRefactoring() {
            this.refactoring.setVariableName(this.nameField.getText());
            this.refactoring.setFinal(this.finalButton.getSelection());
        }
    }
}

