/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.builder.standalone;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.io.File;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.xtext.common.types.descriptions.IStubGenerator;
import org.eclipse.xtext.generator.IGenerator;
import org.eclipse.xtext.generator.IOutputConfigurationProvider;
import org.eclipse.xtext.generator.JavaIoFileSystemAccess;
import org.eclipse.xtext.generator.OutputConfiguration;
import org.eclipse.xtext.parser.IEncodingProvider;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.IResourceServiceProvider;
import org.eclipse.xtext.validation.IResourceValidator;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class LanguageAccess {
    private static final Logger LOG = Logger.getLogger(LanguageAccess.class);
    private Set<OutputConfiguration> outputConfigs;
    protected IResourceServiceProvider resourceServiceProvider;
    private boolean linksAgainstJava = true;

    public LanguageAccess(Set<OutputConfiguration> outputConfigurations, IResourceServiceProvider resourceServiceProvider) {
        this(outputConfigurations, resourceServiceProvider, false);
    }

    public LanguageAccess(Set<OutputConfiguration> outputConfigurations, IResourceServiceProvider resourceServiceProvider, boolean linksAgainstJavaTypes) {
        this.outputConfigs = outputConfigurations;
        this.resourceServiceProvider = resourceServiceProvider;
        this.linksAgainstJava = linksAgainstJavaTypes;
    }

    public IGenerator getGenerator() {
        return (IGenerator)this.resourceServiceProvider.get(IGenerator.class);
    }

    public IStubGenerator getStubGenerator() {
        return (IStubGenerator)this.resourceServiceProvider.get(IStubGenerator.class);
    }

    public JavaIoFileSystemAccess createFileSystemAccess(final File baseDir) {
        JavaIoFileSystemAccess fsa = (JavaIoFileSystemAccess)this.resourceServiceProvider.get(JavaIoFileSystemAccess.class);
        HashSet confsForFsa = Sets.newHashSet();
        Set<OutputConfiguration> pomOutputConfigs = this.getConfiguredOutputConfigs();
        if (pomOutputConfigs != null && !pomOutputConfigs.isEmpty()) {
            for (OutputConfiguration pomConfig : pomOutputConfigs) {
                if (this.getOutputConfigurationProvider().getOutputConfigurations().contains(pomConfig)) {
                    confsForFsa.add(pomConfig);
                    continue;
                }
                LOG.warn((Object)("Output '" + pomConfig.getName() + "' is not configured in OutputConfigurationProvider."));
            }
        }
        confsForFsa.addAll(this.getOutputConfigurationProvider().getOutputConfigurations());
        Map asMap = IterableExtensions.toMap((Iterable)Iterables.transform((Iterable)confsForFsa, (Function)new Function<OutputConfiguration, OutputConfiguration>(){

            public OutputConfiguration apply(OutputConfiguration output) {
                output.setOutputDirectory(LanguageAccess.this.resolveToBaseDir(output.getOutputDirectory(), baseDir));
                for (OutputConfiguration.SourceMapping sourceMapping : output.getSourceMappings()) {
                    sourceMapping.setOutputDirectory(LanguageAccess.this.resolveToBaseDir(sourceMapping.getOutputDirectory(), baseDir));
                }
                return output;
            }
        }), (Functions.Function1)new Functions.Function1<OutputConfiguration, String>(){

            public String apply(OutputConfiguration it) {
                return it.getName();
            }
        });
        fsa.setOutputConfigurations(asMap);
        return fsa;
    }

    public Set<OutputConfiguration> getConfiguredOutputConfigs() {
        return this.outputConfigs;
    }

    public IResourceDescription.Manager getResourceDescriptionManager() {
        return this.resourceServiceProvider.getResourceDescriptionManager();
    }

    public IOutputConfigurationProvider getOutputConfigurationProvider() {
        return (IOutputConfigurationProvider)this.resourceServiceProvider.get(IOutputConfigurationProvider.class);
    }

    public IEncodingProvider getEncodingProvider() {
        return (IEncodingProvider)this.resourceServiceProvider.get(IEncodingProvider.Runtime.class);
    }

    public IResourceValidator getResourceValidator() {
        return this.resourceServiceProvider.getResourceValidator();
    }

    public void setLinksAgainstJava(boolean linksAgainstJava) {
        this.linksAgainstJava = linksAgainstJava;
    }

    public boolean isLinksAgainstJava() {
        return this.linksAgainstJava;
    }

    protected String resolveToBaseDir(String directory, File baseDir) {
        File outDir = new File(directory);
        if (!outDir.isAbsolute()) {
            outDir = new File(baseDir, directory);
        }
        return outDir.getAbsolutePath();
    }
}

