/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.core.validation;

import com.google.common.collect.Lists;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtend.core.richstring.AbstractRichStringPartAcceptor;
import org.eclipse.xtend.core.richstring.IRichStringIndentationHandler;
import org.eclipse.xtend.core.richstring.IRichStringPartAcceptor;
import org.eclipse.xtend.core.xtend.RichStringLiteral;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.util.ITextRegion;
import org.eclipse.xtext.validation.ValidationMessageAcceptor;
import org.eclipse.xtext.xbase.XbasePackage;

public class ValidatingRichStringAcceptor
extends AbstractRichStringPartAcceptor.ForLoopOnce
implements IRichStringIndentationHandler {
    private final ValidationMessageAcceptor acceptor;
    private int currentOffset = -1;
    private int wasCurrentOffset = -1;
    private RichStringLiteral recent = null;
    private RichStringLiteral root = null;
    private LinkedList<String> indentationStack;
    private String unfulfilledIndentationExpectation = null;
    private int lastOffsetOfLiteral = -1;

    public ValidatingRichStringAcceptor(ValidationMessageAcceptor acceptor) {
        this.acceptor = acceptor;
        this.indentationStack = Lists.newLinkedList();
    }

    @Override
    public void announceNextLiteral(RichStringLiteral object) {
        this.resetCurrentOffset(object);
    }

    @Override
    public void acceptSemanticText(CharSequence text, RichStringLiteral origin) {
        this.resetCurrentOffset(origin);
        this.currentOffset += text.length();
        this.wasCurrentOffset = -1;
    }

    protected void resetCurrentOffset(RichStringLiteral origin) {
        if (this.root == null) {
            this.root = origin;
        }
        if (origin != null && origin != this.recent) {
            if (this.wasCurrentOffset == -1) {
                this.wasCurrentOffset = this.currentOffset;
            }
            int diff = this.lastOffsetOfLiteral - this.currentOffset;
            this.recent = origin;
            List featureNodes = NodeModelUtils.findNodesForFeature((EObject)origin, (EStructuralFeature)XbasePackage.Literals.XSTRING_LITERAL__VALUE);
            if (featureNodes.size() == 1) {
                INode node = (INode)featureNodes.get(0);
                ITextRegion textRegion = node.getTextRegion();
                this.currentOffset = textRegion.getOffset();
                String nodeText = node.getText();
                if (nodeText.endsWith("'''")) {
                    this.lastOffsetOfLiteral = this.currentOffset + textRegion.getLength() - 3;
                } else if (nodeText.endsWith("''")) {
                    this.lastOffsetOfLiteral = this.currentOffset + textRegion.getLength() - 2;
                } else if (nodeText.endsWith("'") || nodeText.endsWith("\u00ab")) {
                    this.lastOffsetOfLiteral = this.currentOffset + textRegion.getLength() - 1;
                }
                this.currentOffset = nodeText.charAt(0) == '\'' ? (this.currentOffset += 3) : ++this.currentOffset;
            }
            this.currentOffset -= diff;
        }
    }

    @Override
    public void acceptTemplateText(CharSequence text, RichStringLiteral origin) {
        this.resetCurrentOffset(origin);
        this.currentOffset += text.length();
        this.wasCurrentOffset = -1;
    }

    @Override
    public void acceptSemanticLineBreak(int charCount, RichStringLiteral origin, boolean controlStructureSeen) {
        this.resetCurrentOffset(origin);
        this.currentOffset += charCount;
        this.wasCurrentOffset = -1;
    }

    @Override
    public void acceptTemplateLineBreak(int charCount, RichStringLiteral origin) {
        this.resetCurrentOffset(origin);
        this.currentOffset += charCount;
        this.wasCurrentOffset = -1;
    }

    @Override
    public void pushTemplateIndentation(CharSequence completeIndentation) {
        this.pushIndentation(completeIndentation);
    }

    @Override
    public void pushSemanticIndentation(CharSequence completeIndentation) {
        this.pushIndentation(completeIndentation);
    }

    protected void pushIndentation(CharSequence completeIndentation) {
        if (this.indentationStack.isEmpty()) {
            this.indentationStack.add(completeIndentation.toString());
        } else {
            String previous;
            String indentationString = completeIndentation.toString();
            if (!indentationString.startsWith(previous = this.indentationStack.getLast())) {
                this.unfulfilledIndentationExpectation = previous;
            }
            this.indentationStack.add(indentationString);
        }
    }

    @Override
    public void popIndentation() {
        this.indentationStack.removeLast();
    }

    @Override
    public void accept(IRichStringPartAcceptor acceptor) {
        if (this.indentationStack.isEmpty()) {
            return;
        }
        String indentation = this.indentationStack.getLast();
        if (this.unfulfilledIndentationExpectation != null) {
            if (this.currentOffset + indentation.length() != this.lastOffsetOfLiteral && indentation.length() != 0) {
                if (this.wasCurrentOffset == -1) {
                    this.acceptor.acceptWarning("Inconsistent indentation", (EObject)this.root, this.currentOffset, indentation.length(), "org.eclipse.xtend.core.validation.IssueCodes.inconsistent_indentation", new String[]{this.unfulfilledIndentationExpectation});
                } else {
                    this.acceptor.acceptWarning("Inconsistent indentation", (EObject)this.root, this.wasCurrentOffset, this.currentOffset + indentation.length() - this.wasCurrentOffset, "org.eclipse.xtend.core.validation.IssueCodes.inconsistent_indentation", new String[]{this.unfulfilledIndentationExpectation});
                }
            }
            this.unfulfilledIndentationExpectation = null;
        }
        this.currentOffset += indentation.length();
    }

    @Override
    public CharSequence getTotalSemanticIndentation() {
        return "";
    }

    @Override
    public CharSequence getTotalIndentation() {
        if (this.indentationStack.isEmpty()) {
            return "";
        }
        return this.indentationStack.getLast();
    }
}

