/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.core.macro.declaration;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtend.core.macro.ConditionUtils;
import org.eclipse.xtend.core.macro.declaration.JvmMemberDeclarationImpl;
import org.eclipse.xtend.lib.macro.declaration.AnnotationTypeDeclaration;
import org.eclipse.xtend.lib.macro.declaration.ClassDeclaration;
import org.eclipse.xtend.lib.macro.declaration.CompilationUnit;
import org.eclipse.xtend.lib.macro.declaration.ConstructorDeclaration;
import org.eclipse.xtend.lib.macro.declaration.EnumerationTypeDeclaration;
import org.eclipse.xtend.lib.macro.declaration.FieldDeclaration;
import org.eclipse.xtend.lib.macro.declaration.InterfaceDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MemberDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MethodDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableConstructorDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableFieldDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableMethodDeclaration;
import org.eclipse.xtend.lib.macro.declaration.ParameterDeclaration;
import org.eclipse.xtend.lib.macro.declaration.Type;
import org.eclipse.xtend.lib.macro.declaration.TypeDeclaration;
import org.eclipse.xtend.lib.macro.declaration.TypeReference;
import org.eclipse.xtend.lib.macro.services.TypeReferenceProvider;
import org.eclipse.xtext.common.types.JvmConstructor;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmField;
import org.eclipse.xtext.common.types.JvmMember;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.JvmVisibility;
import org.eclipse.xtext.common.types.TypesFactory;
import org.eclipse.xtext.xbase.jvmmodel.JvmTypeExtensions;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;

public abstract class JvmTypeDeclarationImpl<T extends JvmDeclaredType>
extends JvmMemberDeclarationImpl<T> {
    public Iterable<? extends MemberDeclaration> getDeclaredMembers() {
        JvmDeclaredType _delegate = (JvmDeclaredType)this.getDelegate();
        EList _members = _delegate.getMembers();
        Functions.Function1<JvmMember, MemberDeclaration> _function = new Functions.Function1<JvmMember, MemberDeclaration>(){

            public MemberDeclaration apply(JvmMember it) {
                CompilationUnit _compilationUnit = JvmTypeDeclarationImpl.this.getCompilationUnit();
                return _compilationUnit.toMemberDeclaration(it);
            }
        };
        List _map = ListExtensions.map((List)_members, (Functions.Function1)_function);
        return ImmutableList.copyOf((Collection)_map);
    }

    @Override
    public String getSimpleName() {
        JvmDeclaredType _delegate = (JvmDeclaredType)this.getDelegate();
        return _delegate.getSimpleName();
    }

    public String getQualifiedName() {
        JvmDeclaredType _delegate = (JvmDeclaredType)this.getDelegate();
        return _delegate.getQualifiedName('.');
    }

    public boolean isAssignableFrom(Type otherType) {
        boolean _equals = Objects.equal((Object)otherType, null);
        if (_equals) {
            return false;
        }
        CompilationUnit _compilationUnit = this.getCompilationUnit();
        TypeReferenceProvider _typeReferenceProvider = _compilationUnit.getTypeReferenceProvider();
        TypeReference thisTypeRef = _typeReferenceProvider.newTypeReference((Type)this, new TypeReference[0]);
        CompilationUnit _compilationUnit_1 = this.getCompilationUnit();
        TypeReferenceProvider _typeReferenceProvider_1 = _compilationUnit_1.getTypeReferenceProvider();
        TypeReference thatTypeRef = _typeReferenceProvider_1.newTypeReference(otherType, new TypeReference[0]);
        return thisTypeRef.isAssignableFrom(thatTypeRef);
    }

    public MutableConstructorDeclaration addConstructor(Procedures.Procedure1<MutableConstructorDeclaration> initializer) {
        boolean _notEquals_1;
        this.checkMutable();
        boolean _notEquals = !Objects.equal(initializer, null);
        Preconditions.checkArgument((boolean)_notEquals, (Object)"initializer cannot be null");
        JvmDeclaredType _delegate = (JvmDeclaredType)this.getDelegate();
        EList _members = _delegate.getMembers();
        Iterable _filter = Iterables.filter((Iterable)_members, JvmConstructor.class);
        Functions.Function1<JvmConstructor, Boolean> _function = new Functions.Function1<JvmConstructor, Boolean>(){

            public Boolean apply(JvmConstructor it) {
                CompilationUnit _compilationUnit = JvmTypeDeclarationImpl.this.getCompilationUnit();
                JvmTypeExtensions _typeExtensions = _compilationUnit.getTypeExtensions();
                return _typeExtensions.isSingleSyntheticDefaultConstructor(it);
            }
        };
        JvmConstructor constructor = (JvmConstructor)IterableExtensions.findFirst((Iterable)_filter, (Functions.Function1)_function);
        boolean bl = _notEquals_1 = !Objects.equal((Object)constructor, null);
        if (_notEquals_1) {
            EcoreUtil.remove((EObject)constructor);
        }
        JvmConstructor newConstructor = TypesFactory.eINSTANCE.createJvmConstructor();
        newConstructor.setVisibility(JvmVisibility.PUBLIC);
        String _simpleName = this.getSimpleName();
        newConstructor.setSimpleName(_simpleName);
        JvmDeclaredType _delegate_1 = (JvmDeclaredType)this.getDelegate();
        EList _members_1 = _delegate_1.getMembers();
        _members_1.add((Object)newConstructor);
        CompilationUnit _compilationUnit = this.getCompilationUnit();
        MemberDeclaration _memberDeclaration = _compilationUnit.toMemberDeclaration((JvmMember)newConstructor);
        MutableConstructorDeclaration mutableConstructorDeclaration = (MutableConstructorDeclaration)_memberDeclaration;
        initializer.apply((Object)mutableConstructorDeclaration);
        return mutableConstructorDeclaration;
    }

    public MutableFieldDeclaration addField(String name, Procedures.Procedure1<MutableFieldDeclaration> initializer) {
        this.checkMutable();
        ConditionUtils.checkJavaIdentifier(name, "name");
        boolean _notEquals = !Objects.equal(initializer, null);
        Preconditions.checkArgument((boolean)_notEquals, (Object)"initializer cannot be null");
        JvmField newField = TypesFactory.eINSTANCE.createJvmField();
        newField.setSimpleName(name);
        newField.setVisibility(JvmVisibility.PRIVATE);
        JvmDeclaredType _delegate = (JvmDeclaredType)this.getDelegate();
        EList _members = _delegate.getMembers();
        _members.add((Object)newField);
        CompilationUnit _compilationUnit = this.getCompilationUnit();
        MemberDeclaration _memberDeclaration = _compilationUnit.toMemberDeclaration((JvmMember)newField);
        MutableFieldDeclaration mutableFieldDeclaration = (MutableFieldDeclaration)_memberDeclaration;
        initializer.apply((Object)mutableFieldDeclaration);
        return mutableFieldDeclaration;
    }

    public MutableMethodDeclaration addMethod(String name, Procedures.Procedure1<MutableMethodDeclaration> initializer) {
        this.checkMutable();
        ConditionUtils.checkJavaIdentifier(name, "name");
        boolean _notEquals = !Objects.equal(initializer, null);
        Preconditions.checkArgument((boolean)_notEquals, (Object)"initializer cannot be null");
        JvmOperation newMethod = TypesFactory.eINSTANCE.createJvmOperation();
        newMethod.setVisibility(JvmVisibility.PUBLIC);
        newMethod.setSimpleName(name);
        CompilationUnit _compilationUnit = this.getCompilationUnit();
        CompilationUnit _compilationUnit_1 = this.getCompilationUnit();
        TypeReferenceProvider _typeReferenceProvider = _compilationUnit_1.getTypeReferenceProvider();
        TypeReference _primitiveVoid = _typeReferenceProvider.getPrimitiveVoid();
        JvmTypeReference _jvmTypeReference = _compilationUnit.toJvmTypeReference(_primitiveVoid);
        newMethod.setReturnType(_jvmTypeReference);
        JvmDeclaredType _delegate = (JvmDeclaredType)this.getDelegate();
        EList _members = _delegate.getMembers();
        _members.add((Object)newMethod);
        CompilationUnit _compilationUnit_2 = this.getCompilationUnit();
        MemberDeclaration _memberDeclaration = _compilationUnit_2.toMemberDeclaration((JvmMember)newMethod);
        MutableMethodDeclaration mutableMethodDeclaration = (MutableMethodDeclaration)_memberDeclaration;
        initializer.apply((Object)mutableMethodDeclaration);
        return mutableMethodDeclaration;
    }

    public ConstructorDeclaration findDeclaredConstructor(final TypeReference ... parameterTypes) {
        ConstructorDeclaration _xblockexpression = null;
        ConditionUtils.checkIterable((Iterable)Conversions.doWrapArray((Object)parameterTypes), "parameterTypes");
        Iterable<ConstructorDeclaration> _declaredConstructors = this.getDeclaredConstructors();
        Functions.Function1<ConstructorDeclaration, Boolean> _function = new Functions.Function1<ConstructorDeclaration, Boolean>(){

            public Boolean apply(ConstructorDeclaration constructor) {
                Iterable _parameters = constructor.getParameters();
                Functions.Function1<ParameterDeclaration, TypeReference> _function = new Functions.Function1<ParameterDeclaration, TypeReference>(){

                    public TypeReference apply(ParameterDeclaration it) {
                        return it.getType();
                    }
                };
                Iterable _map = IterableExtensions.map((Iterable)_parameters, (Functions.Function1)_function);
                List _list = IterableExtensions.toList((Iterable)_map);
                List _list_1 = IterableExtensions.toList((Iterable)((Iterable)Conversions.doWrapArray((Object)parameterTypes)));
                return Objects.equal((Object)_list, (Object)_list_1);
            }
        };
        _xblockexpression = (ConstructorDeclaration)IterableExtensions.findFirst(_declaredConstructors, (Functions.Function1)_function);
        return _xblockexpression;
    }

    public FieldDeclaration findDeclaredField(final String name) {
        Iterable<FieldDeclaration> _declaredFields = this.getDeclaredFields();
        Functions.Function1<FieldDeclaration, Boolean> _function = new Functions.Function1<FieldDeclaration, Boolean>(){

            public Boolean apply(FieldDeclaration field) {
                String _simpleName = field.getSimpleName();
                return Objects.equal((Object)_simpleName, (Object)name);
            }
        };
        return (FieldDeclaration)IterableExtensions.findFirst(_declaredFields, (Functions.Function1)_function);
    }

    public TypeDeclaration findDeclaredType(final String name) {
        Iterable<TypeDeclaration> _declaredTypes = this.getDeclaredTypes();
        Functions.Function1<TypeDeclaration, Boolean> _function = new Functions.Function1<TypeDeclaration, Boolean>(){

            public Boolean apply(TypeDeclaration type) {
                String _simpleName = type.getSimpleName();
                return Objects.equal((Object)_simpleName, (Object)name);
            }
        };
        return (TypeDeclaration)IterableExtensions.findFirst(_declaredTypes, (Functions.Function1)_function);
    }

    public MethodDeclaration findDeclaredMethod(final String name, final TypeReference ... parameterTypes) {
        MethodDeclaration _xblockexpression = null;
        ConditionUtils.checkIterable((Iterable)Conversions.doWrapArray((Object)parameterTypes), "parameterTypes");
        Iterable<MethodDeclaration> _declaredMethods = this.getDeclaredMethods();
        Functions.Function1<MethodDeclaration, Boolean> _function = new Functions.Function1<MethodDeclaration, Boolean>(){

            public Boolean apply(MethodDeclaration method) {
                boolean _and = false;
                String _simpleName = method.getSimpleName();
                boolean _equals = Objects.equal((Object)_simpleName, (Object)name);
                if (!_equals) {
                    _and = false;
                } else {
                    boolean _equals_1;
                    Iterable _parameters = method.getParameters();
                    Functions.Function1<ParameterDeclaration, TypeReference> _function = new Functions.Function1<ParameterDeclaration, TypeReference>(){

                        public TypeReference apply(ParameterDeclaration it) {
                            return it.getType();
                        }
                    };
                    Iterable _map = IterableExtensions.map((Iterable)_parameters, (Functions.Function1)_function);
                    List _list = IterableExtensions.toList((Iterable)_map);
                    List _list_1 = IterableExtensions.toList((Iterable)((Iterable)Conversions.doWrapArray((Object)parameterTypes)));
                    _and = _equals_1 = Objects.equal((Object)_list, (Object)_list_1);
                }
                return _and;
            }
        };
        _xblockexpression = (MethodDeclaration)IterableExtensions.findFirst(_declaredMethods, (Functions.Function1)_function);
        return _xblockexpression;
    }

    public Iterable<? extends MethodDeclaration> getDeclaredMethods() {
        Iterable<MemberDeclaration> _declaredMembers = this.getDeclaredMembers();
        return Iterables.filter(_declaredMembers, MethodDeclaration.class);
    }

    public Iterable<? extends FieldDeclaration> getDeclaredFields() {
        Iterable<MemberDeclaration> _declaredMembers = this.getDeclaredMembers();
        return Iterables.filter(_declaredMembers, FieldDeclaration.class);
    }

    public Iterable<? extends ClassDeclaration> getDeclaredClasses() {
        Iterable<MemberDeclaration> _declaredMembers = this.getDeclaredMembers();
        return Iterables.filter(_declaredMembers, ClassDeclaration.class);
    }

    public Iterable<? extends ConstructorDeclaration> getDeclaredConstructors() {
        Iterable<MemberDeclaration> _declaredMembers = this.getDeclaredMembers();
        return Iterables.filter(_declaredMembers, ConstructorDeclaration.class);
    }

    public Iterable<? extends InterfaceDeclaration> getDeclaredInterfaces() {
        Iterable<MemberDeclaration> _declaredMembers = this.getDeclaredMembers();
        return Iterables.filter(_declaredMembers, InterfaceDeclaration.class);
    }

    public Iterable<? extends TypeDeclaration> getDeclaredTypes() {
        Iterable<MemberDeclaration> _declaredMembers = this.getDeclaredMembers();
        return Iterables.filter(_declaredMembers, TypeDeclaration.class);
    }

    public Iterable<? extends AnnotationTypeDeclaration> getDeclaredAnnotationTypes() {
        Iterable<MemberDeclaration> _declaredMembers = this.getDeclaredMembers();
        return Iterables.filter(_declaredMembers, AnnotationTypeDeclaration.class);
    }

    public Iterable<? extends EnumerationTypeDeclaration> getDeclaredEnumerationTypes() {
        Iterable<MemberDeclaration> _declaredMembers = this.getDeclaredMembers();
        return Iterables.filter(_declaredMembers, EnumerationTypeDeclaration.class);
    }

    @Override
    public void setSimpleName(String name) {
        throw new UnsupportedOperationException("The type cannot be renamed.");
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("The type cannot be removed.");
    }
}

