/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xtext.ui.wizard.project;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.xtext.xbase.lib.Procedures;

public class StatusWidget
extends Composite {
    private Link link;
    private Label imageLabel;
    private Procedures.Procedure0 quickFix = () -> {};
    private int severity = 0;
    private static final Pattern ANCHOR_PATTERN = Pattern.compile("<a>(.*)</a>");

    public StatusWidget(Composite parent, int style) {
        super(parent, style);
        this.createControls();
    }

    protected void createControls() {
        this.setLayout((Layout)new GridLayout(2, false));
        this.imageLabel = new Label((Composite)this, 0);
        this.imageLabel.setText("   ");
        GridData imgLabelLayoutData = new GridData(2);
        imgLabelLayoutData.widthHint = 20;
        this.imageLabel.setLayoutData((Object)imgLabelLayoutData);
        this.link = new Link((Composite)this, 0);
        GridData linkLayoutData = new GridData(768);
        linkLayoutData.heightHint = 40;
        this.link.setLayoutData((Object)linkLayoutData);
        this.link.setFont(this.getFont());
        this.link.setText("\n\n\n");
        this.link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                super.widgetSelected(e);
                StatusWidget.this.quickFix.apply();
            }
        });
    }

    public Procedures.Procedure0 clearStatus() {
        return this.setStatus(0, "\n\n\n", () -> {}, () -> {});
    }

    public Procedures.Procedure0 setStatus(int severity, String text, Procedures.Procedure0 quickFix, Procedures.Procedure0 callback) {
        this.severity = severity;
        this.setVisible(severity != 0);
        this.imageLabel.setImage(this.imageFor(severity));
        this.link.setText(text);
        Matcher matcher = ANCHOR_PATTERN.matcher(text.trim());
        this.link.setToolTipText(matcher.replaceAll("$1"));
        this.quickFix = () -> {
            quickFix.apply();
            callback.apply();
        };
        return this.quickFix;
    }

    public Procedures.Procedure0 addStatus(int severity, String text) {
        Procedures.Procedure0 status = null;
        if (this.link.getText().trim().isEmpty()) {
            status = this.setStatus(severity, text, () -> {}, () -> {});
        } else {
            this.link.setText(String.valueOf(this.link.getText()) + "\n" + text);
            Matcher matcher = ANCHOR_PATTERN.matcher(text.trim());
            this.link.setToolTipText(matcher.replaceAll("$1"));
            if (severity > this.severity) {
                this.severity = severity;
                this.setVisible(severity != 0);
                this.imageLabel.setImage(this.imageFor(severity));
            }
        }
        return status;
    }

    public int getSevertity() {
        return this.severity;
    }

    private Image imageFor(int type) {
        switch (type) {
            case 0: {
                return null;
            }
            case 1: {
                return JFaceResources.getImage((String)"dialog_messasge_info_image");
            }
            case 2: {
                return JFaceResources.getImage((String)"dialog_messasge_warning_image");
            }
            case 3: {
                return JFaceResources.getImage((String)"dialog_message_error_image");
            }
        }
        return null;
    }
}

