/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.junit4.internal;

import com.google.common.collect.ClassToInstanceMap;
import com.google.common.collect.MutableClassToInstanceMap;
import org.eclipse.xtext.junit4.IInjectorProvider;
import org.eclipse.xtext.junit4.InjectWith;
import org.eclipse.xtext.util.Exceptions;
import org.junit.runners.model.TestClass;

public class InjectorProviders {
    private static ClassToInstanceMap<IInjectorProvider> injectorProviderClassCache = MutableClassToInstanceMap.create();

    public static IInjectorProvider getOrCreateInjectorProvider(TestClass testClass) {
        InjectWith injectWith = testClass.getJavaClass().getAnnotation(InjectWith.class);
        if (injectWith != null) {
            Class<? extends IInjectorProvider> klass = injectWith.value();
            IInjectorProvider injectorProvider = (IInjectorProvider)injectorProviderClassCache.get(klass);
            if (injectorProvider == null) {
                try {
                    injectorProvider = klass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    injectorProviderClassCache.put(klass, (Object)injectorProvider);
                }
                catch (Exception e) {
                    Exceptions.throwUncheckedException((Throwable)e);
                }
            }
            return injectorProvider;
        }
        return null;
    }

    public static IInjectorProvider getInjectorProvider(TestClass testClass) {
        InjectWith injectWith = testClass.getJavaClass().getAnnotation(InjectWith.class);
        if (injectWith != null) {
            return (IInjectorProvider)injectorProviderClassCache.get(injectWith.value());
        }
        return null;
    }

    public static IInjectorProvider createInjectorProvider(TestClass testClass) {
        InjectWith injectWith = testClass.getJavaClass().getAnnotation(InjectWith.class);
        if (injectWith != null) {
            try {
                return injectWith.value().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                Exceptions.throwUncheckedException((Throwable)e);
            }
        }
        return null;
    }
}

