/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor.findrefs;

import com.google.common.collect.Sets;
import com.google.inject.Inject;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.xtext.findReferences.IReferenceFinder;
import org.eclipse.xtext.findReferences.TargetURIConverter;
import org.eclipse.xtext.resource.IReferenceDescription;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.IResourceDescriptions;
import org.eclipse.xtext.resource.IResourceServiceProvider;
import org.eclipse.xtext.ui.editor.findrefs.IReferenceFinder;
import org.eclipse.xtext.ui.editor.findrefs.IReferenceFinderExtension1;
import org.eclipse.xtext.ui.editor.findrefs.ReferenceAcceptor;
import org.eclipse.xtext.util.IAcceptor;

public class DelegatingReferenceFinder
implements IReferenceFinder,
IReferenceFinderExtension1 {
    @Inject
    private IResourceDescriptions indexData;
    @Inject
    private org.eclipse.xtext.findReferences.IReferenceFinder delegate;
    @Inject
    private TargetURIConverter converter;
    @Inject
    private IResourceServiceProvider.Registry resourceServiceProviderRegistry;

    @Override
    public void findReferences(Set<URI> targetURIs, IResourceDescription resourceDescription, IAcceptor<IReferenceDescription> acceptor, IProgressMonitor monitor, IReferenceFinder.ILocalResourceAccess localResourceAccess) {
        this.delegate.findReferences(this.converter.fromIterable(targetURIs), resourceDescription, (IReferenceFinder.IResourceAccess)localResourceAccess, this.toAcceptor(acceptor), monitor);
    }

    @Override
    public void findReferences(Iterable<URI> targetURIs, Iterable<URI> sourceResourceURIs, IReferenceFinder.ILocalResourceAccess localResourceAccess, IAcceptor<IReferenceDescription> acceptor, IProgressMonitor monitor) {
        HashSet asSet = Sets.newHashSet(sourceResourceURIs);
        this.delegate.findReferences(this.converter.fromIterable(targetURIs), (Set)asSet, (IReferenceFinder.IResourceAccess)localResourceAccess, this.indexData, this.toAcceptor(acceptor), monitor);
    }

    @Override
    public void findAllReferences(Iterable<URI> targetURIs, IReferenceFinder.ILocalResourceAccess localResourceAccess, IAcceptor<IReferenceDescription> acceptor, IProgressMonitor monitor) {
        this.delegate.findAllReferences(this.converter.fromIterable(targetURIs), (IReferenceFinder.IResourceAccess)localResourceAccess, this.indexData, this.toAcceptor(acceptor), monitor);
    }

    protected IReferenceFinder.Acceptor toAcceptor(IAcceptor<IReferenceDescription> acceptor) {
        return new ReferenceAcceptor(acceptor, this.resourceServiceProviderRegistry);
    }

    public TargetURIConverter getConverter() {
        return this.converter;
    }

    public void setConverter(TargetURIConverter converter) {
        this.converter = converter;
    }

    public org.eclipse.xtext.findReferences.IReferenceFinder getDelegate() {
        return this.delegate;
    }

    public void setDelegate(org.eclipse.xtext.findReferences.IReferenceFinder delegate) {
        this.delegate = delegate;
    }

    public IResourceDescriptions getIndexData() {
        return this.indexData;
    }

    public void setIndexData(IResourceDescriptions indexData) {
        this.indexData = indexData;
    }

    public IResourceServiceProvider.Registry getResourceServiceProviderRegistry() {
        return this.resourceServiceProviderRegistry;
    }

    public void setResourceServiceProviderRegistry(IResourceServiceProvider.Registry resourceServiceProviderRegistry) {
        this.resourceServiceProviderRegistry = resourceServiceProviderRegistry;
    }
}

