/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.build;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtend.lib.annotations.AccessorType;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtend.lib.annotations.Data;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.build.BuildContext;
import org.eclipse.xtext.build.BuildRequest;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.CompilerPhases;
import org.eclipse.xtext.resource.EObjectDescription;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.IReferenceDescription;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.IResourceDescriptions;
import org.eclipse.xtext.resource.IResourceServiceProvider;
import org.eclipse.xtext.resource.impl.AbstractResourceDescription;
import org.eclipse.xtext.resource.impl.DefaultResourceDescriptionDelta;
import org.eclipse.xtext.resource.impl.ResourceDescriptionsData;
import org.eclipse.xtext.resource.persistence.SerializableEObjectDescriptionProvider;
import org.eclipse.xtext.service.OperationCanceledManager;
import org.eclipse.xtext.util.internal.Log;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.lib.util.ToStringBuilder;

@Log
public class Indexer {
    @Inject
    private CompilerPhases compilerPhases;
    @Inject
    @Extension
    private OperationCanceledManager _operationCanceledManager;
    private static final Logger LOG = Logger.getLogger(Indexer.class);

    public IndexResult computeAndIndexAffected(BuildRequest request, @Extension BuildContext context) {
        boolean _not;
        ResourceDescriptionsData previousIndex = context.getOldState().getResourceDescriptions();
        ResourceDescriptionsData newIndex = request.getState().getResourceDescriptions();
        ArrayList deltas = CollectionLiterals.newArrayList();
        boolean _isInfoEnabled = LOG.isInfoEnabled();
        if (_isInfoEnabled) {
            Set _set = IterableExtensions.toSet(request.getDeletedFiles());
            String _plus = "Creating Deltas for changes. Deleted : " + _set;
            String _plus_1 = _plus + ", Changed : ";
            Set _set_1 = IterableExtensions.toSet(request.getDirtyFiles());
            String _plus_2 = _plus_1 + _set_1;
            String _plus_3 = _plus_2 + ".";
            LOG.info((Object)_plus_3);
        }
        deltas.addAll(this.getDeltasForDeletedResources(request, previousIndex, context));
        deltas.addAll(this.getDeltasForChangedResources(request.getDirtyFiles(), previousIndex, context));
        for (IResourceDescription.Delta delta : deltas) {
            newIndex.register(delta);
        }
        HashSet<IResourceDescription.Delta> allDeltas = new HashSet<IResourceDescription.Delta>(deltas);
        boolean _isEmpty = request.getExternalDeltas().isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            allDeltas.addAll(request.getExternalDeltas());
        }
        Functions.Function1 _function = it -> it.getURI();
        Set remainingURIs = IterableExtensions.toSet((Iterable)IterableExtensions.map(previousIndex.getAllResourceDescriptions(), (Functions.Function1)_function));
        Functions.Function1 _function_1 = it -> it.getUri();
        remainingURIs.removeAll(ListExtensions.map((List)deltas, (Functions.Function1)_function_1));
        Functions.Function1 _function_2 = it -> {
            IResourceDescription.Manager manager = context.getResourceServiceProvider((URI)it).getResourceDescriptionManager();
            IResourceDescription resourceDescription = previousIndex.getResourceDescription((URI)it);
            boolean isAffected = this.isAffected(resourceDescription, manager, allDeltas, allDeltas, newIndex);
            return isAffected;
        };
        List allAffected = IterableExtensions.toList((Iterable)IterableExtensions.filter((Iterable)remainingURIs, (Functions.Function1)_function_2));
        if (LOG.isInfoEnabled() && !allAffected.isEmpty()) {
            Set _set_2 = IterableExtensions.toSet((Iterable)allAffected);
            String _plus_4 = "Creating Deltas for affected resources : " + _set_2;
            String _plus_5 = _plus_4 + ".";
            LOG.info((Object)_plus_5);
        }
        deltas.addAll(this.getDeltasForChangedResources(allAffected, previousIndex, context));
        return new IndexResult(deltas, newIndex);
    }

    protected List<IResourceDescription.Delta> getDeltasForDeletedResources(BuildRequest request, ResourceDescriptionsData oldIndex, @Extension BuildContext context) {
        ArrayList deltas = CollectionLiterals.newArrayList();
        Functions.Function1 _function = it -> {
            IResourceServiceProvider _resourceServiceProvider = context.getResourceServiceProvider((URI)it);
            return _resourceServiceProvider != null;
        };
        Consumer<URI> _function_1 = it -> {
            IResourceDescription oldDescription;
            this._operationCanceledManager.checkCanceled(context.getCancelIndicator());
            IResourceDescription _resourceDescription = null;
            if (oldIndex != null) {
                _resourceDescription = oldIndex.getResourceDescription((URI)it);
            }
            if ((oldDescription = _resourceDescription) != null) {
                DefaultResourceDescriptionDelta delta = new DefaultResourceDescriptionDelta(oldDescription, null);
                deltas.add(delta);
            }
        };
        IterableExtensions.filter(request.getDeletedFiles(), (Functions.Function1)_function).forEach(_function_1);
        return deltas;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<IResourceDescription.Delta> getDeltasForChangedResources(Iterable<URI> affectedUris, ResourceDescriptionsData oldIndex, @Extension BuildContext context) {
        try {
            this.compilerPhases.setIndexing((Notifier)context.getResourceSet(), true);
            Functions.Function1 _function = it -> this.addToIndex((Resource)it, true, oldIndex, context);
            List list = IterableExtensions.toList(context.executeClustered(affectedUris, _function));
            return list;
        }
        finally {
            this.compilerPhases.setIndexing((Notifier)context.getResourceSet(), false);
        }
    }

    protected IResourceDescription.Delta addToIndex(Resource resource, boolean isPreIndexing, ResourceDescriptionsData oldIndex, BuildContext context) {
        this._operationCanceledManager.checkCanceled(context.getCancelIndicator());
        URI uri = resource.getURI();
        IResourceServiceProvider serviceProvider = context.getResourceServiceProvider(uri);
        IResourceDescription.Manager manager = serviceProvider.getResourceDescriptionManager();
        IResourceDescription newDescription = manager.getResourceDescription(resource);
        ResolvedResourceDescription toBeAdded = new ResolvedResourceDescription(newDescription);
        IResourceDescription _resourceDescription = null;
        if (oldIndex != null) {
            _resourceDescription = oldIndex.getResourceDescription(uri);
        }
        IResourceDescription.Delta delta = manager.createDelta(_resourceDescription, toBeAdded);
        return delta;
    }

    protected boolean isAffected(IResourceDescription affectionCandidate, IResourceDescription.Manager manager, Collection<IResourceDescription.Delta> newDeltas, Collection<IResourceDescription.Delta> allDeltas, IResourceDescriptions resourceDescriptions) {
        if (manager instanceof IResourceDescription.Manager.AllChangeAware) {
            return ((IResourceDescription.Manager.AllChangeAware)manager).isAffectedByAny(allDeltas, affectionCandidate, resourceDescriptions);
        }
        boolean _isEmpty = newDeltas.isEmpty();
        if (_isEmpty) {
            return false;
        }
        return manager.isAffected(newDeltas, affectionCandidate, resourceDescriptions);
    }

    @Log
    protected static class ResolvedResourceDescription
    extends AbstractResourceDescription {
        @Accessors(value={AccessorType.PUBLIC_GETTER})
        private URI URI;
        private ImmutableList<IEObjectDescription> exported;
        private static final Logger LOG = Logger.getLogger(ResolvedResourceDescription.class);

        public ResolvedResourceDescription(IResourceDescription original) {
            this.URI = original.getURI();
            Functions.Function1 _function = from -> {
                String[] _userDataKeys;
                if (from instanceof SerializableEObjectDescriptionProvider) {
                    return ((SerializableEObjectDescriptionProvider)((Object)from)).toSerializableEObjectDescription();
                }
                boolean _eIsProxy = from.getEObjectOrProxy().eIsProxy();
                if (_eIsProxy) {
                    return from;
                }
                EObject _create = EcoreUtil.create((EClass)from.getEClass());
                InternalEObject result = (InternalEObject)_create;
                result.eSetProxyURI(from.getEObjectURI());
                HashMap userData = null;
                for (String key : _userDataKeys = from.getUserDataKeys()) {
                    if (userData == null) {
                        userData = Maps.newHashMapWithExpectedSize((int)2);
                    }
                    userData.put(key, from.getUserData(key));
                }
                return EObjectDescription.create(from.getName(), (EObject)result, userData);
            };
            this.exported = ImmutableList.copyOf((Iterable)IterableExtensions.map(original.getExportedObjects(), (Functions.Function1)_function));
        }

        @Override
        protected List<IEObjectDescription> computeExportedObjects() {
            return this.exported;
        }

        @Override
        public Iterable<QualifiedName> getImportedNames() {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("getImportedNames ");
            _builder.append((Object)this.URI);
            IllegalStateException exception = new IllegalStateException(_builder.toString());
            LOG.error((Object)exception, (Throwable)exception);
            return CollectionLiterals.emptyList();
        }

        @Override
        public Iterable<IReferenceDescription> getReferenceDescriptions() {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("getReferenceDescriptions ");
            _builder.append((Object)this.URI);
            IllegalStateException exception = new IllegalStateException(_builder.toString());
            LOG.error((Object)exception, (Throwable)exception);
            return CollectionLiterals.emptyList();
        }

        @Override
        @Pure
        public URI getURI() {
            return this.URI;
        }
    }

    @Data
    public static class IndexResult {
        private final List<IResourceDescription.Delta> resourceDeltas;
        private final ResourceDescriptionsData newIndex;

        public IndexResult(List<IResourceDescription.Delta> resourceDeltas, ResourceDescriptionsData newIndex) {
            this.resourceDeltas = resourceDeltas;
            this.newIndex = newIndex;
        }

        @Pure
        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.resourceDeltas == null ? 0 : this.resourceDeltas.hashCode());
            return 31 * result + (this.newIndex == null ? 0 : this.newIndex.hashCode());
        }

        @Pure
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            IndexResult other = (IndexResult)obj;
            if (this.resourceDeltas == null ? other.resourceDeltas != null : !this.resourceDeltas.equals(other.resourceDeltas)) {
                return false;
            }
            return !(this.newIndex == null ? other.newIndex != null : !this.newIndex.equals(other.newIndex));
        }

        @Pure
        public String toString() {
            ToStringBuilder b = new ToStringBuilder((Object)this);
            b.add("resourceDeltas", this.resourceDeltas);
            b.add("newIndex", (Object)this.newIndex);
            return b.toString();
        }

        @Pure
        public List<IResourceDescription.Delta> getResourceDeltas() {
            return this.resourceDeltas;
        }

        @Pure
        public ResourceDescriptionsData getNewIndex() {
            return this.newIndex;
        }
    }
}

