/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.ui.navigation;

import com.google.common.collect.Lists;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.NodeFinder;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SuperMethodInvocation;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchParticipant;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.core.search.SearchRequestor;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.jdt.internal.corext.util.JdtFlags;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.text.JavaElementProvider;
import org.eclipse.jdt.ui.JavaElementLabels;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jdt.ui.SharedASTProvider;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.text.AbstractInformationControlManager;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.information.IInformationProvider;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.xtext.xbase.ui.hierarchy.HierarchyInformationPresenter;

public class JvmImplementationOpener {
    private static final Logger log = Logger.getLogger(JvmImplementationOpener.class);

    public void openImplementations(final IJavaElement element, ITextViewer textviewer, IRegion region) {
        if (element instanceof IMethod) {
            ITypeRoot typeRoot = ((IMethod)element).getTypeRoot();
            CompilationUnit ast = SharedASTProvider.getAST((ITypeRoot)typeRoot, (SharedASTProvider.WAIT_FLAG)SharedASTProvider.WAIT_YES, null);
            if (ast == null) {
                this.openQuickHierarchy(textviewer, element, region);
                return;
            }
            try {
                ArrayList links;
                block16: {
                    IType type;
                    ISourceRange nameRange = ((IMethod)element).getNameRange();
                    ASTNode node = NodeFinder.perform((ASTNode)ast, (ISourceRange)nameRange);
                    ITypeBinding parentTypeBinding = null;
                    if (node instanceof SimpleName) {
                        ASTNode parent = node.getParent();
                        if (parent instanceof MethodInvocation) {
                            Expression expression = ((MethodInvocation)parent).getExpression();
                            parentTypeBinding = expression == null ? Bindings.getBindingOfParentType((ASTNode)node) : expression.resolveTypeBinding();
                        } else {
                            if (parent instanceof SuperMethodInvocation) {
                                this.openEditor(element);
                                return;
                            }
                            if (parent instanceof MethodDeclaration) {
                                parentTypeBinding = Bindings.getBindingOfParentType((ASTNode)node);
                            }
                        }
                    }
                    IType iType = type = parentTypeBinding != null ? (IType)parentTypeBinding.getJavaElement() : null;
                    if (type == null) {
                        this.openQuickHierarchy(textviewer, element, region);
                        return;
                    }
                    String earlyExitIndicator = "EarlyExitIndicator";
                    links = Lists.newArrayList();
                    IRunnableWithProgress runnable = new IRunnableWithProgress(){

                        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                            if (monitor == null) {
                                monitor = new NullProgressMonitor();
                            }
                            try {
                                try {
                                    String methodLabel = JavaElementLabels.getElementLabel((IJavaElement)element, (long)JavaElementLabels.DEFAULT_QUALIFIED);
                                    monitor.beginTask(Messages.format((String)"Searching for implementors of  ''{0}''", (Object)methodLabel), 100);
                                    SearchRequestor requestor = new SearchRequestor(){

                                        public void acceptSearchMatch(SearchMatch match) throws CoreException {
                                            IJavaElement element;
                                            if (match.getAccuracy() == 0 && (element = (IJavaElement)match.getElement()) instanceof IMethod && !JdtFlags.isAbstract((IMember)((IMethod)element))) {
                                                links.add(element);
                                                if (links.size() > 1) {
                                                    throw new OperationCanceledException("EarlyExitIndicator");
                                                }
                                            }
                                        }
                                    };
                                    int limitTo = 48;
                                    SearchPattern pattern = SearchPattern.createPattern((IJavaElement)element, (int)limitTo);
                                    Assert.isNotNull((Object)pattern);
                                    SearchParticipant[] participants = new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()};
                                    SearchEngine engine = new SearchEngine();
                                    engine.search(pattern, participants, SearchEngine.createHierarchyScope((IType)type), requestor, (IProgressMonitor)new SubProgressMonitor(monitor, 100));
                                    if (monitor.isCanceled()) {
                                        throw new InterruptedException();
                                    }
                                }
                                catch (OperationCanceledException e) {
                                    throw new InterruptedException(e.getMessage());
                                }
                                catch (CoreException e) {
                                    throw new InvocationTargetException(e);
                                }
                            }
                            finally {
                                monitor.done();
                            }
                        }
                    };
                    try {
                        PlatformUI.getWorkbench().getProgressService().busyCursorWhile(runnable);
                    }
                    catch (InvocationTargetException e) {
                        Status status = new Status(4, JavaPlugin.getPluginId(), 0, Messages.format((String)"An error occurred while searching for implementations of method ''{0}''. See error log for details.", (Object)element.getElementName()), e.getCause());
                        JavaPlugin.log((IStatus)status);
                        ErrorDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Open Implementation", (String)"Problems finding implementations.", (IStatus)status);
                    }
                    catch (InterruptedException e) {
                        if (e.getMessage() == "EarlyExitIndicator") break block16;
                        return;
                    }
                }
                if (links.size() == 1) {
                    this.openEditor((IJavaElement)links.get(0));
                } else {
                    this.openQuickHierarchy(textviewer, element, region);
                }
            }
            catch (JavaModelException e) {
                log.error((Object)"An error occurred while searching for implementations", e.getCause());
            }
            catch (PartInitException e) {
                log.error((Object)"An error occurred while searching for implementations", e.getCause());
            }
        }
    }

    protected IEditorPart openEditor(IJavaElement element) throws JavaModelException, PartInitException {
        return JavaUI.openInEditor((IJavaElement)element);
    }

    protected void openQuickHierarchy(ITextViewer textViewer, IJavaElement element, IRegion region) {
        HierarchyInformationPresenter presenter = new HierarchyInformationPresenter((ISourceViewer)textViewer, element, region);
        presenter.setDocumentPartitioning("__dftl_partitioning");
        presenter.setAnchor(AbstractInformationControlManager.ANCHOR_GLOBAL);
        JavaElementProvider provider = new JavaElementProvider(null, false);
        presenter.setInformationProvider((IInformationProvider)provider, "__dftl_partition_content_type");
        presenter.setInformationProvider((IInformationProvider)provider, "__java_javadoc");
        presenter.setInformationProvider((IInformationProvider)provider, "__java_multiline_comment");
        presenter.setInformationProvider((IInformationProvider)provider, "__java_singleline_comment");
        presenter.setInformationProvider((IInformationProvider)provider, "__java_string");
        presenter.setInformationProvider((IInformationProvider)provider, "__java_character");
        presenter.setSizeConstraints(50, 20, true, false);
        presenter.install(textViewer);
        presenter.showInformation();
    }
}

