/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xtext.wizard;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import java.util.Set;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xtext.wizard.ExternalDependency;
import org.eclipse.xtext.xtext.wizard.Outlet;
import org.eclipse.xtext.xtext.wizard.ProjectDescriptor;
import org.eclipse.xtext.xtext.wizard.Scope;
import org.eclipse.xtext.xtext.wizard.TextFile;

public class GradleBuildFile
extends TextFile {
    @Accessors
    private String pluginsSection = "";
    @Accessors
    private String additionalContent = "";

    public GradleBuildFile(ProjectDescriptor project) {
        super(Outlet.ROOT, "build.gradle", project);
    }

    @Override
    public String getContent() {
        boolean _not;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)this.pluginsSection, "");
        _builder.newLineIfNotEmpty();
        Iterable<Object> _allDependencies = this.getAllDependencies();
        boolean _isEmpty = IterableExtensions.isEmpty(_allDependencies);
        boolean bl = _not = !_isEmpty;
        if (_not) {
            _builder.append((Object)"dependencies {");
            _builder.newLine();
            ProjectDescriptor _project = this.getProject();
            Set<? extends ProjectDescriptor> _upstreamProjects = _project.getUpstreamProjects();
            for (ProjectDescriptor projectDescriptor : _upstreamProjects) {
                _builder.append((Object)"\t");
                _builder.append((Object)"compile project(':");
                String _name = projectDescriptor.getName();
                _builder.append((Object)_name, "\t");
                _builder.append((Object)"')");
                _builder.newLineIfNotEmpty();
            }
            Iterable<ExternalDependency.MavenCoordinates> _mavenDependencies = this.getMavenDependencies();
            for (ExternalDependency.MavenCoordinates dep : _mavenDependencies) {
                _builder.append((Object)"\t");
                Scope _scope = dep.getScope();
                String _gradleNotation = _scope.getGradleNotation();
                _builder.append((Object)_gradleNotation, "\t");
                _builder.append((Object)" \"");
                String _groupId = dep.getGroupId();
                _builder.append((Object)_groupId, "\t");
                _builder.append((Object)":");
                String _artifactId = dep.getArtifactId();
                _builder.append((Object)_artifactId, "\t");
                _builder.append((Object)":");
                String _version = dep.getVersion();
                _builder.append((Object)_version, "\t");
                _builder.append((Object)"\"");
                _builder.newLineIfNotEmpty();
            }
            _builder.append((Object)"}");
            _builder.newLine();
        }
        _builder.append((Object)this.additionalContent, "");
        _builder.newLineIfNotEmpty();
        ProjectDescriptor _project_1 = this.getProject();
        boolean _isEclipsePluginProject = _project_1.isEclipsePluginProject();
        if (_isEclipsePluginProject) {
            _builder.append((Object)"//this is an eclipse plugin project");
            _builder.newLine();
            _builder.append((Object)"eclipseClasspath.enabled=false");
            _builder.newLine();
            _builder.append((Object)"cleanEclipseClasspath.enabled=false");
            _builder.newLine();
        }
        return _builder.toString();
    }

    private Iterable<ExternalDependency.MavenCoordinates> getMavenDependencies() {
        ProjectDescriptor _project = this.getProject();
        Set<ExternalDependency> _externalDependencies = _project.getExternalDependencies();
        Functions.Function1<ExternalDependency, ExternalDependency.MavenCoordinates> _function = new Functions.Function1<ExternalDependency, ExternalDependency.MavenCoordinates>(){

            public ExternalDependency.MavenCoordinates apply(ExternalDependency it) {
                return it.getMaven();
            }
        };
        Iterable _map = IterableExtensions.map(_externalDependencies, (Functions.Function1)_function);
        Functions.Function1<ExternalDependency.MavenCoordinates, Boolean> _function_1 = new Functions.Function1<ExternalDependency.MavenCoordinates, Boolean>(){

            public Boolean apply(ExternalDependency.MavenCoordinates it) {
                String _artifactId = it.getArtifactId();
                return !Objects.equal((Object)_artifactId, null);
            }
        };
        return IterableExtensions.filter((Iterable)_map, (Functions.Function1)_function_1);
    }

    private Iterable<Object> getAllDependencies() {
        ProjectDescriptor _project = this.getProject();
        Set<? extends ProjectDescriptor> _upstreamProjects = _project.getUpstreamProjects();
        Iterable<ExternalDependency.MavenCoordinates> _mavenDependencies = this.getMavenDependencies();
        return Iterables.concat(_upstreamProjects, _mavenDependencies);
    }

    @Pure
    public String getPluginsSection() {
        return this.pluginsSection;
    }

    public void setPluginsSection(String pluginsSection) {
        this.pluginsSection = pluginsSection;
    }

    @Pure
    public String getAdditionalContent() {
        return this.additionalContent;
    }

    public void setAdditionalContent(String additionalContent) {
        this.additionalContent = additionalContent;
    }
}

