/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.core.macro;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import java.io.InputStream;
import java.net.URI;
import java.util.Set;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtend.core.macro.ConditionUtils;
import org.eclipse.xtend.core.macro.declaration.CompilationUnitImpl;
import org.eclipse.xtend.core.macro.declaration.TypeLookupImpl;
import org.eclipse.xtend.core.xtend.XtendFile;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtend.lib.annotations.Delegate;
import org.eclipse.xtend.lib.macro.RegisterGlobalsContext;
import org.eclipse.xtend.lib.macro.declaration.AnnotationTypeDeclaration;
import org.eclipse.xtend.lib.macro.declaration.ClassDeclaration;
import org.eclipse.xtend.lib.macro.declaration.EnumerationTypeDeclaration;
import org.eclipse.xtend.lib.macro.declaration.InterfaceDeclaration;
import org.eclipse.xtend.lib.macro.declaration.Type;
import org.eclipse.xtend.lib.macro.file.FileLocations;
import org.eclipse.xtend.lib.macro.file.FileSystemSupport;
import org.eclipse.xtend.lib.macro.file.Path;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.common.types.JvmAnnotationType;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmEnumerationType;
import org.eclipse.xtext.common.types.JvmGenericType;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.JvmVisibility;
import org.eclipse.xtext.common.types.TypesFactory;
import org.eclipse.xtext.common.types.util.TypeReferences;
import org.eclipse.xtext.documentation.IFileHeaderProvider;
import org.eclipse.xtext.xbase.jvmmodel.IJvmDeclaredTypeAcceptor;
import org.eclipse.xtext.xbase.jvmmodel.JvmTypesBuilder;
import org.eclipse.xtext.xbase.lib.Pair;
import org.eclipse.xtext.xbase.lib.Pure;

public class RegisterGlobalsContextImpl
implements RegisterGlobalsContext {
    @Accessors
    private IJvmDeclaredTypeAcceptor acceptor;
    @Accessors
    private CompilationUnitImpl compilationUnit;

    public void registerAnnotationType(String qualifiedName) throws IllegalArgumentException {
        JvmAnnotationType newType = TypesFactory.eINSTANCE.createJvmAnnotationType();
        newType.setVisibility(JvmVisibility.PUBLIC);
        this.setNameAndAccept((JvmDeclaredType)newType, qualifiedName);
    }

    public void registerClass(String qualifiedName) throws IllegalArgumentException {
        JvmGenericType newType = TypesFactory.eINSTANCE.createJvmGenericType();
        newType.setVisibility(JvmVisibility.PUBLIC);
        EList _superTypes = newType.getSuperTypes();
        TypeReferences _typeReferences = this.compilationUnit.getTypeReferences();
        XtendFile _xtendFile = this.compilationUnit.getXtendFile();
        JvmTypeReference _typeForName = _typeReferences.getTypeForName(Object.class, (Notifier)_xtendFile, new JvmTypeReference[0]);
        _superTypes.add((Object)_typeForName);
        this.setNameAndAccept((JvmDeclaredType)newType, qualifiedName);
    }

    public void registerEnumerationType(String qualifiedName) throws IllegalArgumentException {
        JvmEnumerationType newType = TypesFactory.eINSTANCE.createJvmEnumerationType();
        newType.setVisibility(JvmVisibility.PUBLIC);
        this.setNameAndAccept((JvmDeclaredType)newType, qualifiedName);
    }

    public void registerInterface(String qualifiedName) throws IllegalArgumentException {
        JvmGenericType newType = TypesFactory.eINSTANCE.createJvmGenericType();
        newType.setVisibility(JvmVisibility.PUBLIC);
        newType.setInterface(true);
        this.setNameAndAccept((JvmDeclaredType)newType, qualifiedName);
    }

    private void setNameAndAccept(JvmDeclaredType newType, String qualifiedName) {
        boolean _notEquals;
        ConditionUtils.checkQualifiedName(qualifiedName, "qualifiedName");
        JvmDeclaredType _findType = this.findType(qualifiedName);
        boolean _equals = Objects.equal((Object)_findType, null);
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"The type '");
        _builder.append((Object)qualifiedName, "");
        _builder.append((Object)"' has already been registered.");
        Preconditions.checkArgument((boolean)_equals, (Object)_builder);
        this.compilationUnit.checkCanceled();
        Pair<String, String> namespaceAndName = this.getNameParts(qualifiedName);
        IFileHeaderProvider _fileHeaderProvider = this.compilationUnit.getFileHeaderProvider();
        XtendFile _xtendFile = this.compilationUnit.getXtendFile();
        Resource _eResource = _xtendFile.eResource();
        String headerText = _fileHeaderProvider.getFileHeader(_eResource);
        JvmTypesBuilder _jvmTypesBuilder = this.compilationUnit.getJvmTypesBuilder();
        _jvmTypesBuilder.setFileHeader(newType, headerText);
        String _key = (String)namespaceAndName.getKey();
        boolean bl = _notEquals = !Objects.equal((Object)_key, null);
        if (_notEquals) {
            boolean _notEquals_1;
            String _key_1 = (String)namespaceAndName.getKey();
            JvmDeclaredType parentType = this.findType(_key_1);
            boolean bl2 = _notEquals_1 = !Objects.equal((Object)parentType, null);
            if (_notEquals_1) {
                EList _members = parentType.getMembers();
                _members.add((Object)newType);
                newType.setStatic(true);
            } else {
                String _key_2 = (String)namespaceAndName.getKey();
                newType.setPackageName(_key_2);
                this.acceptor.accept(newType);
            }
        } else {
            this.acceptor.accept(newType);
        }
        String _value = (String)namespaceAndName.getValue();
        newType.setSimpleName(_value);
    }

    private JvmDeclaredType findType(String string) {
        XtendFile _xtendFile = this.compilationUnit.getXtendFile();
        Resource _eResource = _xtendFile.eResource();
        EList _contents = _eResource.getContents();
        Iterable _filter = Iterables.filter((Iterable)_contents, JvmDeclaredType.class);
        return this.findRecursively(string, _filter);
    }

    private JvmDeclaredType findRecursively(String string, Iterable<? extends JvmDeclaredType> types) {
        for (JvmDeclaredType jvmDeclaredType : types) {
            boolean _notEquals;
            String candidateQualifiedName = jvmDeclaredType.getQualifiedName('.');
            boolean _equals = Objects.equal((Object)string, (Object)candidateQualifiedName);
            if (_equals) {
                return jvmDeclaredType;
            }
            boolean _startsWith = string.startsWith(candidateQualifiedName);
            if (!_startsWith) continue;
            EList _members = jvmDeclaredType.getMembers();
            Iterable _filter = Iterables.filter((Iterable)_members, JvmDeclaredType.class);
            JvmDeclaredType result = this.findRecursively(string, _filter);
            boolean bl = _notEquals = !Objects.equal((Object)result, null);
            if (!_notEquals) continue;
            return result;
        }
        return null;
    }

    private Pair<String, String> getNameParts(String string) {
        int dot = 46;
        int index = string.lastIndexOf(46);
        if (index != -1) {
            String _substring = string.substring(0, index);
            String _substring_1 = string.substring(index + 1);
            return Pair.of((Object)_substring, (Object)_substring_1);
        }
        return Pair.of(null, (Object)string);
    }

    @Delegate
    public FileSystemSupport getFileSystemSupport() {
        return this.compilationUnit.getFileSystemSupport();
    }

    @Delegate
    public FileLocations getFileLocations() {
        return this.compilationUnit.getFileLocations();
    }

    @Delegate
    public TypeLookupImpl getTypeLookup() {
        return this.compilationUnit.getTypeLookup();
    }

    @Pure
    public IJvmDeclaredTypeAcceptor getAcceptor() {
        return this.acceptor;
    }

    public void setAcceptor(IJvmDeclaredTypeAcceptor acceptor) {
        this.acceptor = acceptor;
    }

    @Pure
    public CompilationUnitImpl getCompilationUnit() {
        return this.compilationUnit;
    }

    public void setCompilationUnit(CompilationUnitImpl compilationUnit) {
        this.compilationUnit = compilationUnit;
    }

    public boolean exists(Path path) {
        return this.getFileSystemSupport().exists(path);
    }

    public String getCharset(Path path) {
        return this.getFileSystemSupport().getCharset(path);
    }

    public Iterable<? extends Path> getChildren(Path path) {
        return this.getFileSystemSupport().getChildren(path);
    }

    public CharSequence getContents(Path path) {
        return this.getFileSystemSupport().getContents(path);
    }

    public InputStream getContentsAsStream(Path path) {
        return this.getFileSystemSupport().getContentsAsStream(path);
    }

    public long getLastModification(Path path) {
        return this.getFileSystemSupport().getLastModification(path);
    }

    public boolean isFile(Path path) {
        return this.getFileSystemSupport().isFile(path);
    }

    public boolean isFolder(Path path) {
        return this.getFileSystemSupport().isFolder(path);
    }

    public URI toURI(Path path) {
        return this.getFileSystemSupport().toURI(path);
    }

    public Path getProjectFolder(Path path) {
        return this.getFileLocations().getProjectFolder(path);
    }

    public Set<Path> getProjectSourceFolders(Path path) {
        return this.getFileLocations().getProjectSourceFolders(path);
    }

    public Path getSourceFolder(Path path) {
        return this.getFileLocations().getSourceFolder(path);
    }

    public Path getTargetFolder(Path sourceFolder) {
        return this.getFileLocations().getTargetFolder(sourceFolder);
    }

    public AnnotationTypeDeclaration findSourceAnnotationType(String qualifiedName) {
        return this.getTypeLookup().findSourceAnnotationType(qualifiedName);
    }

    public ClassDeclaration findSourceClass(String qualifiedName) {
        return this.getTypeLookup().findSourceClass(qualifiedName);
    }

    public EnumerationTypeDeclaration findSourceEnumerationType(String qualifiedName) {
        return this.getTypeLookup().findSourceEnumerationType(qualifiedName);
    }

    public InterfaceDeclaration findSourceInterface(String qualifiedName) {
        return this.getTypeLookup().findSourceInterface(qualifiedName);
    }

    public Type findUpstreamType(Class<?> clazz) {
        return this.getTypeLookup().findUpstreamType(clazz);
    }

    public Type findUpstreamType(String typeName) {
        return this.getTypeLookup().findUpstreamType(typeName);
    }
}

