/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.common.types.ui.trace;

import com.google.inject.Inject;
import java.util.Iterator;
import org.apache.log4j.Logger;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.internal.ui.javaeditor.IClassFileEditorInput;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;
import org.eclipse.xtext.common.types.ui.trace.ITraceForTypeRootProvider;
import org.eclipse.xtext.generator.trace.ILocationInResource;
import org.eclipse.xtext.ui.editor.XtextEditor;
import org.eclipse.xtext.ui.generator.trace.EditorInputBasedFileOpener;
import org.eclipse.xtext.ui.generator.trace.FileOpener;
import org.eclipse.xtext.ui.generator.trace.IEclipseTrace;
import org.eclipse.xtext.ui.generator.trace.OppositeFileOpenerContributor;
import org.eclipse.xtext.util.IAcceptor;

public class ClassFileBasedOpenerContributor
extends OppositeFileOpenerContributor {
    private static final Logger LOG = Logger.getLogger(ClassFileBasedOpenerContributor.class);
    @Inject
    private ITraceForTypeRootProvider traceForTypeRootProvider;

    public boolean collectGeneratedFileOpeners(IEditorPart editor, IAcceptor<FileOpener> acceptor) {
        if (editor instanceof XtextEditor && editor.getEditorInput() instanceof IClassFileEditorInput) {
            acceptor.accept((Object)this.createEditorOpener(editor.getEditorInput(), "org.eclipse.jdt.ui.ClassFileEditor"));
            return true;
        }
        return false;
    }

    public boolean collectSourceFileOpeners(IEditorPart editor, IAcceptor<FileOpener> acceptor) {
        if (!(editor instanceof XtextEditor) && editor.getEditorInput() instanceof IClassFileEditorInput) {
            IEclipseTrace trace;
            block5: {
                IClassFile classFile = ((IClassFileEditorInput)editor.getEditorInput()).getClassFile();
                trace = this.traceForTypeRootProvider.getTraceToSource((ITypeRoot)classFile);
                if (trace != null) break block5;
                return false;
            }
            try {
                Iterator iterator = trace.getAllAssociatedLocations().iterator();
                if (iterator.hasNext()) {
                    ILocationInResource location = (ILocationInResource)iterator.next();
                    String name = location.getAbsoluteResourceURI().getURI().lastSegment();
                    IEditorDescriptor editorDescriptor = IDE.getEditorDescriptor((String)name);
                    acceptor.accept((Object)this.createEditorOpener(editor.getEditorInput(), editorDescriptor.getId()));
                    return true;
                }
            }
            catch (PartInitException e) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return false;
    }

    protected EditorInputBasedFileOpener createEditorOpener(IEditorInput editorInput, String editorId) {
        return new EditorInputBasedFileOpener(editorInput, editorId);
    }
}

