/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.resource;

import com.google.common.annotations.Beta;
import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xtext.resource.IResourceServiceProvider;
import org.eclipse.xtext.util.Pair;
import org.eclipse.xtext.util.Tuples;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Beta
public class IndexingOrderer {
    @Inject(optional=true)
    private IResourceServiceProvider.Registry registry = IResourceServiceProvider.Registry.INSTANCE;

    public List<URI> getOrderedUris(final ResourceSet resourceSet, Iterable<URI> urisToIndex) {
        ArrayList prios = Lists.newArrayList((Iterable)Iterables.transform(urisToIndex, (Function)new Function<URI, Pair<URI, Integer>>(){

            public Pair<URI, Integer> apply(URI uri) {
                IndexingPriorityProvider priorityProvider;
                IResourceServiceProvider serviceProvider = IndexingOrderer.this.registry.getResourceServiceProvider(uri);
                if (serviceProvider != null && (priorityProvider = serviceProvider.get(IndexingPriorityProvider.class)) != null) {
                    return Tuples.create((Object)uri, (Object)priorityProvider.getIndexingPriority(resourceSet, uri));
                }
                return Tuples.create((Object)uri, (Object)0);
            }
        }));
        Collections.sort(prios, new Comparator<Pair<URI, Integer>>(){

            @Override
            public int compare(Pair<URI, Integer> o1, Pair<URI, Integer> o2) {
                return (Integer)o2.getSecond() - (Integer)o1.getSecond();
            }
        });
        return Lists.transform((List)prios, (Function)new Function<Pair<URI, Integer>, URI>(){

            public URI apply(Pair<URI, Integer> uri) {
                return (URI)uri.getFirst();
            }
        });
    }

    @Beta
    public static class IndexingPriorityProvider {
        public int getIndexingPriority(ResourceSet resourceSet, URI uri) {
            return 0;
        }
    }
}

