/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.codetemplates.ui.evaluator;

import com.google.common.collect.Lists;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.ui.codetemplates.templates.Codetemplate;
import org.eclipse.xtext.ui.codetemplates.templates.Dollar;
import org.eclipse.xtext.ui.codetemplates.templates.Literal;
import org.eclipse.xtext.ui.codetemplates.templates.TemplateBody;
import org.eclipse.xtext.ui.codetemplates.templates.TemplatePart;
import org.eclipse.xtext.ui.codetemplates.templates.Variable;
import org.eclipse.xtext.ui.codetemplates.ui.projectedEditing.IProjectedContent;
import org.eclipse.xtext.util.Pair;
import org.eclipse.xtext.util.Tuples;

public class EvaluatedTemplate
implements IProjectedContent {
    private final List<Pair<Integer, Integer>> mappedOffsetHints;
    private final String evaluatedResult;
    private final String originalTemplate;

    public EvaluatedTemplate(Codetemplate template) {
        TemplateBody body = template.getBody();
        StringBuilder buffer = new StringBuilder();
        StringBuilder original = new StringBuilder();
        this.mappedOffsetHints = Lists.newArrayList();
        int lastOffset = 0;
        for (TemplatePart part : body.getParts()) {
            ICompositeNode node = NodeModelUtils.getNode((EObject)part);
            if (node == null) continue;
            this.mappedOffsetHints.add((Pair<Integer, Integer>)Tuples.create((Object)buffer.length(), (Object)node.getTotalOffset()));
            lastOffset = node.getTotalOffset() + node.getTotalLength();
            original.append(node.getText());
            if (part instanceof Literal) {
                buffer.append(((Literal)part).getValue());
                continue;
            }
            if (part instanceof Dollar) {
                buffer.append("$");
                continue;
            }
            if (!(part instanceof Variable) || ((Variable)part).getName() == null) continue;
            buffer.append(((Variable)part).getName());
        }
        this.mappedOffsetHints.add((Pair<Integer, Integer>)Tuples.create((Object)buffer.length(), (Object)lastOffset));
        this.evaluatedResult = buffer.toString();
        this.originalTemplate = original.toString();
    }

    @Override
    public int getOriginalOffset(int mappedOffset) {
        Pair<Integer, Integer> current = this.mappedOffsetHints.get(0);
        int i = 1;
        while (i < this.mappedOffsetHints.size()) {
            Pair<Integer, Integer> next = this.mappedOffsetHints.get(i);
            if ((Integer)next.getFirst() > mappedOffset) {
                int result = (Integer)current.getSecond() + mappedOffset - (Integer)current.getFirst();
                return result;
            }
            current = next;
            ++i;
        }
        int result = (Integer)current.getSecond() + mappedOffset - (Integer)current.getFirst();
        return result;
    }

    @Override
    public int getMappedOffset(int originalOffset) {
        Pair<Integer, Integer> current = this.mappedOffsetHints.get(0);
        int i = 1;
        while (i < this.mappedOffsetHints.size()) {
            Pair<Integer, Integer> next = this.mappedOffsetHints.get(i);
            if ((Integer)next.getSecond() > originalOffset) {
                int result = (Integer)current.getFirst() + originalOffset - (Integer)current.getSecond();
                return result;
            }
            current = next;
            ++i;
        }
        int result = (Integer)current.getFirst() + originalOffset - (Integer)current.getSecond();
        return result;
    }

    @Override
    public String getOriginalString() {
        return this.originalTemplate;
    }

    @Override
    public String getMappedString() {
        return this.evaluatedResult;
    }
}

