/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.generator.grammarAccess;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.xpand2.XpandExecutionContext;
import org.eclipse.xtext.AbstractMetamodelDeclaration;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.Grammar;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.IGrammarAccess;
import org.eclipse.xtext.generator.AbstractGeneratorFragment;
import org.eclipse.xtext.generator.BindFactory;
import org.eclipse.xtext.generator.Binding;
import org.eclipse.xtext.generator.grammarAccess.GrammarAccessUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GrammarAccessFragment
extends AbstractGeneratorFragment {
    private static final Logger log = Logger.getLogger(GrammarAccessFragment.class);
    private String xmlVersion = "1.0";

    @Override
    public Set<Binding> getGuiceBindingsRt(Grammar grammar) {
        return new BindFactory().addTypeToType(IGrammarAccess.class.getName(), GrammarAccessUtil.getGrammarAccessFQName(grammar, this.getNaming())).getBindings();
    }

    @Override
    public String[] getExportedPackagesRt(Grammar grammar) {
        return new String[]{GrammarUtil.getNamespace((Grammar)grammar), String.valueOf(GrammarUtil.getNamespace((Grammar)grammar)) + ".services"};
    }

    @Override
    public void generate(Grammar grammar, XpandExecutionContext ctx) {
        super.generate(grammar, ctx);
        ResourceSet copiedResourceSet = EcoreUtil2.clone((ResourceSet)new ResourceSetImpl(), (ResourceSet)grammar.eResource().getResourceSet());
        Grammar copiedGrammar = (Grammar)copiedResourceSet.getResource(grammar.eResource().getURI(), true).getContents().get(0);
        String xmiPath = GrammarUtil.getClasspathRelativePathToXmi((Grammar)copiedGrammar);
        Resource resource = copiedResourceSet.createResource(URI.createURI((String)(String.valueOf(ctx.getOutput().getOutlet("SRC_GEN").getPath()) + "/" + xmiPath)), "");
        this.addAllGrammarsToResource(resource, copiedGrammar, new HashSet<Grammar>());
        if (resource instanceof XMLResource) {
            ((XMLResource)resource).setXMLVersion(this.getXmlVersion());
        }
        try {
            resource.save(null);
        }
        catch (IOException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private void addAllGrammarsToResource(Resource resource, Grammar grammar, Set<Grammar> visitedGrammars) {
        if (!visitedGrammars.add(grammar)) {
            return;
        }
        resource.getContents().add((Object)grammar);
        this.replaceResourceURIsWithNsURIs(grammar);
        for (Grammar usedGrammar : grammar.getUsedGrammars()) {
            this.addAllGrammarsToResource(resource, usedGrammar, visitedGrammars);
        }
    }

    private void replaceResourceURIsWithNsURIs(Grammar grammar) {
        for (AbstractMetamodelDeclaration metamodelDecl : grammar.getMetamodelDeclarations()) {
            EPackage generatedPackage = metamodelDecl.getEPackage();
            Resource packResource = generatedPackage.eResource();
            packResource.setURI(URI.createURI((String)generatedPackage.getNsURI()));
        }
    }

    public void setXmlVersion(String xmlVersion) {
        this.xmlVersion = xmlVersion;
    }

    public String getXmlVersion() {
        return this.xmlVersion;
    }
}

