/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.ui.wizards.project;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.m2m.internal.qvt.oml.ui.QVTUIPlugin;
import org.eclipse.m2m.internal.qvt.oml.ui.wizards.project.NewProjectData;
import org.eclipse.pde.core.plugin.IPluginReference;
import org.eclipse.pde.ui.templates.PluginReference;

class PluginClassCodeGenerator {
    private final IProject fProject;
    private final String fQualifiedClassName;
    private final String fSourceFolderName;
    private final boolean fIsUIPlugin;
    private final String fOSGiFramework;
    private final String fPluginID;
    private boolean fIsPlugin;

    public PluginClassCodeGenerator(IProject project, NewProjectData projectData) {
        this.fProject = project;
        this.fQualifiedClassName = projectData.getClassName();
        this.fSourceFolderName = projectData.getSourceFolderName();
        this.fIsUIPlugin = false;
        this.fOSGiFramework = null;
        this.fPluginID = projectData.getID();
        this.fIsPlugin = projectData.isPlugin();
    }

    public IFile generate(IProgressMonitor monitor) throws CoreException {
        IFile file;
        int nameloc = this.fQualifiedClassName.lastIndexOf(46);
        String packageName = nameloc == -1 ? "" : this.fQualifiedClassName.substring(0, nameloc);
        String className = this.fQualifiedClassName.substring(nameloc + 1);
        Path path = new Path(packageName.replace('.', '/'));
        if (this.fSourceFolderName != null && this.fSourceFolderName.trim().length() > 0) {
            path = new Path(this.fSourceFolderName).append((IPath)path);
        }
        if (!(file = this.fProject.getFile(path.append(String.valueOf(className) + ".java"))).getParent().exists()) {
            PluginClassCodeGenerator.createFolder(this.fProject.getFolder((IPath)path));
        }
        StringWriter swriter = new StringWriter();
        PrintWriter writer = new PrintWriter(swriter);
        if (this.fOSGiFramework != null) {
            this.generateActivatorClass(packageName, className, writer);
        } else {
            this.generatePluginClass(packageName, className, writer);
        }
        writer.flush();
        try {
            swriter.close();
            ByteArrayInputStream stream = new ByteArrayInputStream(swriter.toString().getBytes(this.fProject.getDefaultCharset()));
            if (file.exists()) {
                file.setContents((InputStream)stream, false, true, monitor);
            } else {
                file.create((InputStream)stream, false, monitor);
            }
            stream.close();
        }
        catch (IOException e) {
            QVTUIPlugin.log(e);
        }
        return file;
    }

    private void generatePluginClass(String packageName, String className, PrintWriter writer) {
        if (!packageName.equals("")) {
            writer.println("package " + packageName + ";");
            writer.println();
        }
        if (this.fIsUIPlugin) {
            writer.println("import org.eclipse.jface.resource.ImageDescriptor;");
            writer.println("import org.eclipse.ui.plugin.AbstractUIPlugin;");
        } else {
            writer.println("import org.eclipse.core.runtime.Plugin;");
        }
        writer.println("import org.osgi.framework.BundleContext;");
        writer.println();
        writer.println("/**");
        writer.println(" * The activator class controls the plug-in life cycle");
        writer.println(" */");
        if (this.fIsUIPlugin) {
            writer.println("public class " + className + " extends AbstractUIPlugin {");
        } else {
            writer.println("public class " + className + " extends Plugin {");
        }
        writer.println();
        writer.println("\t// The plug-in ID");
        writer.println("\tpublic static final String PLUGIN_ID = \"" + this.fPluginID + "\";");
        writer.println();
        writer.println("\t// The shared instance");
        writer.println("\tprivate static " + className + " plugin;");
        writer.println("\t");
        writer.println("\t/**");
        writer.println("\t * The constructor");
        writer.println("\t */");
        writer.println("\tpublic " + className + "() {");
        writer.println("\t}");
        writer.println();
        writer.println("\t/*");
        writer.println("\t * (non-Javadoc)");
        if (this.fIsUIPlugin) {
            writer.println("\t * @see org.eclipse.ui.plugin.AbstractUIPlugin#start(org.osgi.framework.BundleContext)");
        } else {
            writer.println("\t * @see org.eclipse.core.runtime.Plugins#start(org.osgi.framework.BundleContext)");
        }
        writer.println("\t */");
        writer.println("\tpublic void start(BundleContext context) throws Exception {");
        writer.println("\t\tsuper.start(context);");
        writer.println("\t\tplugin = this;");
        writer.println("\t}");
        writer.println();
        writer.println("\t/*");
        writer.println("\t * (non-Javadoc)");
        if (this.fIsUIPlugin) {
            writer.println("\t * @see org.eclipse.ui.plugin.AbstractUIPlugin#stop(org.osgi.framework.BundleContext)");
        } else {
            writer.println("\t * @see org.eclipse.core.runtime.Plugin#stop(org.osgi.framework.BundleContext)");
        }
        writer.println("\t */");
        writer.println("\tpublic void stop(BundleContext context) throws Exception {");
        writer.println("\t\tplugin = null;");
        writer.println("\t\tsuper.stop(context);");
        writer.println("\t}");
        writer.println();
        writer.println("\t/**");
        writer.println("\t * Returns the shared instance");
        writer.println("\t *");
        writer.println("\t * @return the shared instance");
        writer.println("\t */");
        writer.println("\tpublic static " + className + " getDefault() {");
        writer.println("\t\treturn plugin;");
        writer.println("\t}");
        writer.println();
        if (this.fIsUIPlugin) {
            writer.println("\t/**");
            writer.println("\t * Returns an image descriptor for the image file at the given");
            writer.println("\t * plug-in relative path");
            writer.println("\t *");
            writer.println("\t * @param path the path");
            writer.println("\t * @return the image descriptor");
            writer.println("\t */");
            writer.println("\tpublic static ImageDescriptor getImageDescriptor(String path) {");
            writer.println("\t\treturn imageDescriptorFromPlugin(PLUGIN_ID, path);");
            writer.println("\t}");
        }
        writer.println("}");
    }

    private void generateActivatorClass(String packageName, String className, PrintWriter writer) {
        if (!packageName.equals("")) {
            writer.println("package " + packageName + ";");
            writer.println();
        }
        writer.println("import org.osgi.framework.BundleActivator;");
        writer.println("import org.osgi.framework.BundleContext;");
        writer.println();
        writer.println("public class " + className + " implements BundleActivator {");
        writer.println();
        writer.println("\t/*");
        writer.println("\t * (non-Javadoc)");
        writer.println("\t * @see org.osgi.framework.BundleActivator#start(org.osgi.framework.BundleContext)");
        writer.println("\t */");
        writer.println("\tpublic void start(BundleContext context) throws Exception {");
        writer.println("\t}");
        writer.println();
        writer.println("\t/*");
        writer.println("\t * (non-Javadoc)");
        writer.println("\t * @see org.osgi.framework.BundleActivator#stop(org.osgi.framework.BundleContext)");
        writer.println("\t */");
        writer.println("\tpublic void stop(BundleContext context) throws Exception {");
        writer.println("\t}");
        writer.println();
        writer.println("}");
    }

    public IPluginReference[] getDependencies() {
        ArrayList<PluginReference> result = new ArrayList<PluginReference>();
        if (this.fIsUIPlugin) {
            result.add(new PluginReference("org.eclipse.ui", null, 0));
        }
        if (this.fOSGiFramework == null) {
            result.add(new PluginReference("org.eclipse.core.runtime", null, 0));
        }
        if (this.fIsPlugin) {
            result.add(new PluginReference("org.eclipse.m2m.qvt.oml", null, 0));
            result.add(new PluginReference("org.eclipse.m2m.qvt.oml.project", null, 0));
        }
        return result.toArray(new IPluginReference[result.size()]);
    }

    public String[] getImportPackages() {
        String[] stringArray;
        if (this.fOSGiFramework != null) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "org.osgi.framework;version=\"1.3.0\"";
        } else {
            stringArray = new String[]{};
        }
        return stringArray;
    }

    private static void createFolder(IFolder folder) throws CoreException {
        if (!folder.exists()) {
            IContainer parent = folder.getParent();
            if (parent instanceof IFolder) {
                PluginClassCodeGenerator.createFolder((IFolder)parent);
            }
            folder.create(true, true, null);
        }
    }
}

