/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.preferences.fields;

import org.eclipse.core.runtime.Assert;
import org.eclipse.imp.preferences.IPreferencesService;
import org.eclipse.imp.preferences.PreferencesTab;
import org.eclipse.imp.preferences.fields.ChangeButtonFieldEditor;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FontDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

public class FontFieldEditor
extends ChangeButtonFieldEditor {
    private static final String DEFAULT_FONT_DESCRIPTOR = new FontData("courier", 12, 0).toString();
    private Button changeFontButton = null;
    private String changeButtonText;
    private String previewText;
    private FontData[] chosenFont;
    private Label valueControl;
    private DefaultPreviewer previewer;

    protected FontFieldEditor() {
    }

    public FontFieldEditor(String name, String labelText, String previewAreaText, Composite parent) {
        this.init(name, labelText);
        this.previewText = previewAreaText;
        this.changeButtonText = JFaceResources.getString((String)"openChange");
        this.createControl(parent);
    }

    public FontFieldEditor(String name, String labelText, Composite parent) {
        this(name, labelText, null, parent);
    }

    protected void adjustForNumColumns(int numColumns) {
        GridData data = new GridData();
        if (this.valueControl.getLayoutData() != null) {
            data = (GridData)this.valueControl.getLayoutData();
        }
        data.horizontalSpan = numColumns - this.getNumberOfControls() + 1;
        this.valueControl.setLayoutData((Object)data);
    }

    protected void applyFont() {
        if (this.chosenFont != null && this.previewer != null) {
            this.previewer.setFont(this.chosenFont);
        }
    }

    protected void doFillIntoGrid(Composite parent, int numColumns) {
        this.getLabelControl(parent);
        this.valueControl = this.getValueControl(parent);
        GridData gd = new GridData(768);
        gd.horizontalSpan = numColumns - this.getNumberOfControls() + 1;
        this.valueControl.setLayoutData((Object)gd);
        if (this.previewText != null) {
            this.previewer = new DefaultPreviewer(this.previewText, parent);
            gd = new GridData(768);
            gd.heightHint = this.previewer.getPreferredExtent();
            gd.widthHint = this.previewer.getPreferredExtent();
            this.previewer.getControl().setLayoutData((Object)gd);
        }
        this.changeFontButton = this.getChangeControl();
        gd = new GridData();
        int widthHint = this.convertHorizontalDLUsToPixels((Control)this.changeFontButton, 61);
        gd.widthHint = Math.max(widthHint, this.changeFontButton.computeSize((int)-1, (int)-1, (boolean)true).x);
        this.changeFontButton.setLayoutData((Object)gd);
    }

    protected void doSetToolTip() {
        if (this.toolTipText != null) {
            this.getValueControl(this.parent).setToolTipText(this.toolTipText);
        }
    }

    protected void doLoad() {
        if (this.changeFontButton == null) {
            return;
        }
        this.updateFont(PreferenceConverter.basicGetFontData((String)this.preferencesService.getStringPreference(this.getPreferenceName())));
    }

    protected void doLoadDefault() {
        if (this.changeFontButton == null) {
            return;
        }
        String fontPref = this.preferencesService.getStringPreference("default", this.getPreferenceName());
        this.updateFont(PreferenceConverter.basicGetFontData((String)fontPref));
    }

    protected void doStore() {
        if (this.chosenFont != null) {
            this.fieldModified = false;
            this.levelFromWhichLoaded = this.preferencesLevel;
            this.setInherited(false);
            String encodedFont = PreferenceConverter.getStoredRepresentation((FontData[])this.chosenFont);
            this.preferencesService.setStringPreference("instance", this.getPreferenceName(), encodedFont);
        }
    }

    public Composite getHolder() {
        return this.getChangeControl().getParent();
    }

    public Button getChangeControl() {
        if (this.changeFontButton == null) {
            this.changeFontButton = new Button(this.parent, 8);
            if (this.changeButtonText != null) {
                this.changeFontButton.setText(this.changeButtonText);
            }
            this.changeFontButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    FontData font;
                    FontDialog fontDialog = new FontDialog(FontFieldEditor.this.changeFontButton.getShell());
                    if (FontFieldEditor.this.chosenFont != null) {
                        fontDialog.setFontList(FontFieldEditor.this.chosenFont);
                    }
                    if ((font = fontDialog.open()) != null) {
                        FontData[] oldFont = FontFieldEditor.this.chosenFont;
                        if (oldFont == null) {
                            oldFont = JFaceResources.getDefaultFont().getFontData();
                        }
                        FontFieldEditor.this.setPresentsDefaultValue(false);
                        FontData[] newData = new FontData[]{font};
                        FontFieldEditor.this.updateFont(newData);
                        FontFieldEditor.this.fireValueChanged("field_editor_value", oldFont[0], font);
                    }
                }
            });
            this.changeFontButton.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent event) {
                    FontFieldEditor.this.changeFontButton = null;
                }
            });
            this.changeFontButton.setFont(this.parent.getFont());
            this.setButtonLayoutData(this.changeFontButton);
        } else {
            this.checkParent((Control)this.changeFontButton, this.parent);
        }
        return this.changeFontButton;
    }

    public int getNumberOfControls() {
        if (this.previewer == null) {
            return 3;
        }
        return 4;
    }

    public int getPreferredPreviewHeight() {
        if (this.previewer == null) {
            return -1;
        }
        return this.previewer.getPreferredExtent();
    }

    public Control getPreviewControl() {
        if (this.previewer == null) {
            return null;
        }
        return this.previewer.getControl();
    }

    protected Label getValueControl(Composite parent) {
        if (this.valueControl == null) {
            this.valueControl = new Label(parent, 16384);
            this.valueControl.setFont(parent.getFont());
            this.valueControl.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent event) {
                    FontFieldEditor.this.valueControl = null;
                }
            });
        } else {
            this.checkParent((Control)this.valueControl, parent);
        }
        return this.valueControl;
    }

    public void setChangeButtonText(String text) {
        Assert.isNotNull((Object)text);
        this.changeButtonText = text;
        if (this.changeFontButton != null) {
            this.changeFontButton.setText(text);
        }
    }

    private void updateFont(FontData[] font) {
        FontData[] bestFont = JFaceResources.getFontRegistry().filterData(font, this.valueControl.getDisplay());
        if (bestFont == null) {
            bestFont = this.getDefaultFontData();
        }
        this.chosenFont = bestFont;
        if (this.valueControl != null) {
            this.valueControl.setText(StringConverter.asString((FontData)this.chosenFont[0]));
        }
        if (this.previewer != null) {
            this.previewer.setFont(bestFont);
        }
        this.setInherited(false);
        this.valueChanged();
    }

    protected void setToDefault() {
        String defaultFontStr = PreferenceConverter.getStoredRepresentation((FontData[])this.getDefaultFontData());
        this.preferencesService.setStringPreference("default", this.getPreferenceName(), defaultFontStr);
    }

    private FontData[] getDefaultFontData() {
        return this.valueControl.getDisplay().getSystemFont().getFontData();
    }

    public FontData[] getSelectedFont() {
        return this.chosenFont;
    }

    public void setEnabled(boolean enabled, Composite parent) {
        super.setEnabled(enabled, parent);
        this.getChangeControl().setEnabled(enabled);
        this.getValueControl(parent).setEnabled(enabled);
    }

    public FontFieldEditor(PreferencePage page, PreferencesTab tab, IPreferencesService service, String level, String name, String labelText, Composite parent) {
        this.init(name, labelText);
        this.previewText = "splat splat";
        this.changeButtonText = JFaceResources.getString((String)"openChange");
        this.preferencesService = service;
        this.preferencesLevel = level;
        this.parent = parent;
        this.prefPage = page;
        this.setPage((DialogPage)this.prefPage);
        this.prefTab = tab;
        this.createControl(parent);
    }

    protected void doLoadLevel(String level) {
        if (this.valueControl != null) {
            String value = this.preferencesService.getStringPreference(level, this.getPreferenceName());
            this.updateFont(PreferenceConverter.basicGetFontData((String)value));
        }
    }

    protected String doLoadWithInheritance() {
        String levelLoaded = null;
        String[] levels = IPreferencesService.levels;
        int startingLevelIdx = this.preferencesLevel == null ? 0 : PREFS_LEVELS_AS_LIST.indexOf(this.preferencesLevel);
        int levelAtWhichFound = -1;
        String encodedFontValue = null;
        int level = startingLevelIdx;
        while (level < levels.length) {
            encodedFontValue = this.preferencesService.getRawStringPreference(levels[level], this.getPreferenceName());
            if (encodedFontValue != null) {
                levelAtWhichFound = level;
                levelLoaded = levels[levelAtWhichFound];
                break;
            }
            ++level;
        }
        if (encodedFontValue == null) {
            encodedFontValue = DEFAULT_FONT_DESCRIPTOR;
        }
        this.levelFromWhichLoaded = levelLoaded;
        this.setInherited(startingLevelIdx != levelAtWhichFound);
        this.setPresentsDefaultValue("default".equals(this.levelFromWhichLoaded));
        this.fieldModified = true;
        this.previousValue = this.chosenFont;
        this.chosenFont = PreferenceConverter.basicGetFontData((String)encodedFontValue);
        if (this.valueControl != null) {
            this.valueControl.setText(StringConverter.asString((FontData)this.chosenFont[0]));
        }
        if (this.previewer != null) {
            this.previewer.setFont(this.chosenFont);
        }
        return levelLoaded;
    }

    protected boolean valueChanged() {
        return this.valueChanged(false);
    }

    protected boolean valueChanged(boolean assertChanged) {
        boolean valueChanged;
        boolean bl = valueChanged = assertChanged || this.inheritanceChanged();
        if (!valueChanged) {
            if (this.chosenFont != null && this.previousValue == null || this.chosenFont == null && this.previousValue != null) {
                valueChanged = true;
            }
            if (this.chosenFont != null && this.previousValue != null && !this.chosenFont.equals(this.previousValue)) {
                valueChanged = true;
            }
        }
        if (valueChanged) {
            this.fireValueChanged("field_editor_value", this.previousValue, this.chosenFont);
            this.fieldModified = true;
            this.previousValue = this.chosenFont;
            this.setModifiedMarkOnLabel();
        }
        return valueChanged;
    }

    public void setFieldValueFromOutside(FontData[] newValue) {
        this.previousValue = this.chosenFont;
        this.setInherited(false);
        this.setPresentsDefaultValue(false);
        this.levelFromWhichLoaded = null;
        this.updateFont(newValue);
    }

    private static class DefaultPreviewer {
        private Text text;
        private String string;
        private Font font;

        public DefaultPreviewer(String s, Composite parent) {
            this.string = s;
            this.text = new Text(parent, 2056);
            this.text.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    if (DefaultPreviewer.this.font != null) {
                        DefaultPreviewer.this.font.dispose();
                    }
                }
            });
            if (this.string != null) {
                this.text.setText(this.string);
            }
        }

        public Control getControl() {
            return this.text;
        }

        public void setFont(FontData[] fontData) {
            if (this.font != null) {
                this.font.dispose();
            }
            this.font = new Font((Device)this.text.getDisplay(), fontData);
            this.text.setFont(this.font);
        }

        public int getPreferredExtent() {
            return 40;
        }
    }
}

