/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.NameUtil;
import org.eclipse.ocl.pivot.utilities.TracingOption;
import org.eclipse.qvtd.compiler.CompilerChainException;
import org.eclipse.qvtd.compiler.CompilerConstants;
import org.eclipse.qvtd.compiler.CompilerProblem;
import org.eclipse.qvtd.compiler.ProblemHandler;
import org.eclipse.qvtd.compiler.internal.qvtb2qvts.RegionsAnalysis;
import org.eclipse.qvtd.compiler.internal.qvtb2qvts.TransformationAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.RegionAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.CyclicPartitionsAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.MappingPartitioner;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.NonPartition;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.Partition;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.RootPartition;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.TraceClassAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.TraceClassPartitionAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.TracePropertyPartitionAnalysis;
import org.eclipse.qvtd.pivot.qvtbase.Transformation;
import org.eclipse.qvtd.pivot.qvtschedule.ClassDatum;
import org.eclipse.qvtd.pivot.qvtschedule.MappingRegion;
import org.eclipse.qvtd.pivot.qvtschedule.PropertyDatum;
import org.eclipse.qvtd.pivot.qvtschedule.Region;

public class TransformationPartitioner
extends RegionsAnalysis<Partition> {
    public static final @NonNull TracingOption CYCLES = new TracingOption(CompilerConstants.PLUGIN_ID, "qvts2qvts/partition/cycles");
    public static final @NonNull TracingOption DISCRIMINATION = new TracingOption(CompilerConstants.PLUGIN_ID, "qvts2qvts/partition/discrimination");
    public static final @NonNull TracingOption PREDECESSORS = new TracingOption(CompilerConstants.PLUGIN_ID, "qvts2qvts/partition/predecessors");
    public static final @NonNull TracingOption SUCCESSORS = new TracingOption(CompilerConstants.PLUGIN_ID, "qvts2qvts/partition/successors");
    protected final @NonNull TransformationAnalysis transformationAnalysis;
    protected final @NonNull ProblemHandler problemHandler;
    protected final @NonNull Iterable<@NonNull ? extends Region> activeRegions;
    private final @NonNull List<@NonNull Partition> partitions = new ArrayList<Partition>();
    private final @NonNull Map<@NonNull MappingRegion, @NonNull MappingPartitioner> region2mappingPartitioner = new HashMap<MappingRegion, MappingPartitioner>();
    private final @NonNull List<@NonNull MappingPartitioner> mappingPartitioners = new ArrayList<MappingPartitioner>();
    private @Nullable CyclicPartitionsAnalysis cyclicPartitionsAnalysis = null;

    public static @NonNull RootPartition partition(@NonNull TransformationAnalysis transformationAnalysis, @NonNull ProblemHandler problemHandler, @NonNull Iterable<@NonNull ? extends Region> activeRegions) throws CompilerChainException {
        TransformationPartitioner transformationPartitioner = new TransformationPartitioner(transformationAnalysis, problemHandler, activeRegions);
        return transformationPartitioner.partition();
    }

    public TransformationPartitioner(@NonNull TransformationAnalysis transformationAnalysis, @NonNull ProblemHandler problemHandler, @NonNull Iterable<@NonNull ? extends Region> activeRegions) {
        super(transformationAnalysis.getScheduleManager());
        this.transformationAnalysis = transformationAnalysis;
        this.problemHandler = problemHandler;
        this.activeRegions = activeRegions;
    }

    public void addProblem(@NonNull CompilerProblem problem) {
        this.problemHandler.addProblem(problem);
    }

    protected @NonNull TraceClassPartitionAnalysis createTraceClassAnalysis(@NonNull ClassDatum traceClassDatum) {
        return new TraceClassPartitionAnalysis(this.getScheduleManager(), traceClassDatum);
    }

    protected @NonNull TracePropertyPartitionAnalysis createTracePropertyAnalysis(@NonNull TraceClassAnalysis<@NonNull Partition> traceClassAnalysis, @NonNull PropertyDatum tracePropertyDatum) {
        return new TracePropertyPartitionAnalysis(this, traceClassAnalysis, tracePropertyDatum);
    }

    public @NonNull MappingPartitioner getMappingPartitioner(@NonNull MappingRegion region) {
        return (MappingPartitioner)ClassUtil.nonNullState((Object)this.region2mappingPartitioner.get(region));
    }

    public String getName() {
        return this.transformationAnalysis.getName();
    }

    public @NonNull PropertyDatum getSuccessPropertyDatum(@NonNull Property successProperty) {
        return this.scheduleManager.getSuccessPropertyDatum(successProperty);
    }

    public @NonNull Transformation getTransformation() {
        return this.transformationAnalysis.getTransformation();
    }

    public @NonNull TransformationAnalysis getTransformationAnalysis() {
        return this.transformationAnalysis;
    }

    public @NonNull RootPartition partition() throws CompilerChainException {
        MappingRegion mappingRegion;
        for (Region region : this.activeRegions) {
            if (!(region instanceof MappingRegion)) continue;
            mappingRegion = (MappingRegion)region;
            this.transformationAnalysis.getRegionAnalysis((Region)mappingRegion);
        }
        for (Region region : this.activeRegions) {
            if (!(region instanceof MappingRegion)) continue;
            mappingRegion = (MappingRegion)region;
            RegionAnalysis regionAnalysis = this.transformationAnalysis.getRegionAnalysis((Region)mappingRegion);
            MappingPartitioner mappingPartitioner = new MappingPartitioner(this, regionAnalysis);
            this.region2mappingPartitioner.put(mappingRegion, mappingPartitioner);
            this.mappingPartitioners.add(mappingPartitioner);
        }
        Collections.sort(this.mappingPartitioners, NameUtil.NAMEABLE_COMPARATOR);
        this.transformationAnalysis.prePartition();
        for (MappingPartitioner mappingPartitioner : this.mappingPartitioners) {
            if (Iterables.isEmpty(mappingPartitioner.getTraceNodes())) {
                this.partitions.add(new NonPartition(mappingPartitioner));
                continue;
            }
            Iterables.addAll(this.partitions, mappingPartitioner.partition());
        }
        Collections.sort(this.partitions, NameUtil.NAMEABLE_COMPARATOR);
        return this.postPartition();
    }

    public @NonNull RootPartition postPartition() throws CompilerChainException {
        for (Partition partition : this.partitions) {
            partition.analyzePartition();
        }
        this.computeTraceClassInheritance();
        this.cyclicPartitionsAnalysis = new CyclicPartitionsAnalysis(this, this.partitions);
        return this.cyclicPartitionsAnalysis.analyze();
    }
}

