/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner;

import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.AbstractPartialPartition;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.MappingPartitioner;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.utilities.ReachabilityForest;
import org.eclipse.qvtd.pivot.qvtschedule.Edge;
import org.eclipse.qvtd.pivot.qvtschedule.MappingRegion;
import org.eclipse.qvtd.pivot.qvtschedule.NavigableEdge;
import org.eclipse.qvtd.pivot.qvtschedule.Node;
import org.eclipse.qvtd.pivot.qvtschedule.Region;
import org.eclipse.qvtd.pivot.qvtschedule.Role;
import org.eclipse.qvtd.pivot.qvtschedule.utilities.QVTscheduleUtil;

class SpeculationPartition
extends AbstractPartialPartition {
    private final @NonNull Set<@NonNull Node> originalHeadNodes;
    private final @NonNull Iterable<@NonNull Node> executionNodes;
    private final @Nullable Node dispatchNode;

    public SpeculationPartition(@NonNull MappingPartitioner partitioner, @NonNull ReachabilityForest reachabilityForest) {
        super(partitioner, reachabilityForest, "\u00abspeculation\u00bb");
        this.originalHeadNodes = Sets.newHashSet((Iterable)QVTscheduleUtil.getHeadNodes((Region)this.region));
        this.executionNodes = partitioner.getExecutionNodes();
        this.dispatchNode = partitioner.basicGetDispatchNode();
        if (!this.hasSynthesizedTrace) {
            for (Node traceNode : partitioner.getTraceNodes()) {
                this.addNode(traceNode, Role.SPECULATION);
            }
        }
        for (Node traceNode : this.executionNodes) {
            this.addNode(traceNode, Role.PREDICATED);
        }
        Node dispatchNode2 = this.dispatchNode;
        if (dispatchNode2 != null) {
            assert (dispatchNode2.isPredicated());
            this.addNode(dispatchNode2);
        }
        HashSet<@NonNull Node> checkableOldNodes = new HashSet<Node>();
        for (Node node : this.originalHeadNodes) {
            this.gatherReachableOldAcyclicNodes(checkableOldNodes, node);
        }
        if (this.dispatchNode != null) {
            for (Edge edge : QVTscheduleUtil.getIncomingEdges((Node)this.dispatchNode)) {
                if (!edge.isCast() && !edge.isNavigation() || !edge.isOld()) continue;
                Node sourceNode = QVTscheduleUtil.getSourceNode((Edge)edge);
                this.gatherReachableOldAcyclicNodes(checkableOldNodes, sourceNode);
            }
        }
        for (Node node : checkableOldNodes) {
            if (this.hasSynthesizedTrace) {
                boolean isCyclicCorollary = this.transformationAnalysis.isCorollary(node) && partitioner.isCyclic(node);
                Node.Utility utility = node.getUtility();
                boolean isWeaklyMatched = utility == Node.Utility.WEAKLY_MATCHED;
                boolean isTraced = this.isTraced(node, this.executionNodes);
                if (isCyclicCorollary || !isTraced && !isWeaklyMatched) continue;
                this.addNode(node);
                continue;
            }
            this.addNode(node);
        }
        if (this.hasSynthesizedTrace) {
            this.resolveSuccessNodes();
        }
        this.resolvePrecedingNodes();
        this.resolveDisambiguations();
        this.resolveEdges();
    }

    @Override
    public @NonNull MappingRegion createMicroMappingRegion(int partitionNumber) {
        return this.createMicroMappingRegion("\u00abspeculation\u00bb", "_p" + partitionNumber);
    }

    protected void gatherReachableOldAcyclicNodes(@NonNull Set<@NonNull Node> checkableOldNodes, @NonNull Node node) {
        if (!this.hasNode(node) && !checkableOldNodes.contains(node) && (node.isHead() || node.isOld() && !this.partitioner.isCyclic(node))) {
            checkableOldNodes.add(node);
            for (NavigableEdge edge : node.getNavigableEdges()) {
                if (!edge.isOld()) continue;
                Node targetNode = QVTscheduleUtil.getTargetNode((Edge)edge);
                this.gatherReachableOldAcyclicNodes(checkableOldNodes, targetNode);
            }
        }
    }

    @Override
    protected @Nullable Iterable<@NonNull Node> getPreferredHeadNodes() {
        return this.executionNodes;
    }

    @Override
    protected boolean isAvailable(@NonNull Edge edge) {
        return edge.isConstant() || edge.isLoaded();
    }

    @Override
    protected boolean isAvailable(@NonNull Node node) {
        return node.isConstant() || node.isLoaded();
    }

    protected boolean isTraced(@NonNull Node node, @NonNull Iterable<@NonNull Node> executionNodes) {
        for (Edge edge : QVTscheduleUtil.getIncomingEdges((Node)node)) {
            Node sourceNode;
            if (!edge.isCast() && !edge.isNavigation() || !Iterables.contains(executionNodes, (Object)(sourceNode = QVTscheduleUtil.getSourceNode((Edge)edge)))) continue;
            return true;
        }
        return false;
    }

    @Override
    protected @Nullable Role resolveEdgeRole(@NonNull Role sourceNodeRole, @NonNull Edge edge, @NonNull Role targetNodeRole) {
        Role edgeRole = QVTscheduleUtil.getEdgeRole((Edge)edge);
        if (edgeRole == Role.REALIZED) {
            if (this.partitioner.hasRealizedEdge(edge)) {
                edgeRole = Role.PREDICATED;
            } else if (this.dispatchNode == edge.getSourceNode()) {
                edgeRole = null;
            }
        }
        return edgeRole;
    }

    protected void resolveSuccessNodes() {
        for (Node traceNode : this.executionNodes) {
            Node localSuccessNode = this.partitioner.getLocalSuccessNode(traceNode);
            this.addNode(localSuccessNode, Role.REALIZED);
        }
    }
}

