/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvts2qvts;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.CompleteClass;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.qvtd.compiler.internal.qvtb2qvts.TransformationAnalysis;
import org.eclipse.qvtd.compiler.internal.qvtb2qvts.trace.Element2MiddleProperty;
import org.eclipse.qvtd.compiler.internal.qvtr2qvts.RelationAnalysis;
import org.eclipse.qvtd.compiler.internal.qvtr2qvts.trace.RelationAnalysis2TraceClass;
import org.eclipse.qvtd.compiler.internal.qvtr2qvts.trace.RelationAnalysis2TraceGroup;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.AbstractPartialRegionAnalysis;
import org.eclipse.qvtd.pivot.qvtbase.Rule;
import org.eclipse.qvtd.pivot.qvtbase.TypedModel;
import org.eclipse.qvtd.pivot.qvtschedule.ClassDatum;
import org.eclipse.qvtd.pivot.qvtschedule.ConnectionEnd;
import org.eclipse.qvtd.pivot.qvtschedule.DatumConnection;
import org.eclipse.qvtd.pivot.qvtschedule.Edge;
import org.eclipse.qvtd.pivot.qvtschedule.EdgeConnection;
import org.eclipse.qvtd.pivot.qvtschedule.NavigableEdge;
import org.eclipse.qvtd.pivot.qvtschedule.NavigationEdge;
import org.eclipse.qvtd.pivot.qvtschedule.Node;
import org.eclipse.qvtd.pivot.qvtschedule.NodeConnection;
import org.eclipse.qvtd.pivot.qvtschedule.Region;
import org.eclipse.qvtd.pivot.qvtschedule.RuleRegion;
import org.eclipse.qvtd.pivot.qvtschedule.SuccessEdge;
import org.eclipse.qvtd.pivot.qvtschedule.utilities.QVTscheduleConstants;
import org.eclipse.qvtd.pivot.qvtschedule.utilities.QVTscheduleUtil;

public class RegionAnalysis
extends AbstractPartialRegionAnalysis<RegionAnalysis> {
    protected final @NonNull TransformationAnalysis transformationAnalysis;
    private @Nullable Map<@NonNull TypedModel, @NonNull Set<@NonNull NavigableEdge>> typedModel2checkedEdges = null;
    private @Nullable Map<@NonNull TypedModel, @NonNull Map<@NonNull Property, @NonNull Set<@NonNull NavigableEdge>>> typedModel2property2enforcedEdges = null;
    private final @NonNull List<@NonNull NavigableEdge> corollaryEdges = new ArrayList<NavigableEdge>();
    private final @NonNull List<@NonNull Node> corollaryNodes = new ArrayList<Node>();

    public RegionAnalysis(@NonNull TransformationAnalysis transformationAnalysis, @NonNull Region region) {
        super(transformationAnalysis, region);
        this.transformationAnalysis = transformationAnalysis;
        if (!region.isLoadingRegion()) {
            List<@NonNull Node> alreadyRealized = this.analyze();
            this.analyzeCorollaries(alreadyRealized);
        }
    }

    private void addCheckedEdge(@NonNull NavigableEdge predicatedEdge) {
        assert (predicatedEdge.isPredicated());
        assert (predicatedEdge.getOwningRegion() == this.region);
        Map<@NonNull TypedModel, @NonNull Set<@NonNull NavigableEdge>> typedModel2checkedEdges2 = this.typedModel2checkedEdges;
        assert (typedModel2checkedEdges2 != null);
        ClassDatum classDatum = QVTscheduleUtil.getClassDatum((Node)predicatedEdge.getEdgeSource());
        TypedModel typedModel = QVTscheduleUtil.getReferredTypedModel((ClassDatum)classDatum);
        Set<@NonNull NavigableEdge> checkedEdges = typedModel2checkedEdges2.get(typedModel);
        if (checkedEdges == null) {
            checkedEdges = new HashSet<NavigableEdge>();
            typedModel2checkedEdges2.put(typedModel, checkedEdges);
        }
        checkedEdges.add(predicatedEdge);
        QVTscheduleConstants.POLLED_PROPERTIES.println("    checked " + predicatedEdge.getProperty() + " at " + this.region.getIndexRangeText() + " in " + typedModel + " for " + this.region);
    }

    private void addEnforcedEdge(@NonNull NavigableEdge realizedEdge) {
        Property asProperty;
        Set<NavigableEdge> enforcedEdges;
        assert (realizedEdge.isRealized());
        assert (realizedEdge.getOwningRegion() == this.region);
        Map<@NonNull TypedModel, @NonNull Map<@NonNull Property, @NonNull Set<@NonNull NavigableEdge>>> typedModel2property2enforcedEdges2 = this.typedModel2property2enforcedEdges;
        assert (typedModel2property2enforcedEdges2 != null);
        ClassDatum classDatum = QVTscheduleUtil.getClassDatum((Node)realizedEdge.getEdgeSource());
        TypedModel typedModel = QVTscheduleUtil.getReferredTypedModel((ClassDatum)classDatum);
        Map<@NonNull Property, @NonNull Set<@NonNull NavigableEdge>> property2enforcedEdges2 = typedModel2property2enforcedEdges2.get(typedModel);
        if (property2enforcedEdges2 == null) {
            property2enforcedEdges2 = new HashMap<Property, Set<NavigableEdge>>();
            typedModel2property2enforcedEdges2.put(typedModel, property2enforcedEdges2);
        }
        if ((enforcedEdges = property2enforcedEdges2.get(asProperty = QVTscheduleUtil.getProperty((NavigableEdge)realizedEdge))) == null) {
            enforcedEdges = new HashSet<NavigableEdge>();
            property2enforcedEdges2.put(asProperty, enforcedEdges);
            Property asOpposite = asProperty.getOpposite();
            if (asOpposite != null) {
                property2enforcedEdges2.put(asOpposite, enforcedEdges);
            }
        }
        enforcedEdges.add(realizedEdge);
        QVTscheduleConstants.POLLED_PROPERTIES.println("    enforced " + asProperty + " at " + this.region.getIndexRangeText() + " in " + typedModel + " for " + this.region);
    }

    private void analyzeCorollaries(@NonNull List<@NonNull Node> alreadyRealizedNodes) {
        int i = 0;
        while (i < alreadyRealizedNodes.size()) {
            Node alreadyRealizedNode = alreadyRealizedNodes.get(i);
            for (NavigationEdge edge : alreadyRealizedNode.getRealizedNavigationEdges()) {
                Node targetNode = QVTscheduleUtil.getTargetNode((Edge)edge);
                if (!targetNode.isRealized() || targetNode.isSuccess()) continue;
                assert (!this.corollaryEdges.contains(edge));
                this.corollaryEdges.add((NavigableEdge)edge);
                if (!alreadyRealizedNodes.contains(targetNode)) {
                    alreadyRealizedNodes.add(targetNode);
                    assert (!this.corollaryNodes.contains(targetNode));
                    if (!this.corollaryNodes.contains(targetNode)) {
                        this.corollaryNodes.add(targetNode);
                    }
                }
                this.transformationAnalysis.addCorollary((NavigableEdge)edge);
            }
            ++i;
        }
    }

    public void buildNavigationEdgesIndex(@NonNull Map<@NonNull TypedModel, @NonNull Map<@NonNull Property, @NonNull List<@NonNull NavigableEdge>>> typedModel2property2predicatedEdges, @NonNull Map<@NonNull TypedModel, @NonNull Map<@NonNull Property, @NonNull List<@NonNull NavigableEdge>>> typedModel2property2realizedEdges) {
        this.buildPredicatedNavigationEdgesIndex2(typedModel2property2predicatedEdges);
        this.buildRealizedNavigationEdgesIndex2(typedModel2property2realizedEdges);
        this.typedModel2checkedEdges = new HashMap<TypedModel, Set<NavigableEdge>>();
        this.typedModel2property2enforcedEdges = new HashMap<TypedModel, Map<Property, Set<NavigableEdge>>>();
    }

    private void buildPredicatedNavigationEdgesIndex2(@NonNull Map<@NonNull TypedModel, @NonNull Map<@NonNull Property, @NonNull List<@NonNull NavigableEdge>>> typedModel2property2predicatedEdges) {
        for (NavigationEdge predicatedEdge : this.region.getPredicatedNavigationEdges()) {
            List<NavigableEdge> predicatedEdges;
            assert (!predicatedEdge.isCast());
            Property property = QVTscheduleUtil.getProperty((NavigableEdge)predicatedEdge);
            Node predicatedNode = predicatedEdge.getEdgeSource();
            ClassDatum classDatum = QVTscheduleUtil.getClassDatum((Node)predicatedNode);
            TypedModel typedModel = QVTscheduleUtil.getReferredTypedModel((ClassDatum)classDatum);
            Map<@NonNull Property, @NonNull List<@NonNull NavigableEdge>> property2predicatedEdges = typedModel2property2predicatedEdges.get(typedModel);
            if (property2predicatedEdges == null) {
                property2predicatedEdges = new HashMap<Property, List<NavigableEdge>>();
                typedModel2property2predicatedEdges.put(typedModel, property2predicatedEdges);
            }
            if ((predicatedEdges = property2predicatedEdges.get(property)) == null) {
                predicatedEdges = new ArrayList<NavigableEdge>();
                property2predicatedEdges.put(property, predicatedEdges);
            }
            predicatedEdges.add((NavigableEdge)predicatedEdge);
            QVTscheduleConstants.POLLED_PROPERTIES.println("  " + typedModel + " predicated for " + property);
        }
    }

    private void buildRealizedNavigationEdgesIndex2(@NonNull Map<@NonNull TypedModel, @NonNull Map<@NonNull Property, @NonNull List<@NonNull NavigableEdge>>> typedModel2property2realizedEdges) {
        for (NavigableEdge realizedEdge : this.region.getRealizedNavigationEdges()) {
            List<NavigableEdge> realizedEdges;
            Property property = QVTscheduleUtil.getProperty((NavigableEdge)realizedEdge);
            Node realizedNode = realizedEdge.getEdgeSource();
            ClassDatum classDatum = QVTscheduleUtil.getClassDatum((Node)realizedNode);
            TypedModel typedModel = QVTscheduleUtil.getReferredTypedModel((ClassDatum)classDatum);
            Map<@NonNull Property, @NonNull List<@NonNull NavigableEdge>> property2realizedEdges = typedModel2property2realizedEdges.get(typedModel);
            if (property2realizedEdges == null) {
                property2realizedEdges = new HashMap<Property, List<NavigableEdge>>();
                typedModel2property2realizedEdges.put(typedModel, property2realizedEdges);
            }
            if ((realizedEdges = property2realizedEdges.get(property)) == null) {
                realizedEdges = new ArrayList<NavigableEdge>();
                property2realizedEdges.put(property, realizedEdges);
            }
            realizedEdges.add(realizedEdge);
            QVTscheduleConstants.POLLED_PROPERTIES.println("  " + typedModel + " realized for " + property);
        }
    }

    public void computeCheckedOrEnforcedEdges(@NonNull Map<@NonNull TypedModel, @NonNull Map<@NonNull Property, @NonNull List<@NonNull NavigableEdge>>> typedModel2property2predicatedEdges, @NonNull Map<@NonNull TypedModel, @NonNull Map<@NonNull Property, @NonNull List<@NonNull NavigableEdge>>> typedModel2property2realizedEdges) {
        boolean doDebug = QVTscheduleConstants.POLLED_PROPERTIES.isActive();
        if (doDebug) {
            QVTscheduleConstants.POLLED_PROPERTIES.println("analyzing " + this.region + " (" + this.region.getIndexRangeText() + ")");
        }
        for (NavigationEdge predicatedEdge : this.region.getPredicatedNavigationEdges()) {
            EdgeConnection edgeConnection;
            assert (!predicatedEdge.isCast());
            Property property = predicatedEdge.getProperty();
            if (doDebug) {
                QVTscheduleConstants.POLLED_PROPERTIES.println("  analyzing " + predicatedEdge.getEdgeSource().getName() + "::" + property.getName() + " : " + predicatedEdge.getEdgeSource().getCompleteClass());
            }
            if ((edgeConnection = predicatedEdge.getIncomingConnection()) != null) {
                Region usedRegion;
                boolean isChecked = false;
                for (NavigableEdge usedEdge : QVTscheduleUtil.getSourceEnds((DatumConnection)edgeConnection)) {
                    usedRegion = QVTscheduleUtil.getOwningRegion((ConnectionEnd)usedEdge);
                    this.transformationAnalysis.getRegionAnalysis(usedRegion).addEnforcedEdge(usedEdge);
                    if (usedRegion.getFinalExecutionIndex() < this.region.getInvocationIndex()) continue;
                    this.addCheckedEdge((NavigableEdge)predicatedEdge);
                    isChecked = true;
                }
                if (isChecked) {
                    for (NavigableEdge usedEdge : QVTscheduleUtil.getSourceEnds((DatumConnection)edgeConnection)) {
                        usedRegion = QVTscheduleUtil.getOwningRegion((ConnectionEnd)usedEdge);
                        this.scheduleManager.getRegionAnalysis(usedRegion).addEnforcedEdge(usedEdge);
                    }
                }
            }
            Node laterNode = predicatedEdge.getEdgeSource();
            Node predicatedSourceNode = predicatedEdge.getEdgeSource();
            Node predicatedTargetNode = predicatedEdge.getEdgeTarget();
            NodeConnection usedConnection = predicatedTargetNode.getIncomingUsedConnection();
            if (usedConnection == null) continue;
            for (Node usedSourceNode : QVTscheduleUtil.getSourceEnds((DatumConnection)usedConnection)) {
                CompleteClass realizedTargetType;
                CompleteClass realizedSourceType;
                Node realizedTargetNode;
                Node realizedSourceNode;
                Region usedRegion = QVTscheduleUtil.getOwningRegion((Node)usedSourceNode);
                if (usedRegion.getFinalExecutionIndex() < this.region.getInvocationIndex()) continue;
                CompleteClass predicatedSourceType = predicatedSourceNode.getCompleteClass();
                CompleteClass predicatedTargetType = predicatedTargetNode.getCompleteClass();
                ClassDatum classDatum = laterNode.getClassDatum();
                TypedModel typedModel = classDatum.getReferredTypedModel();
                Map<@NonNull Property, @NonNull List<@NonNull NavigableEdge>> property2realizedEdges = typedModel2property2realizedEdges.get(typedModel);
                assert (property2realizedEdges != null);
                Property oclContainerProperty = this.scheduleManager.getStandardLibraryHelper().getOclContainerProperty();
                if (property == oclContainerProperty) {
                    for (Property candidateProperty : property2realizedEdges.keySet()) {
                        if (!candidateProperty.isIsComposite()) continue;
                        List<@NonNull NavigableEdge> realizedEdges = property2realizedEdges.get(candidateProperty);
                        assert (realizedEdges != null);
                        for (NavigableEdge realizedEdge : realizedEdges) {
                            Region earlierRegion = realizedEdge.getOwningRegion();
                            realizedSourceNode = realizedEdge.getEdgeSource();
                            realizedTargetNode = realizedEdge.getEdgeTarget();
                            realizedSourceType = realizedSourceNode.getCompleteClass();
                            realizedTargetType = realizedTargetNode.getCompleteClass();
                            if (realizedSourceType.conformsTo(predicatedSourceType) && realizedTargetType.conformsTo(predicatedTargetType)) assert (this.region.getFinalExecutionIndex() >= earlierRegion.getInvocationIndex());
                            assert (this.region.getFinalExecutionIndex() >= earlierRegion.getInvocationIndex());
                            this.addCheckedEdge((NavigableEdge)predicatedEdge);
                            this.scheduleManager.getRegionAnalysis(earlierRegion).addEnforcedEdge(realizedEdge);
                        }
                    }
                    continue;
                }
                assert (property2realizedEdges != null) : "No realized typed model for " + typedModel;
                List<@NonNull NavigableEdge> realizedEdges = property2realizedEdges.get(property);
                if (realizedEdges == null) {
                    System.err.println("No realized edges for " + typedModel + "!" + property + " in " + this.region);
                    continue;
                }
                for (NavigableEdge realizedEdge : realizedEdges) {
                    String enforceIsHazardFreeBecause;
                    String checkIsHazardFreeBecause;
                    Region earlierRegion = QVTscheduleUtil.getOwningRegion((ConnectionEnd)realizedEdge);
                    realizedSourceNode = realizedEdge.getEdgeSource();
                    realizedTargetNode = realizedEdge.getEdgeTarget();
                    realizedSourceType = realizedSourceNode.getCompleteClass();
                    realizedTargetType = realizedTargetNode.getCompleteClass();
                    if (!realizedSourceType.conformsTo(predicatedSourceType)) {
                        checkIsHazardFreeBecause = "incompatible-source";
                        enforceIsHazardFreeBecause = "incompatible-source";
                    } else if (!QVTscheduleUtil.conformsToClassOrBehavioralClass((CompleteClass)realizedTargetType, (CompleteClass)predicatedTargetType)) {
                        checkIsHazardFreeBecause = "incompatible-target";
                        enforceIsHazardFreeBecause = "incompatible-target";
                    } else if (this.region == earlierRegion) {
                        checkIsHazardFreeBecause = null;
                        enforceIsHazardFreeBecause = null;
                    } else if (earlierRegion.getFinalExecutionIndex() < this.region.getInvocationIndex()) {
                        checkIsHazardFreeBecause = "later";
                        enforceIsHazardFreeBecause = null;
                    } else {
                        checkIsHazardFreeBecause = null;
                        enforceIsHazardFreeBecause = null;
                    }
                    if (checkIsHazardFreeBecause == null) {
                        this.addCheckedEdge((NavigableEdge)predicatedEdge);
                    } else if (doDebug) {
                        QVTscheduleConstants.POLLED_PROPERTIES.println("    ignored check for " + this.region + "::" + laterNode.getName() + "(" + this.region.getIndexRangeText() + ")" + " " + checkIsHazardFreeBecause + " (" + earlierRegion.getIndexRangeText() + ")" + earlierRegion + "::" + realizedEdge.getEdgeSource().getName());
                    }
                    if (enforceIsHazardFreeBecause == null) {
                        this.scheduleManager.getRegionAnalysis(earlierRegion).addEnforcedEdge(realizedEdge);
                        continue;
                    }
                    if (!doDebug) continue;
                    QVTscheduleConstants.POLLED_PROPERTIES.println("    ignored enforce " + this.region + "::" + laterNode.getName() + "(" + this.region.getIndexRangeText() + ")" + " " + enforceIsHazardFreeBecause + " (" + earlierRegion.getIndexRangeText() + ")" + earlierRegion + "::" + realizedEdge.getEdgeSource().getName());
                }
            }
        }
    }

    public void createLocalSuccess() {
        List<@NonNull Node> traceNodes = this.getTraceNodes();
        assert (traceNodes.size() == 1);
        Node traceNode = (Node)ClassUtil.nonNullState((Object)traceNodes.get(0));
        Rule referredRule = QVTscheduleUtil.getReferredRule((RuleRegion)((RuleRegion)this.getRegion()));
        RelationAnalysis relationAnalysis = (RelationAnalysis)this.transformationAnalysis.getRuleAnalysis(referredRule);
        RelationAnalysis2TraceGroup relationAnalysis2traceGroup = relationAnalysis.getRuleAnalysis2TraceGroup();
        RelationAnalysis2TraceClass relationAnalysis2TraceClass = relationAnalysis2traceGroup.getRuleAnalysis2TraceClass();
        Element2MiddleProperty relation2localSuccessProperty = relationAnalysis2TraceClass.basicGetRelation2LocalSuccessProperty();
        Property localSuccessProperty = this.scheduleManager.basicGetLocalSuccessProperty(traceNode);
        if (relation2localSuccessProperty == null) {
            String localSuccessPropertyName = relationAnalysis2traceGroup.getNameGenerator().createTraceLocalSuccessPropertyName();
            relation2localSuccessProperty = relationAnalysis2TraceClass.createRelation2LocalSuccessProperty(localSuccessPropertyName);
            localSuccessProperty = relation2localSuccessProperty.getTraceProperty();
            SuccessEdge localSuccessEdge = relationAnalysis.createRealizedSuccess(traceNode, localSuccessProperty, null);
            QVTscheduleUtil.getTargetNode((Edge)localSuccessEdge).setUtility(Node.Utility.STRONGLY_MATCHED);
            this.analyzeLocalSuccessEdge(traceNode);
        }
    }

    public @Nullable Set<@NonNull NavigableEdge> getCheckedEdges(@NonNull TypedModel typedModel) {
        assert (this.typedModel2checkedEdges != null);
        return this.typedModel2checkedEdges.get(typedModel);
    }

    public @NonNull Iterable<@NonNull NavigableEdge> getCorollaryEdges() {
        return this.corollaryEdges;
    }

    public @NonNull Iterable<@NonNull Node> getCorollaryNodes() {
        return this.corollaryNodes;
    }

    public @Nullable Iterable<@NonNull NavigableEdge> getEnforcedEdges(@NonNull TypedModel typedModel, @NonNull Property asProperty) {
        assert (this.typedModel2property2enforcedEdges != null);
        Map<@NonNull Property, @NonNull Set<@NonNull NavigableEdge>> property2enforcedEdge = this.typedModel2property2enforcedEdges.get(typedModel);
        if (property2enforcedEdge != null) {
            Set<@NonNull NavigableEdge> enforcedEdges = property2enforcedEdge.get(asProperty);
            return enforcedEdges;
        }
        return null;
    }

    @Override
    public @Nullable Iterable<@NonNull RegionAnalysis> getExplicitPredecessors() {
        return null;
    }

    @Override
    public @NonNull String getName() {
        return String.valueOf(this.region);
    }

    @Override
    protected @NonNull Iterable<@NonNull Edge> getPartialEdges() {
        return QVTscheduleUtil.getOwnedEdges((Region)this.region);
    }

    @Override
    protected @NonNull Iterable<@NonNull Node> getPartialNodes() {
        return QVTscheduleUtil.getOwnedNodes((Region)this.region);
    }

    public @NonNull TransformationAnalysis getTransformationAnalysis() {
        return this.transformationAnalysis;
    }

    public String toString() {
        return this.region.toString();
    }
}

