/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvtp2qvts;

import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.AbstractConnection;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.ConnectionRole;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.Connections;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.EdgeConnection;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.NavigationEdge;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.Node;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.Region;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.ScheduledRegion;
import org.eclipse.qvtd.compiler.internal.utilities.SymbolNameBuilder;
import org.eclipse.qvtd.pivot.qvtimperative.utilities.GraphStringBuilder;

public class BasicEdgeConnection
extends AbstractConnection<NavigationEdge>
implements EdgeConnection {
    protected final @NonNull Property property;

    public BasicEdgeConnection(@NonNull ScheduledRegion region, @NonNull Set<@NonNull NavigationEdge> sourceEdges, @NonNull SymbolNameBuilder symbolNameBuilder, @NonNull Property property) {
        super(region, sourceEdges, symbolNameBuilder);
        this.property = property;
        assert (!property.isIsImplicit());
        region.addEdgeConnection(this);
        for (NavigationEdge sourceEdge : sourceEdges) {
            sourceEdge.addOutgoingConnection(this);
        }
    }

    @Override
    public void addUsedTargetEdge(@NonNull NavigationEdge targetEdge, boolean mustBeLater) {
        this.mergeRole(mustBeLater ? Connections.MANDATORY_EDGE : Connections.PREFERRED_EDGE);
        assert (!this.targetEnd2role.containsKey(targetEdge));
        this.targetEnd2role.put(targetEdge, mustBeLater ? Connections.MANDATORY_EDGE : Connections.PREFERRED_EDGE);
        targetEdge.addIncomingConnection(this);
    }

    @Override
    public void destroy() {
        for (NavigationEdge sourceEdge : this.sourceEnds) {
            sourceEdge.removeOutgoingConnection(this);
        }
        for (NavigationEdge targetNode : this.targetEnd2role.keySet()) {
            targetNode.removeIncomingConnection(this);
        }
        super.destroy();
    }

    @Override
    public @NonNull Property getProperty() {
        return this.property;
    }

    @Override
    public @NonNull Iterable<@NonNull Node> getSourceNodes() {
        ArrayList<@NonNull Node> sourceNodes = new ArrayList<Node>();
        for (NavigationEdge sourceEdge : this.sourceEnds) {
            sourceNodes.add(sourceEdge.getSource());
        }
        return sourceNodes;
    }

    @Override
    public @NonNull Iterable<@NonNull NavigationEdge> getTargetEdges() {
        return this.targetEnd2role.keySet();
    }

    @Override
    public @NonNull Iterable<@NonNull Node> getTargetNodes() {
        ArrayList<@NonNull Node> targetNodes = new ArrayList<Node>();
        for (NavigationEdge targetEdge : this.targetEnd2role.keySet()) {
            targetNodes.add(targetEdge.getTarget());
        }
        return targetNodes;
    }

    @Override
    public @NonNull Map<@NonNull NavigationEdge, @NonNull ConnectionRole> getTargets() {
        return this.targetEnd2role;
    }

    public boolean isEdge2Edge() {
        return this.sourceEnds.size() == 1 && this.targetEnd2role.size() == 1;
    }

    @Override
    public boolean isMandatory() {
        return false;
    }

    @Override
    public boolean isPassed() {
        return false;
    }

    @Override
    public boolean isPassed(@NonNull Region targetRegion) {
        return false;
    }

    @Override
    public void toCallGraph(@NonNull GraphStringBuilder s) {
    }

    @Override
    public void toGraph(@NonNull GraphStringBuilder s) {
        if (this.isEdge2Edge()) {
            NavigationEdge sourceEdge = (NavigationEdge)this.sourceEnds.iterator().next();
            NavigationEdge targetEdge = (NavigationEdge)this.targetEnd2role.keySet().iterator().next();
            s.appendEdge((GraphStringBuilder.GraphNode)sourceEdge.getTarget(), (GraphStringBuilder.GraphEdge)this, (GraphStringBuilder.GraphNode)targetEdge.getTarget());
        } else {
            s.appendNode((GraphStringBuilder.GraphNode)this);
            for (NavigationEdge source : this.getSources()) {
                s.appendEdge((GraphStringBuilder.GraphNode)source.getTarget(), (GraphStringBuilder.GraphEdge)this, (GraphStringBuilder.GraphNode)this);
            }
            for (NavigationEdge target : this.getTargetEdges()) {
                ConnectionRole role = (ConnectionRole)this.targetEnd2role.get(target);
                assert (role != null);
                s.appendEdge((GraphStringBuilder.GraphNode)this, (GraphStringBuilder.GraphEdge)role, (GraphStringBuilder.GraphNode)target.getTarget());
            }
        }
    }
}

