/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.adt.runner;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.codegen.merge.java.JControlModel;
import org.eclipse.emf.codegen.merge.java.JMerger;
import org.eclipse.emf.codegen.merge.java.facade.FacadeHelper;
import org.eclipse.emf.codegen.merge.java.facade.ast.ASTFacadeHelper;
import org.eclipse.emf.common.util.URI;
import org.eclipse.m2m.atl.adt.AdtPlugin;
import org.eclipse.m2m.atl.adt.Messages;
import org.eclipse.m2m.atl.adt.runner.ATLProperties;
import org.eclipse.m2m.atl.adt.runner.CreateModulePropertiesWriter;
import org.eclipse.m2m.atl.adt.runner.CreatePluginData;
import org.eclipse.m2m.atl.adt.runner.CreateRunnableData;
import org.eclipse.m2m.atl.adt.runner.CreateRunnableJavaWriter;

public class CreateRunnableAtlOperation
implements IWorkspaceRunnable {
    private IFile propertyFile;
    private IFile javaFile;

    public CreateRunnableAtlOperation(IFile propertyFile, IFile javaFile) {
        this.propertyFile = propertyFile;
        this.javaFile = javaFile;
    }

    public void run(IProgressMonitor monitor) throws CoreException {
        try {
            ATLProperties properties = new ATLProperties(this.propertyFile);
            properties.load(this.propertyFile.getContents());
            CreateRunnableData runnableData = new CreateRunnableData();
            runnableData.load(properties);
            CreatePluginData pluginData = new CreatePluginData(this.propertyFile.getProject().getName(), this.getBasePackage());
            pluginData.setRunnableData(runnableData);
            CreateRunnableJavaWriter runnableWriter = new CreateRunnableJavaWriter();
            String text = runnableWriter.generate(pluginData);
            this.createFile(this.javaFile, text, monitor);
            CreateModulePropertiesWriter propertiesWriter = new CreateModulePropertiesWriter();
            text = propertiesWriter.generate(runnableData);
            this.createFile(this.propertyFile, text, monitor);
        }
        catch (IOException e) {
            AdtPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.m2m.atl.adt", e.getMessage(), (Throwable)e));
        }
    }

    public String getBasePackage() {
        return this.javaFile.getFullPath().removeFirstSegments(2).removeLastSegments(1).toString().replaceAll("/", "\\.");
    }

    private void createFile(IFile newFile, String content, IProgressMonitor monitor) throws UnsupportedEncodingException, CoreException, IOException {
        IFile file = newFile;
        String text = content;
        if (file.exists() && "java".equals(file.getFileExtension())) {
            String jmergeFile = URI.createPlatformPluginURI((String)"org.eclipse.m2m.atl.adt/templates/atl-merge.xml", (boolean)false).toString();
            JControlModel model = new JControlModel();
            ASTFacadeHelper astFacadeHelper = new ASTFacadeHelper();
            model.initialize((FacadeHelper)astFacadeHelper, jmergeFile);
            if (model.canMerge()) {
                JMerger jMerger = new JMerger(model);
                jMerger.setSourceCompilationUnit(jMerger.createCompilationUnitForContents(text));
                try {
                    jMerger.setTargetCompilationUnit(jMerger.createCompilationUnitForInputStream((InputStream)new FileInputStream(file.getLocation().toFile())));
                    jMerger.merge();
                    text = jMerger.getTargetCompilationUnit().getContents();
                }
                catch (FileNotFoundException e) {
                    AdtPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.m2m.atl.adt", e.getMessage(), (Throwable)e));
                }
            } else {
                AdtPlugin.getDefault().getLog().log((IStatus)new Status(2, "org.eclipse.m2m.atl.adt", Messages.getString("CreateRunnableAtlOperation.MERGER_FAILURE"), null));
            }
        }
        if (!file.exists() && file.getParent().exists()) {
            IResource[] members = file.getParent().members(1);
            int i = 0;
            while (i < members.length) {
                if (members[i] instanceof IFile && file.getName().toLowerCase().equals(members[i].getName().toLowerCase())) {
                    file = (IFile)members[i];
                    break;
                }
                ++i;
            }
        }
        if (!file.exists() || !text.equals(CreateRunnableAtlOperation.convertStreamToString(file.getContents()))) {
            ByteArrayInputStream javaStream = new ByteArrayInputStream(text.getBytes("UTF8"));
            if (!file.exists()) {
                file.create((InputStream)javaStream, true, monitor);
            } else {
                file.setContents((InputStream)javaStream, true, false, monitor);
            }
        }
    }

    private static String convertStreamToString(InputStream is) throws IOException {
        StringWriter writer = new StringWriter();
        InputStreamReader reader = new InputStreamReader(is);
        BufferedReader buffer = new BufferedReader(reader);
        String line = "";
        while ((line = buffer.readLine()) != null) {
            writer.write(line);
        }
        return writer.toString();
    }
}

