/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.example.databinding.project.ui.rcp.databinding;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.databinding.conversion.Converter;
import org.eclipse.emf.ecore.xml.type.XMLTypeFactory;
import org.eclipse.emf.example.databinding.project.ui.rcp.Activator;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

public class Base64ToImageConverter
extends Converter {
    private Image lastImage;
    private Display display;

    public Base64ToImageConverter(Display display) {
        super(String.class, Image.class);
        this.display = display;
    }

    public Object convert(Object fromObject) {
        if (this.lastImage != null && !this.lastImage.isDisposed()) {
            this.lastImage.dispose();
            this.lastImage = null;
        }
        if (fromObject != null) {
            ByteArrayInputStream in = new ByteArrayInputStream(XMLTypeFactory.eINSTANCE.createBase64Binary(fromObject.toString()));
            Image img = new Image((Device)this.display, (InputStream)in);
            try {
                in.close();
            }
            catch (IOException e) {
                Activator.getDefault().log(e);
            }
            this.lastImage = img;
            return img;
        }
        return null;
    }
}

