/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.diagram.common.parameter;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.uml2.diagram.common.parameter.EditPropertyParametersDialog;
import org.eclipse.uml2.uml.Parameter;
import org.eclipse.uml2.uml.ParameterDirectionKind;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.ValueSpecification;

class ParametersCellModifier
implements ICellModifier {
    ParametersCellModifier() {
    }

    public boolean canModify(Object element, String property) {
        return true;
    }

    public Object getValue(Object element, String property) {
        Parameter parameter = (Parameter)element;
        if ("name".equals(property)) {
            return parameter.getName();
        }
        if ("types".equals(property)) {
            return parameter.getType();
        }
        if ("direction".equals(property)) {
            return parameter.getDirection();
        }
        if ("multiplicity".equals(property)) {
            return parameter.getUpper();
        }
        if ("defaultValue".equals(property)) {
            ValueSpecification defValue = parameter.getDefaultValue();
            if (defValue == null) {
                return "";
            }
            return new EditPropertyParametersDialog.ValueSpecificationToStringConverter().doSwitch((EObject)defValue);
        }
        if ("isOrdered".equals(property)) {
            return parameter.isOrdered();
        }
        if ("isUnique".equals(property)) {
            return parameter.isUnique();
        }
        return null;
    }

    public void modify(Object element, String property, Object value) {
        Parameter parameter = (Parameter)((TableItem)element).getData();
        if ("name".equals(property)) {
            parameter.setName((String)value);
        } else if ("types".equals(property)) {
            this.setType(parameter, value);
        } else if ("direction".equals(property)) {
            parameter.setDirection((ParameterDirectionKind)value);
        } else if ("multiplicity".equals(property)) {
            parameter.setUpper(((Integer)value).intValue());
        } else if ("defaultValue".equals(property)) {
            this.setDefaultValue(parameter, value);
        } else if ("isUnique".equals(property)) {
            parameter.setIsUnique(((Boolean)value).booleanValue());
        } else if ("isOrdered".equals(property)) {
            parameter.setIsOrdered(((Boolean)value).booleanValue());
        }
        boolean modified = true;
        if (modified) {
            this.updateViewer(parameter, property);
        }
    }

    public void updateViewer(Parameter parameter, String property) {
    }

    private void setDefaultValue(Parameter parameter, Object value) {
        ValueSpecification defValue = parameter.getDefaultValue();
        if (defValue == null) {
            parameter.createDefaultValue(null, null, UMLPackage.eINSTANCE.getLiteralString());
        }
        new EditPropertyParametersDialog.SetValueToSpecification((String)value).doSwitch((EObject)defValue);
    }

    private void setType(Parameter parameter, Object value) {
        if (EditPropertyParametersDialog.NULL_TYPE.equals(value)) {
            value = null;
        }
        parameter.setType((Type)value);
    }
}

