package utils;

import com.google.common.collect.Iterators;
import com.google.inject.Singleton;
import org.eclipse.gmf.codegen.gmfgen.GenDiagram;
import org.eclipse.papyrus.papyrusgmfgenextension.AdditionalEditPartCandies;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;

@Singleton
@SuppressWarnings("all")
public class EditHelperUtils_qvto {
  public String getBaseEditHelperFullName(final GenDiagram diagram) {
    boolean _isEmpty = IteratorExtensions.isEmpty(Iterators.<AdditionalEditPartCandies>filter(diagram.eResource().getAllContents(), AdditionalEditPartCandies.class));
    boolean _not = (!_isEmpty);
    if (_not) {
      String _baseEditHelperPackage = IteratorExtensions.<AdditionalEditPartCandies>head(Iterators.<AdditionalEditPartCandies>filter(diagram.eResource().getAllContents(), AdditionalEditPartCandies.class)).getBaseEditHelperPackage();
      String _plus = (_baseEditHelperPackage + ".");
      String _baseEditHelperClassName = diagram.getBaseEditHelperClassName();
      return (_plus + _baseEditHelperClassName);
    } else {
      return diagram.getBaseEditHelperQualifiedClassName();
    }
  }
}
