/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.edit.policies;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.ConnectionRouter;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gef.requests.CreateConnectionRequest;
import org.eclipse.gef.requests.ReconnectRequest;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.core.commands.SetConnectionEndsCommand;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.GraphicalNodeEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateConnectionViewAndElementRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateConnectionViewRequest;
import org.eclipse.gmf.runtime.emf.type.core.IHintedType;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.uml.diagram.sequence.command.OLDCreateGateViewCommand;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.OLDGateEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.policies.LifelineChildGraphicalNodeEditPolicy;
import org.eclipse.papyrus.uml.diagram.sequence.providers.UMLElementTypes;
import org.eclipse.papyrus.uml.diagram.sequence.util.GateHelper;
import org.eclipse.papyrus.uml.diagram.sequence.util.SequenceUtil;
import org.eclipse.uml2.uml.CombinedFragment;
import org.eclipse.uml2.uml.Gate;
import org.eclipse.uml2.uml.Interaction;
import org.eclipse.uml2.uml.InteractionFragment;
import org.eclipse.uml2.uml.InteractionOperand;
import org.eclipse.uml2.uml.InteractionUse;
import org.eclipse.uml2.uml.Message;
import org.eclipse.uml2.uml.MessageEnd;

public class OLDGateGraphicalNodeEditPolicy
extends GraphicalNodeEditPolicy {
    protected Command getConnectionCompleteCommand(CreateConnectionRequest request) {
        request.getExtendedData().put("Target model container", this.getInteractionFragment(request.getLocation()));
        Command command = super.getConnectionCompleteCommand(request);
        if (request instanceof CreateConnectionViewAndElementRequest) {
            CreateConnectionViewAndElementRequest viewRequest = (CreateConnectionViewAndElementRequest)request;
            EditPart sourceEP = viewRequest.getSourceEditPart();
            EObject source = ViewUtil.resolveSemanticElement((View)((View)sourceEP.getModel()));
            String semanticHint = viewRequest.getConnectionViewAndElementDescriptor().getSemanticHint();
            if ((((IHintedType)UMLElementTypes.Message_AsynchEdge).getSemanticHint().equals(semanticHint) || ((IHintedType)UMLElementTypes.Message_ReplyEdge).getSemanticHint().equals(semanticHint)) && (source instanceof CombinedFragment || source instanceof Interaction || source instanceof InteractionUse)) {
                CreateConnectionViewRequest.ConnectionViewDescriptor edgeAdapter;
                IAdaptable elementAdapter;
                CompoundCommand cc = new CompoundCommand("Redirect to Gate");
                Point location = null;
                IGraphicalEditPart adapter = (IGraphicalEditPart)sourceEP.getAdapter(IGraphicalEditPart.class);
                if (adapter != null) {
                    Point sourceLocation = request.getLocation();
                    Object object = request.getExtendedData().get("Location of connection source point");
                    if (object instanceof Point) {
                        sourceLocation = (Point)object;
                    }
                    location = GateHelper.computeGateLocation(sourceLocation, adapter.getFigure(), null);
                }
                if ((elementAdapter = (edgeAdapter = viewRequest.getConnectionViewDescriptor()).getElementAdapter()) != null) {
                    IAdaptable gateAdapter = new IAdaptable(){

                        public Object getAdapter(Class adapter) {
                            Message message;
                            MessageEnd sendEvent;
                            if (Gate.class == adapter && (sendEvent = (message = (Message)elementAdapter.getAdapter(Message.class)).getSendEvent()) instanceof Gate) {
                                return sendEvent;
                            }
                            return null;
                        }
                    };
                    TransactionalEditingDomain editingDomain = ((IGraphicalEditPart)this.getHost()).getEditingDomain();
                    OLDCreateGateViewCommand createGateCommand = new OLDCreateGateViewCommand(editingDomain, (IAdaptable)sourceEP, location, gateAdapter);
                    cc.add((Command)new ICommandProxy((ICommand)createGateCommand));
                    SetConnectionEndsCommand resetSourceCommand = new SetConnectionEndsCommand(editingDomain, null);
                    resetSourceCommand.setEdgeAdaptor((IAdaptable)edgeAdapter);
                    resetSourceCommand.setNewSourceAdaptor(createGateCommand.getResult());
                    cc.add((Command)new ICommandProxy((ICommand)resetSourceCommand));
                    if (cc.canExecute()) {
                        command = command.chain((Command)cc);
                    }
                }
            }
        }
        return command;
    }

    private Gate resolveSemanticElement() {
        return (Gate)((OLDGateEditPart)this.getHost()).resolveSemanticElement();
    }

    private InteractionFragment getInteractionFragment(Point location) {
        Gate gate = this.resolveSemanticElement();
        if (gate != null) {
            Rectangle rect;
            InteractionFragment fragment = (InteractionFragment)gate.eContainer();
            if (fragment instanceof CombinedFragment && !((fragment = SequenceUtil.findInteractionFragmentContainerAt(location, this.getHost())) instanceof InteractionOperand) && !((fragment = SequenceUtil.findInteractionFragmentContainerAt((rect = SequenceUtil.getAbsoluteBounds((IGraphicalEditPart)this.getHost())).getRight(), this.getHost())) instanceof InteractionOperand)) {
                fragment = SequenceUtil.findInteractionFragmentContainerAt(rect.getLeft(), this.getHost());
            }
            return fragment;
        }
        return null;
    }

    protected Command getConnectionAndRelationshipCompleteCommand(CreateConnectionViewAndElementRequest request) {
        request.getExtendedData().put("Target model container", this.getInteractionFragment(request.getLocation()));
        return super.getConnectionAndRelationshipCompleteCommand(request);
    }

    protected Command getConnectionCreateCommand(CreateConnectionRequest request) {
        if (request.getSourceEditPart() != null && request.getSourceEditPart() != this.getHost()) {
            return null;
        }
        request.getExtendedData().put("Source model container", this.getInteractionFragment(request.getLocation()));
        Rectangle rect = SequenceUtil.getAbsoluteBounds((IGraphicalEditPart)this.getHost());
        request.getExtendedData().put("Location of connection source point", rect.getLocation());
        return super.getConnectionCreateCommand(request);
    }

    protected Command getConnectionAndRelationshipCreateCommand(CreateConnectionViewAndElementRequest request) {
        if (request.getSourceEditPart() != null && request.getSourceEditPart() != this.getHost()) {
            return null;
        }
        request.getExtendedData().put("Source model container", this.getInteractionFragment(request.getLocation()));
        Rectangle rect = SequenceUtil.getAbsoluteBounds((IGraphicalEditPart)this.getHost());
        request.getExtendedData().put("Location of connection source point", rect.getLocation());
        return super.getConnectionAndRelationshipCreateCommand(request);
    }

    protected Connection createDummyConnection(Request req) {
        PolylineConnection c = (PolylineConnection)super.createDummyConnection(req);
        c.setLineStyle(4);
        c.setForegroundColor(ColorConstants.black);
        return c;
    }

    protected ConnectionRouter getDummyConnectionRouter(CreateConnectionRequest arg0) {
        return LifelineChildGraphicalNodeEditPolicy.messageRouter;
    }

    protected Command getReconnectTargetCommand(ReconnectRequest request) {
        ConnectionEditPart connectionEditPart = request.getConnectionEditPart();
        IGraphicalEditPart adapter = (IGraphicalEditPart)connectionEditPart.getAdapter(IGraphicalEditPart.class);
        if (adapter != null && adapter.resolveSemanticElement() instanceof Message) {
            Message oldMessage = (Message)adapter.resolveSemanticElement();
            Gate gate = this.resolveSemanticElement();
            if (gate == null || gate.getMessage() != null && oldMessage != gate.getMessage()) {
                return UnexecutableCommand.INSTANCE;
            }
        }
        return super.getReconnectTargetCommand(request);
    }
}

