/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.layout;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PrecisionRectangle;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.CompartmentEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IBorderItemEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ShapeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.figures.IBorderItemLocator;
import org.eclipse.gmf.runtime.draw2d.ui.figures.IOvalAnchorableFigure;
import org.eclipse.papyrus.extensionpoints.editors.Activator;
import org.eclipse.papyrus.uml.diagram.common.util.Util;

public class LayoutUtils {
    public static final String alignementCmdId = "org.eclipse.papyrus.uml.diagram.common.commands.AlignmentCommand";
    public static final String routingCmdId = "org.eclipse.papyrus.uml.diagram.common.commands.RoutingCommand";
    public static final String LEFT = "parameter_left";
    public static final String RIGHT = "parameter_right";
    public static final String TOP = "parameter_top";
    public static final String BOTTOM = "parameter_bottom";
    public static final String CENTER = "parameter_center";
    public static final String MIDDLE = "parameter_middle";
    public static final String HORIZONTALLY = "parameter_horizontally";
    public static final String HORIZONTALLY_BETWEEN_NODES = "parameter_horizontally_between_nodes";
    public static final String VERTICALLY = "parameter_vertically";
    public static final String VERTICALLY_BETWEEN_NODES = "parameter_vertically_between_nodes";
    public static final double scrollBarSize = 6.0;
    private static final int[] northArray = new int[]{1, 17, 9};
    private static final int[] southArray = new int[]{4, 20, 12};
    private static final int[] eastArray = new int[]{16, 17, 20};
    private static final int[] westArray = new int[]{8, 9, 12};
    public static final List<Integer> northPositions = LayoutUtils.fillList(northArray);
    public static final List<Integer> southPositions = LayoutUtils.fillList(southArray);
    public static final List<Integer> eastPositions = LayoutUtils.fillList(eastArray);
    public static final List<Integer> westPositions = LayoutUtils.fillList(westArray);

    public static PrecisionRectangle getAbsolutePosition(EditPart ep) {
        GraphicalEditPart part = (GraphicalEditPart)ep;
        PrecisionRectangle rect = new PrecisionRectangle(part.getFigure().getBounds());
        part.getFigure().translateToAbsolute((Translatable)rect);
        return rect;
    }

    public static int getAnchorPosition(EditPart node, Point anchor) {
        int position = 0;
        PrecisionRectangle bounds = LayoutUtils.getAbsolutePosition(node);
        if (anchor.y == bounds.y && anchor.x != bounds.x && anchor.x != bounds.getRight().x) {
            position = 1;
        } else if (anchor.y == bounds.getBottom().y && anchor.x != bounds.x && anchor.x != bounds.getRight().x) {
            position = 4;
        } else if (anchor.x == bounds.getRight().x && anchor.y != bounds.y && anchor.y != bounds.getBottom().y) {
            position = 16;
        } else if (anchor.x == bounds.x && anchor.y != bounds.getTop().y && anchor.y != bounds.getBottom().y) {
            position = 8;
        } else if (anchor.equals((Object)bounds.getLeft())) {
            position = 17;
        } else if (anchor.equals((Object)bounds.getRight())) {
            position = 9;
        } else if (anchor.equals((Object)bounds.getBottomRight())) {
            position = 20;
        } else if (anchor.equals((Object)bounds.getBottomLeft())) {
            position = 12;
        }
        if (position == 0 && node instanceof ShapeEditPart) {
            IFigure figure;
            for (Object obj : node.getChildren()) {
                if (!(obj instanceof CompartmentEditPart) || position != 0) continue;
                position = LayoutUtils.getAnchorPosition((EditPart)obj, anchor);
            }
            if (position == 0 && (figure = ((ShapeEditPart)node).getFigure()) instanceof IOvalAnchorableFigure) {
                Rectangle bounds2 = ((IOvalAnchorableFigure)figure).getOvalBounds().getCopy();
                figure.translateToAbsolute((Translatable)bounds2);
                Rectangle northWestBounds = new Rectangle(bounds2.x, bounds2.y, bounds2.width / 2, bounds2.height / 2);
                Rectangle southWestBounds = new Rectangle(bounds2.getLeft().x, bounds2.getLeft().y, bounds2.width / 2, bounds2.height / 2);
                Rectangle northEAstBounds = new Rectangle(bounds2.getTop().x, bounds2.getTop().y, bounds2.width / 2, bounds2.height / 2);
                Rectangle southEAstBounds = new Rectangle(bounds2.getTop().x, bounds2.getLeft().y, bounds2.width / 2, bounds2.height / 2);
                if (northEAstBounds.contains(anchor)) {
                    return 17;
                }
                if (southEAstBounds.contains(anchor)) {
                    return 20;
                }
                if (southWestBounds.contains(anchor)) {
                    return 12;
                }
                if (northWestBounds.contains(anchor)) {
                    return 9;
                }
            }
        }
        return position;
    }

    private static List<Integer> fillList(int[] array) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        int i = 0;
        while (i < array.length) {
            list.add(new Integer(array[i]));
            ++i;
        }
        return list;
    }

    public static Point[] getLinkAnchor(IGraphicalEditPart sourceEditPart, IGraphicalEditPart targetEditPart) {
        Point targetLocation;
        Point sourceLocation;
        block78: {
            PrecisionRectangle diagramBounds;
            PrecisionRectangle targetBounds;
            PrecisionRectangle sourceBounds;
            block75: {
                int side;
                IBorderItemLocator loc;
                int targetPosition;
                block77: {
                    block76: {
                        sourceLocation = new Point();
                        targetLocation = new Point();
                        targetPosition = 0;
                        sourceBounds = LayoutUtils.getAbsolutePosition((EditPart)sourceEditPart);
                        targetBounds = LayoutUtils.getAbsolutePosition((EditPart)targetEditPart);
                        IGraphicalEditPart diagramEP = sourceEditPart;
                        while (!(diagramEP instanceof DiagramEditPart)) {
                            diagramEP = diagramEP.getParent();
                        }
                        diagramBounds = LayoutUtils.getAbsolutePosition((EditPart)diagramEP);
                        if (sourceBounds.intersects((Rectangle)targetBounds)) break block75;
                        targetPosition = LayoutUtils.getRelativePositionFor(sourceBounds, targetBounds, diagramBounds);
                        if (Util.isAffixedChildNode((EditPart)sourceEditPart)) break block76;
                        switch (targetPosition) {
                            case 1: {
                                sourceLocation = sourceBounds.getTop();
                                if (!(sourceBounds.preciseX() >= targetBounds.preciseX()) || !(sourceBounds.getRight().preciseX() <= targetBounds.getRight().preciseX())) {
                                    if (sourceBounds.preciseX() <= targetBounds.preciseX() && sourceBounds.getRight().preciseX() >= targetBounds.getRight().preciseX()) {
                                        sourceLocation.x = (int)targetBounds.getBottom().preciseX();
                                        break;
                                    }
                                    if (sourceBounds.preciseX() <= targetBounds.preciseX() && sourceBounds.getRight().preciseX() <= targetBounds.getRight().preciseX()) {
                                        sourceLocation.x = (int)((targetBounds.preciseX() + sourceBounds.getRight().preciseX()) / 2.0);
                                        break;
                                    }
                                    sourceLocation.x = (int)((sourceBounds.preciseX() + targetBounds.getRight().preciseX()) / 2.0);
                                    break;
                                }
                                break block77;
                            }
                            case 4: {
                                sourceLocation = sourceBounds.getBottom();
                                if (!(sourceBounds.preciseX() >= targetBounds.preciseX()) || !(sourceBounds.getRight().preciseX() <= targetBounds.getRight().preciseX())) {
                                    if (sourceBounds.preciseX() <= targetBounds.preciseX() && sourceBounds.getRight().preciseX() >= targetBounds.getRight().preciseX()) {
                                        sourceLocation.x = (int)targetBounds.getBottom().preciseX();
                                        break;
                                    }
                                    if (sourceBounds.preciseX() <= targetBounds.preciseX() && sourceBounds.getRight().preciseX() <= targetBounds.getRight().preciseX()) {
                                        sourceLocation.x = (int)((targetBounds.preciseX() + sourceBounds.getRight().preciseX()) / 2.0);
                                        break;
                                    }
                                    sourceLocation.x = (int)((sourceBounds.preciseX() + targetBounds.getRight().preciseX()) / 2.0);
                                    break;
                                }
                                break block77;
                            }
                            case 16: {
                                sourceLocation = sourceBounds.getRight();
                                if (!(sourceBounds.preciseY() >= targetBounds.preciseY()) || !(sourceBounds.getBottom().preciseY() <= targetBounds.getBottom().preciseY())) {
                                    if (sourceBounds.preciseY() <= targetBounds.preciseY() && sourceBounds.getBottom().preciseY() >= targetBounds.getBottom().preciseY()) {
                                        sourceLocation.y = (int)targetBounds.getLeft().preciseY();
                                        break;
                                    }
                                    if (sourceBounds.preciseY() >= targetBounds.preciseY() && sourceBounds.getBottom().preciseY() >= targetBounds.getBottom().preciseY()) {
                                        sourceLocation.y = (int)((targetBounds.getBottom().preciseY() + sourceBounds.preciseY()) / 2.0);
                                        break;
                                    }
                                    sourceLocation.y = (int)((sourceBounds.getBottom().preciseY() + targetBounds.preciseY()) / 2.0);
                                    break;
                                }
                                break block77;
                            }
                            case 8: {
                                sourceLocation = sourceBounds.getLeft();
                                if (!(sourceBounds.preciseY() > targetBounds.preciseY()) || !(sourceBounds.getBottom().preciseY() < targetBounds.getBottom().preciseY())) {
                                    if (sourceBounds.preciseY() < targetBounds.preciseY() && sourceBounds.getBottom().preciseY() > targetBounds.getBottom().preciseY()) {
                                        sourceLocation.y = (int)targetBounds.getLeft().preciseY();
                                        break;
                                    }
                                    if (sourceBounds.preciseY() > targetBounds.preciseY() && sourceBounds.getBottom().preciseY() > targetBounds.getBottom().preciseY()) {
                                        sourceLocation.y = (int)((targetBounds.getBottom().preciseY() + sourceBounds.preciseY()) / 2.0);
                                        break;
                                    }
                                    sourceLocation.y = (int)((sourceBounds.getBottom().preciseY() + targetBounds.preciseY()) / 2.0);
                                    break;
                                }
                                break block77;
                            }
                            case 17: {
                                sourceLocation = sourceBounds.getTop();
                                break;
                            }
                            case 9: {
                                sourceLocation = sourceBounds.getTop();
                                break;
                            }
                            case 20: {
                                sourceLocation = sourceBounds.getBottom();
                                break;
                            }
                            case 12: {
                                sourceLocation = sourceBounds.getBottom();
                                break;
                            }
                        }
                        break block77;
                    }
                    loc = ((IBorderItemEditPart)sourceEditPart).getBorderItemLocator();
                    side = loc.getCurrentSideOfParent();
                    switch (targetPosition) {
                        case 1: {
                            sourceLocation = sourceBounds.getTop();
                            break;
                        }
                        case 4: {
                            sourceLocation = sourceBounds.getBottom();
                            break;
                        }
                        case 16: {
                            sourceLocation = sourceBounds.getRight();
                            break;
                        }
                        case 8: {
                            sourceLocation = sourceBounds.getLeft();
                            break;
                        }
                        case 17: {
                            if (eastPositions.contains(new Integer(side))) {
                                sourceLocation = sourceBounds.getRight();
                                break;
                            }
                            if (westPositions.contains(new Integer(side))) {
                                sourceLocation = sourceBounds.getRight();
                                break;
                            }
                            sourceLocation = sourceBounds.getTop();
                            break;
                        }
                        case 9: {
                            if (eastPositions.contains(new Integer(side))) {
                                sourceLocation = sourceBounds.getLeft();
                                break;
                            }
                            if (westPositions.contains(new Integer(side))) {
                                sourceLocation = sourceBounds.getLeft();
                                break;
                            }
                            sourceLocation = sourceBounds.getTop();
                            break;
                        }
                        case 20: {
                            if (northPositions.contains(new Integer(side))) {
                                sourceLocation = sourceBounds.getBottom();
                                break;
                            }
                            if (southPositions.contains(new Integer(side))) {
                                sourceLocation = sourceBounds.getBottom();
                                break;
                            }
                            sourceLocation = sourceBounds.getRight();
                            break;
                        }
                        case 12: {
                            if (northPositions.contains(new Integer(side))) {
                                sourceLocation = sourceBounds.getBottom();
                                break;
                            }
                            if (southPositions.contains(new Integer(side))) {
                                sourceLocation = sourceBounds.getBottom();
                                break;
                            }
                            sourceLocation = sourceBounds.getLeft();
                            break;
                        }
                    }
                }
                if (!Util.isAffixedChildNode((EditPart)targetEditPart)) {
                    switch (targetPosition) {
                        case 1: {
                            targetLocation.setLocation(sourceLocation.x, (int)targetBounds.getBottom().preciseY());
                            break;
                        }
                        case 4: {
                            targetLocation.setLocation(sourceLocation.x, (int)targetBounds.getTop().preciseY());
                            break;
                        }
                        case 16: {
                            targetLocation.setLocation((int)targetBounds.preciseX(), (int)sourceLocation.preciseY());
                            break;
                        }
                        case 8: {
                            targetLocation.setLocation((int)targetBounds.preciseX(), (int)sourceLocation.preciseY());
                            break;
                        }
                        case 17: {
                            targetLocation = targetBounds.getLeft();
                            break;
                        }
                        case 9: {
                            targetLocation = targetBounds.getRight();
                            break;
                        }
                        case 20: {
                            targetLocation = targetBounds.getLeft();
                            break;
                        }
                        case 12: {
                            targetLocation = targetBounds.getRight();
                            break;
                        }
                    }
                } else {
                    loc = ((IBorderItemEditPart)targetEditPart).getBorderItemLocator();
                    side = loc.getCurrentSideOfParent();
                    switch (targetPosition) {
                        case 1: {
                            targetLocation = targetBounds.getBottom();
                            break;
                        }
                        case 4: {
                            targetLocation = targetBounds.getTop();
                            break;
                        }
                        case 16: {
                            targetLocation = targetBounds.getLeft();
                            break;
                        }
                        case 8: {
                            targetLocation = targetBounds.getRight();
                            break;
                        }
                        case 17: {
                            if (eastPositions.contains(new Integer(side))) {
                                targetLocation = targetBounds.getRight();
                                break;
                            }
                            if (westPositions.contains(new Integer(side))) {
                                targetLocation = targetBounds.getRight();
                                break;
                            }
                            targetLocation = targetBounds.getTop();
                            break;
                        }
                        case 9: {
                            if (eastPositions.contains(new Integer(side))) {
                                targetLocation = targetBounds.getLeft();
                                break;
                            }
                            if (westPositions.contains(new Integer(side))) {
                                targetLocation = targetBounds.getLeft();
                                break;
                            }
                            targetLocation = targetBounds.getTop();
                            break;
                        }
                        case 20: {
                            if (northPositions.contains(new Integer(side))) {
                                targetLocation = targetBounds.getTop();
                                break;
                            }
                            if (southPositions.contains(new Integer(side))) {
                                targetLocation = targetBounds.getTop();
                                break;
                            }
                            targetLocation = targetBounds.getLeft();
                            break;
                        }
                        case 12: {
                            if (northPositions.contains(new Integer(side))) {
                                targetLocation = targetBounds.getTop();
                                break;
                            }
                            if (southPositions.contains(new Integer(side))) {
                                targetLocation = targetBounds.getTop();
                                break;
                            }
                            targetLocation = targetBounds.getRight();
                            break;
                        }
                    }
                }
                break block78;
            }
            if (sourceBounds.contains((Rectangle)targetBounds)) {
                sourceLocation.setLocation((int)targetBounds.getBottom().preciseX(), (int)sourceBounds.getBottom().preciseY());
                targetLocation = targetBounds.getBottom();
            } else if (targetBounds.contains((Rectangle)sourceBounds)) {
                sourceLocation = sourceBounds.getBottom();
                targetLocation.setLocation((int)sourceBounds.getBottom().preciseX(), (int)targetBounds.getBottom().preciseY());
            } else {
                Rectangle rect = new Rectangle((Rectangle)sourceBounds);
                Rectangle intersection = rect.getCopy().intersect((Rectangle)targetBounds);
                int n = LayoutUtils.getRelativePositionFor(sourceBounds, new PrecisionRectangle(intersection), diagramBounds);
            }
        }
        return new Point[]{sourceLocation, targetLocation};
    }

    public static int getRelativePositionFor(PrecisionRectangle reference, PrecisionRectangle rect, PrecisionRectangle diagramBounds) {
        PrecisionRectangle pos = new PrecisionRectangle();
        pos.setX(reference.preciseX());
        pos.setY(0);
        pos.setHeight(reference.preciseY());
        pos.setWidth(reference.preciseWidth());
        if (pos.intersects((Rectangle)rect)) {
            return 1;
        }
        pos.setX(reference.preciseX());
        pos.setY(reference.getBottom().preciseY());
        pos.setHeight(diagramBounds.preciseHeight() - reference.getBottom().preciseY());
        pos.setWidth(reference.preciseWidth());
        if (pos.intersects((Rectangle)rect)) {
            return 4;
        }
        pos.setX(reference.getRight().preciseX());
        pos.setY(reference.getTop().preciseY());
        pos.setHeight(reference.preciseHeight());
        pos.setWidth(diagramBounds.preciseWidth() - reference.getLeft().preciseY());
        if (pos.intersects((Rectangle)rect)) {
            return 16;
        }
        pos.setX(0);
        pos.setY(reference.preciseY());
        pos.setHeight(reference.preciseHeight());
        pos.setWidth(reference.preciseX());
        if (pos.intersects((Rectangle)rect)) {
            return 8;
        }
        pos.setX(reference.getTop().preciseX());
        pos.setY(0);
        pos.setHeight(reference.getRight().preciseY());
        pos.setWidth(diagramBounds.preciseWidth() - reference.getTop().preciseX());
        if (pos.intersects((Rectangle)rect)) {
            return 17;
        }
        pos = new PrecisionRectangle();
        pos.setX(0);
        pos.setY(0);
        pos.setHeight(reference.getLeft().preciseY());
        pos.setWidth(reference.getTop().preciseX());
        if (pos.intersects((Rectangle)rect)) {
            return 9;
        }
        pos = new PrecisionRectangle();
        pos.setX(reference.getBottom().preciseX());
        pos.setY(reference.getRight().preciseY());
        pos.setHeight(diagramBounds.preciseHeight() - reference.getRight().preciseY());
        pos.setWidth(diagramBounds.preciseWidth() - reference.getBottom().preciseX());
        if (pos.intersects((Rectangle)rect)) {
            return 20;
        }
        pos = new PrecisionRectangle();
        pos.setX(0);
        pos.setY(reference.getLeft().preciseY());
        pos.setHeight(diagramBounds.preciseHeight() - reference.getLeft().preciseY());
        pos.setWidth(reference.getBottom().preciseX());
        if (pos.intersects((Rectangle)rect)) {
            return 12;
        }
        Activator.log((String)("I can't find the relative position for " + rect + " compared to " + reference + " ."));
        return 0;
    }
}

