/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.widgets.editors;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.databinding.observable.ChangeEvent;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.papyrus.infra.widgets.Activator;
import org.eclipse.papyrus.infra.widgets.editors.AbstractValueEditor;
import org.eclipse.papyrus.infra.widgets.editors.StringLabel;
import org.eclipse.papyrus.infra.widgets.messages.Messages;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class IntegerMask
extends AbstractValueEditor
implements SelectionListener,
IChangeListener,
DisposeListener {
    private Button[] checkboxes;
    private int currentValue;
    private final Composite checkboxContainer;
    private boolean refreshCheckboxes = true;

    public IntegerMask(Composite parent, int style) {
        super(parent, style);
        this.checkboxContainer = new Composite((Composite)this, style);
        this.checkboxContainer.setLayoutData((Object)this.getDefaultLayoutData());
        this.checkboxContainer.setLayout((Layout)new GridLayout(2, true));
        this.checkboxContainer.addDisposeListener((DisposeListener)this);
    }

    @Override
    protected GridData getLabelLayoutData() {
        GridData data = super.getLabelLayoutData();
        data.verticalAlignment = 1;
        return data;
    }

    @Override
    public Object getValue() {
        int totalValue = 0;
        Button[] buttonArray = this.checkboxes;
        int n = this.checkboxes.length;
        int n2 = 0;
        while (n2 < n) {
            Button button = buttonArray[n2];
            int value = (Integer)button.getData("IntValue");
            if (button.getSelection()) {
                totalValue |= value;
            }
            ++n2;
        }
        return totalValue;
    }

    public void dispose() {
        if (this.modelProperty != null) {
            this.modelProperty.removeChangeListener((IChangeListener)this);
        }
        super.dispose();
    }

    @Override
    public Object getEditableType() {
        return Integer.class;
    }

    @Override
    public void setReadOnly(boolean readOnly) {
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    public void setMasks(String[] values) {
        HashMap<Integer, String> masks = new HashMap<Integer, String>();
        int intValue = 1;
        String[] stringArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            String value = stringArray[n2];
            masks.put(intValue, value);
            intValue <<= 1;
            ++n2;
        }
        this.setMasks(masks);
    }

    public void setMasks(Map<Integer, String> values) {
        if (values.size() > 32) {
            StringLabel label = new StringLabel(this.checkboxContainer, 0);
            label.getValueLabel().setImage(Activator.getDefault().getImage("/icons/error.gif"));
            label.getValueLabel().setText(Messages.IntegerMask_ErrorTooManyValues);
            this.checkboxes = new Button[0];
        } else {
            if (this.checkboxes != null) {
                this.disposeCheckboxes();
            }
            this.checkboxes = new Button[values.size()];
            int i = 0;
            for (Map.Entry<Integer, String> mask : values.entrySet()) {
                int intValue = mask.getKey();
                String value = mask.getValue();
                this.checkboxes[i] = new Button(this.checkboxContainer, 32);
                this.checkboxes[i].setText(value);
                this.checkboxes[i].setData("IntValue", (Object)intValue);
                this.checkboxes[i].addSelectionListener((SelectionListener)this);
                ++i;
            }
        }
    }

    protected void disposeCheckboxes() {
        Button[] buttonArray = this.checkboxes;
        int n = this.checkboxes.length;
        int n2 = 0;
        while (n2 < n) {
            Button button = buttonArray[n2];
            button.removeSelectionListener((SelectionListener)this);
            button.dispose();
            ++n2;
        }
    }

    public void setNumColumns(int numColumns) {
        ((GridLayout)this.checkboxContainer.getLayout()).numColumns = numColumns;
        this.checkboxContainer.layout();
        this.layout();
    }

    @Override
    public void doBinding() {
        this.modelProperty.addChangeListener((IChangeListener)this);
        this.refreshCheckboxes();
    }

    protected void refreshCheckboxes() {
        if (!this.refreshCheckboxes) {
            return;
        }
        int totalValue = this.getCurrentValue();
        Button[] buttonArray = this.checkboxes;
        int n = this.checkboxes.length;
        int n2 = 0;
        while (n2 < n) {
            Button button;
            int value = (Integer)(button = buttonArray[n2]).getData("IntValue");
            button.setSelection((totalValue & value) != 0);
            ++n2;
        }
    }

    public void setToolTipText(String text) {
        super.setLabelToolTipText(text);
    }

    public void widgetSelected(SelectionEvent e) {
        Button button = (Button)e.widget;
        int value = (Integer)button.getData("IntValue");
        int totalValue = this.getCurrentValue();
        totalValue = button.getSelection() ? (totalValue |= value) : (totalValue &= ~value);
        this.setCurrentValue(totalValue);
    }

    protected void setCurrentValue(int value) {
        if (this.modelProperty != null) {
            this.refreshCheckboxes = false;
            this.modelProperty.setValue((Object)value);
            this.refreshCheckboxes = true;
        }
        this.currentValue = value;
        this.commit();
    }

    protected Integer getCurrentValue() {
        if (this.modelProperty != null) {
            Object value = this.modelProperty.getValue();
            return value == null ? 0 : (Integer)value;
        }
        return this.currentValue;
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public int getNumColumns() {
        return ((GridLayout)this.checkboxContainer.getLayout()).numColumns;
    }

    public void handleChange(ChangeEvent event) {
        this.refreshCheckboxes();
    }
}

