/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.helper.advice;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.core.util.CrossReferenceAdapter;
import org.eclipse.gmf.runtime.emf.type.core.edithelper.AbstractEditHelperAdvice;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyDependentsRequest;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.emf.utils.ServiceUtilsForEObject;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxis.NattableaxisPackage;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattablecell.ICellAxisWrapper;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattablecell.NattablecellPackage;

public class TableContentsAdviceHelper
extends AbstractEditHelperAdvice {
    protected ICommand getBeforeDestroyDependentsCommand(DestroyDependentsRequest request) {
        EObject destroyedElement = request.getElementToDestroy();
        return request.getDestroyDependentsCommand(this.getAssociatedElementToDestroy(destroyedElement));
    }

    protected ICommand getAfterDestroyDependentsCommand(DestroyDependentsRequest request) {
        return null;
    }

    protected List<EObject> getAssociatedElementToDestroy(EObject eobject) {
        CrossReferenceAdapter adapter = TableContentsAdviceHelper.getCrossReferenceAdapter(eobject);
        if (adapter != null) {
            Set elementsToDestroy = adapter.getInverseReferencers(eobject, NattableaxisPackage.eINSTANCE.getEObjectAxis_Element(), NattableaxisPackage.eINSTANCE.getEObjectAxis());
            elementsToDestroy.addAll(adapter.getInverseReferencers(eobject, NattablecellPackage.eINSTANCE.getEObjectAxisWrapper_Element(), NattablecellPackage.eINSTANCE.getEObjectAxisWrapper()));
            if (eobject instanceof ICellAxisWrapper) {
                elementsToDestroy.addAll(adapter.getInverseReferencers(eobject, NattablecellPackage.eINSTANCE.getCell_RowWrapper(), NattablecellPackage.eINSTANCE.getCell()));
                elementsToDestroy.addAll(adapter.getInverseReferencers(eobject, NattablecellPackage.eINSTANCE.getCell_ColumnWrapper(), NattablecellPackage.eINSTANCE.getCell()));
            }
            return new ArrayList<EObject>(elementsToDestroy);
        }
        return Collections.emptyList();
    }

    public static CrossReferenceAdapter getCrossReferenceAdapter(EObject element) {
        CrossReferenceAdapter crossReferenceAdapter = CrossReferenceAdapter.getExistingCrossReferenceAdapter((Notifier)element);
        if (crossReferenceAdapter == null) {
            TransactionalEditingDomain domain = null;
            try {
                domain = (TransactionalEditingDomain)ServiceUtilsForEObject.getInstance().getService(TransactionalEditingDomain.class, (Object)element);
            }
            catch (ServiceException serviceException) {
                // empty catch block
            }
            if (domain != null) {
                crossReferenceAdapter = CrossReferenceAdapter.getCrossReferenceAdapter((ResourceSet)domain.getResourceSet());
            }
        }
        return crossReferenceAdapter;
    }
}

