/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.nattable.provider;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.layer.LabelStack;
import org.eclipse.nebula.widgets.nattable.style.DisplayMode;
import org.eclipse.papyrus.infra.emf.nattable.provider.EMFEOperationHeaderLabelProvider;
import org.eclipse.papyrus.infra.nattable.manager.table.INattableModelManager;
import org.eclipse.papyrus.infra.nattable.model.nattable.Table;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxis.IAxis;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxis.OperationIdAxis;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattablelabelprovider.ILabelProviderConfiguration;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattablelabelprovider.ObjectLabelProviderConfiguration;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattablelabelprovider.OperationLabelProviderConfiguration;
import org.eclipse.papyrus.infra.nattable.utils.AxisUtils;
import org.eclipse.papyrus.infra.nattable.utils.ILabelProviderCellContextElementWrapper;
import org.eclipse.papyrus.infra.nattable.utils.ILabelProviderContextElementWrapper;
import org.eclipse.papyrus.infra.nattable.utils.LabelOperationConfigurationManagementUtils;
import org.eclipse.papyrus.infra.nattable.utils.NattableConfigAttributes;
import org.eclipse.papyrus.uml.internationalization.utils.utils.UMLLabelInternationalization;
import org.eclipse.papyrus.uml.nattable.utils.StereotypeOperationUtils;
import org.eclipse.swt.graphics.Image;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Operation;

public class StereotypeOperationHeaderLabelProvider
extends EMFEOperationHeaderLabelProvider {
    public boolean accept(Object element) {
        Object object;
        if (element instanceof ILabelProviderContextElementWrapper && (object = ((ILabelProviderContextElementWrapper)element).getObject()) instanceof OperationIdAxis) {
            String id = ((OperationIdAxis)object).getElement();
            return id != null && id.startsWith("operation_of_stereotype:/");
        }
        return false;
    }

    public String getText(Object element) {
        ILabelProviderContextElementWrapper wrapper = (ILabelProviderContextElementWrapper)element;
        IConfigRegistry configRegistry = wrapper.getConfigRegistry();
        INattableModelManager modelManager = (INattableModelManager)configRegistry.getConfigAttribute(NattableConfigAttributes.NATTABLE_MODEL_MANAGER_CONFIG_ATTRIBUTE, DisplayMode.NORMAL, new String[]{"nattable_model_manager_id"});
        Table table = modelManager.getTable();
        EObject tableContext = table.getContext();
        Object value = this.getWrappedValue(wrapper);
        String alias = "";
        if (value instanceof IAxis) {
            alias = ((IAxis)value).getAlias();
        }
        ILabelProviderConfiguration conf = null;
        if (wrapper instanceof ILabelProviderCellContextElementWrapper) {
            conf = this.getLabelConfiguration((ILabelProviderCellContextElementWrapper)wrapper);
        }
        Object returnedValue = null;
        if (conf instanceof ObjectLabelProviderConfiguration && !((ObjectLabelProviderConfiguration)conf).isDisplayLabel()) {
            returnedValue = "";
        } else {
            String id = AxisUtils.getPropertyId((Object)value);
            Operation operation = (Operation)StereotypeOperationUtils.getRealStereotypeOperation(tableContext, id);
            if (operation == null) {
                id = id.replace("operation_of_stereotype:/", "");
                returnedValue = id + " Required Profile not available";
                return returnedValue;
            }
            returnedValue = alias != null && !alias.isEmpty() ? alias : UMLLabelInternationalization.getInstance().getLabel((NamedElement)operation);
            if (conf != null) {
                if (alias != null && !alias.equals("")) {
                    returnedValue = alias;
                }
                returnedValue = this.getText((OperationLabelProviderConfiguration)conf, configRegistry, (String)returnedValue, operation.getType(), operation.getLower(), operation.getUpper());
            }
        }
        return returnedValue;
    }

    protected ILabelProviderConfiguration getLabelConfiguration(ILabelProviderCellContextElementWrapper wrapper) {
        OperationLabelProviderConfiguration conf = null;
        IConfigRegistry configRegistry = wrapper.getConfigRegistry();
        INattableModelManager modelManager = (INattableModelManager)configRegistry.getConfigAttribute(NattableConfigAttributes.NATTABLE_MODEL_MANAGER_CONFIG_ATTRIBUTE, DisplayMode.NORMAL, new String[]{"nattable_model_manager_id"});
        Table table = modelManager.getTable();
        if (wrapper instanceof ILabelProviderCellContextElementWrapper) {
            LabelStack labels = wrapper.getConfigLabels();
            if (labels.hasLabel("COLUMN_HEADER")) {
                conf = LabelOperationConfigurationManagementUtils.getUsedColumnOperationLabelConfiguration((Table)table);
            } else if (labels.hasLabel("ROW_HEADER")) {
                conf = LabelOperationConfigurationManagementUtils.getUsedRowOperationLabelConfiguration((Table)table);
            }
        }
        return conf;
    }

    public Image getImage(Object element) {
        Object value = this.getWrappedValue((ILabelProviderContextElementWrapper)element);
        IConfigRegistry configRegistry = ((ILabelProviderContextElementWrapper)element).getConfigRegistry();
        INattableModelManager modelManager = this.getAxisContentProvider(configRegistry);
        ILabelProviderConfiguration conf = this.getLabelConfiguration((ILabelProviderCellContextElementWrapper)element);
        if (conf instanceof ObjectLabelProviderConfiguration && !((ObjectLabelProviderConfiguration)conf).isDisplayIcon()) {
            return null;
        }
        EObject tableContext = modelManager.getTable().getContext();
        String id = AxisUtils.getPropertyId((Object)value);
        Operation operation = (Operation)StereotypeOperationUtils.getRealStereotypeOperation(tableContext, id);
        ILabelProvider p = this.getLabelProviderService(configRegistry).getLabelProvider((Object)operation);
        if (p != null) {
            return p.getImage((Object)operation);
        }
        return null;
    }
}

